/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.shutdown;

import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.shutdown.ShutDownReason;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ReasonOutOfFluid
implements ShutDownReason {
    private FluidStack requiredFluid;

    ReasonOutOfFluid(@NotNull FluidStack requiredFluid) {
        this.requiredFluid = requiredFluid;
    }

    @Override
    @NotNull
    public String getID() {
        return "out_of_fluid";
    }

    @Override
    @NotNull
    public String getDisplayString() {
        return Objects.requireNonNull(StatCollector.func_74837_a((String)"GT5U.gui.text.out_of_fluid", (Object[])new Object[]{this.requiredFluid.getLocalizedName(), GTUtility.formatNumbers(this.requiredFluid.amount)}));
    }

    @Override
    @NotNull
    public NBTTagCompound writeToNBT(@NotNull NBTTagCompound tag) {
        return this.requiredFluid.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        this.requiredFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
    }

    @Override
    @NotNull
    public ShutDownReason newInstance() {
        return new ReasonOutOfFluid(GTModHandler.getWater(0L));
    }

    @Override
    public void encode(@NotNull PacketBuffer buffer) {
        buffer.writeInt(this.requiredFluid.getFluidID());
        buffer.writeInt(this.requiredFluid.amount);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int fluidID = buffer.readInt();
        Fluid fluid = FluidRegistry.getFluid((int)fluidID);
        this.requiredFluid = new FluidStack(fluid, buffer.readInt());
    }

    @Override
    public boolean wasCritical() {
        return true;
    }
}

