/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.fluid.IFluidStore;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.tileentities.machines.multi.MTEAbstractMultiFurnace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEElectricBlastFurnace
extends MTEAbstractMultiFurnace<MTEElectricBlastFurnace>
implements ISurvivalConstructable {
    private int mHeatingCapacity = 0;
    protected final ArrayList<MTEHatchOutput> mPollutionOutputHatches = new ArrayList();
    protected final FluidStack[] pollutionFluidStacks = new FluidStack[]{Materials.CarbonDioxide.getGas(1000L), Materials.CarbonMonoxide.getGas(1000L), Materials.SulfurDioxide.getGas(1000L)};
    protected static final int CASING_INDEX = 11;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEElectricBlastFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ttt", "tmt", "ttt"}, {"CCC", "C-C", "CCC"}, {"CCC", "C-C", "CCC"}, {"b~b", "bbb", "bbb"}})).addElement('t', GTStructureUtility.buildHatchAdder(MTEElectricBlastFurnace.class).atLeast(HatchElement.OutputHatch.withAdder(MTEElectricBlastFurnace::addOutputHatchToTopList).withCount(t -> t.mPollutionOutputHatches.size())).casingIndex(11).dot(1).buildAndChain(GregTechAPI.sBlockCasings1, 11)).addElement('m', HatchElement.Muffler.newAny(11, 2)).addElement('C', GTStructureUtility.ofCoil(MTEAbstractMultiFurnace::setCoilLevel, MTEAbstractMultiFurnace::getCoilLevel)).addElement('b', GTStructureUtility.buildHatchAdder(MTEElectricBlastFurnace.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy).casingIndex(11).dot(1).buildAndChain(GregTechAPI.sBlockCasings1, 11)).build();

    public MTEElectricBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEElectricBlastFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEElectricBlastFurnace(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Blast Furnace").addInfo("You can use some fluids to reduce recipe time. Place the circuit in the Input Bus").addInfo("Each 900K over the min. Heat required reduces power consumption by 5% (multiplicatively)").addInfo("Each 1800K over the min. Heat allows for an overclock to be upgraded to a perfect overclock.").addInfo("That means the EBF will reduce recipe time by a factor 4 instead of 2 (giving 100% efficiency).").addInfo("Additionally gives +100K for every tier past MV").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 4, 3, true).addController("Front bottom").addCasingInfoRange("Heat Proof Machine Casing", 0, 15, false).addOtherStructurePart("Heating Coils", "Two middle Layers").addEnergyHatch("Any bottom layer casing", 3).addMaintenanceHatch("Any bottom layer casing", 3).addMufflerHatch("Top middle", 2).addInputBus("Any bottom layer casing", 3).addInputHatch("Any bottom layer casing", 3).addOutputBus("Any bottom layer casing", 3).addOutputHatch("Fluid outputs, Any bottom layer casing").addOutputHatch("Pollution gases (CO2/CO/SO2), Any top layer casing", 1).addStructureInfo("Pollution gas output amount scales with Muffler Hatch tier").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.gregtechproxy.mPollutionEBFPerSecond;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.blastFurnaceRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public IStructureDefinition<MTEElectricBlastFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setRecipeHeat(recipe.mSpecialValue).setMachineHeat(MTEElectricBlastFurnace.this.mHeatingCapacity).setHeatOC(true).setHeatDiscount(true);
            }

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                return recipe.mSpecialValue <= MTEElectricBlastFurnace.this.mHeatingCapacity ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat(recipe.mSpecialValue);
            }
        };
    }

    public boolean addOutputHatchToTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mPollutionOutputHatches.add((MTEHatchOutput)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mHeatingCapacity = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        this.mPollutionOutputHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        this.mHeatingCapacity = (int)this.getCoilLevel().getHeat() + 100 * (GTUtility.getTier(this.getMaxInputVoltage()) - 2);
        return true;
    }

    @Override
    public boolean addOutput(FluidStack aLiquid) {
        ArrayList tOutputHatches;
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        if (this.isPollutionFluid(tLiquid)) {
            tOutputHatches = this.mPollutionOutputHatches;
            this.multiplyPollutionFluidAmount(tLiquid);
        } else {
            tOutputHatches = this.mOutputHatches;
        }
        return MTEElectricBlastFurnace.dumpFluid(tOutputHatches, tLiquid, true) || MTEElectricBlastFurnace.dumpFluid(tOutputHatches, tLiquid, false);
    }

    protected boolean isPollutionFluid(@Nullable FluidStack fluidStack) {
        if (fluidStack == null) {
            return false;
        }
        for (FluidStack pollutionFluidStack : this.pollutionFluidStacks) {
            if (!fluidStack.isFluidEqual(pollutionFluidStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<? extends IFluidStore> getFluidOutputSlots(FluidStack[] toOutput) {
        if (Arrays.stream(toOutput).anyMatch(this::isPollutionFluid)) {
            return GTUtility.filterValidMTEs(this.mPollutionOutputHatches);
        }
        return GTUtility.filterValidMTEs(this.mOutputHatches);
    }

    protected void multiplyPollutionFluidAmount(@Nonnull FluidStack fluid) {
        fluid.amount = fluid.amount * Math.min(100 - this.getAveragePollutionPercentage(), 100) / 100;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : GTUtility.validMTEList(this.mEnergyHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.EBF.heat") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mHeatingCapacity) + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + this.getAveragePollutionPercentage() + EnumChatFormatting.RESET + " %"};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.inputSeparation = !this.inputSeparation;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("isBussesSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("isBussesSeparate");
        }
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_EBF_LOOP;
    }
}

