/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc.bees;

import forestry.api.apiculture.FlowerManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlower;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.genetics.ISpeciesRoot;
import gregtech.api.util.GTLanguageManager;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public enum GTFlowers implements IFlowerProvider,
IAlleleFlowers,
IChromosomeType
{
    FLAMING;

    private final boolean dominant;

    private GTFlowers() {
        this.dominant = true;
    }

    public static void doInit() {
        for (GTFlowers effect : GTFlowers.values()) {
            effect.register();
        }
    }

    public String getUID() {
        return "for.flowers." + this.toString().toLowerCase();
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IFlowerProvider getProvider() {
        return this;
    }

    public String getDescription() {
        return GTLanguageManager.getTranslation("for.flowers." + this.name().toLowerCase());
    }

    public void register() {
        for (ItemStack stack : this.getItemStacks()) {
            FlowerManager.flowerRegistry.registerAcceptableFlower(Block.func_149634_a((Item)stack.func_77973_b()), new String[]{this.getUID()});
        }
        AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{this});
    }

    public ItemStack[] getItemStacks() {
        if (this == FLAMING) {
            return new ItemStack[]{new ItemStack((Block)Blocks.field_150480_ab)};
        }
        return new ItemStack[0];
    }

    public boolean isAcceptedPollinatable(World world, IPollinatable pollinatable) {
        EnumSet types = pollinatable.getPlantType();
        return types.size() > 1 || !types.contains(EnumPlantType.Nether);
    }

    public boolean isAcceptedFlower(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (this == FLAMING) {
            return block == Blocks.field_150480_ab;
        }
        return false;
    }

    public boolean growFlower(World world, IIndividual individual, int x, int y, int z) {
        return false;
    }

    public ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
        return products;
    }

    public String getName() {
        return this.getDescription();
    }

    public String getUnlocalizedName() {
        return this.getUID();
    }

    public String getFlowerType() {
        return this.getUID();
    }

    public Set<IFlower> getFlowers() {
        return new HashSet<IFlower>();
    }

    public Class<? extends IAllele> getAlleleClass() {
        return ((Object)((Object)this)).getClass();
    }

    public ISpeciesRoot getSpeciesRoot() {
        return AlleleManager.alleleRegistry.getSpeciesRoot(this.getUID());
    }
}

