/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class MteHatchSteamBusInput
extends MTEHatch {
    public RecipeMap<?> mRecipeMap = null;
    public boolean disableSort;

    public MteHatchSteamBusInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, MteHatchSteamBusInput.getSlots(aTier), new String[]{"Item Input for Steam Multiblocks", "Shift + right click with screwdriver to toggle automatic item shuffling", "Capacity: 4 stacks", "Does not work with non-steam multiblocks", GTPPCore.GT_Tooltip.get()}, new ITexture[0]);
    }

    public MteHatchSteamBusInput(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    public MteHatchSteamBusInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 4, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        ITexture[] iTextureArray;
        if (GTMod.gregtechproxy.mRenderIndicatorsOnHatch) {
            ITexture[] iTextureArray2 = new ITexture[3];
            iTextureArray2[0] = aBaseTexture;
            iTextureArray2[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
            iTextureArray = iTextureArray2;
            iTextureArray2[2] = TextureFactory.of(Textures.BlockIcons.ITEM_IN_SIGN);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = aBaseTexture;
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_IN);
        }
        return iTextureArray;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MteHatchSteamBusInput(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        if (this.disableSort) {
            for (int i = 0; i < this.mInventory.length; ++i) {
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                this.mInventory[i] = null;
            }
        } else {
            for (int i = 0; i < this.mInventory.length; ++i) {
                for (int j = i + 1; j < this.mInventory.length; ++j) {
                    if (this.mInventory[j] == null || this.mInventory[i] != null && !GTUtility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                    GTUtility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("disableSort", this.disableSort);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.disableSort = aNBT.func_74767_n("disableSort");
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.disableSort = !this.disableSort;
            GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("200.1", "Automatic Item Shuffling: ") + (this.disableSort ? GTUtility.trans("087", "Disabled") : GTUtility.trans("088", "Enabled")));
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == this.getBaseMetaTileEntity().getFrontFacing() && (this.mRecipeMap == null || this.mRecipeMap.containsInput(aStack));
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[14][17][];
        for (byte c = -1; c < 16; c = (byte)(c + 1)) {
            if (rTextures[0][c + 1] == null) {
                rTextures[0][c + 1] = this.getSideFacingActive(c);
            }
            if (rTextures[1][c + 1] == null) {
                rTextures[1][c + 1] = this.getSideFacingInactive(c);
            }
            if (rTextures[2][c + 1] == null) {
                rTextures[2][c + 1] = this.getFrontFacingActive(c);
            }
            if (rTextures[3][c + 1] == null) {
                rTextures[3][c + 1] = this.getFrontFacingInactive(c);
            }
            if (rTextures[4][c + 1] == null) {
                rTextures[4][c + 1] = this.getTopFacingActive(c);
            }
            if (rTextures[5][c + 1] == null) {
                rTextures[5][c + 1] = this.getTopFacingInactive(c);
            }
            if (rTextures[6][c + 1] == null) {
                rTextures[6][c + 1] = this.getBottomFacingActive(c);
            }
            if (rTextures[7][c + 1] == null) {
                rTextures[7][c + 1] = this.getBottomFacingInactive(c);
            }
            if (rTextures[8][c + 1] == null) {
                rTextures[8][c + 1] = this.getBottomFacingPipeActive(c);
            }
            if (rTextures[9][c + 1] == null) {
                rTextures[9][c + 1] = this.getBottomFacingPipeInactive(c);
            }
            if (rTextures[10][c + 1] == null) {
                rTextures[10][c + 1] = this.getTopFacingPipeActive(c);
            }
            if (rTextures[11][c + 1] == null) {
                rTextures[11][c + 1] = this.getTopFacingPipeInactive(c);
            }
            if (rTextures[12][c + 1] == null) {
                rTextures[12][c + 1] = this.getSideFacingPipeActive(c);
            }
            if (rTextures[13][c + 1] != null) continue;
            rTextures[13][c + 1] = this.getSideFacingPipeInactive(c);
        }
        return rTextures;
    }

    public ITexture[] getSideFacingActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getSideFacingInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getFrontFacingActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getFrontFacingInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE)};
    }

    public ITexture[] getTopFacingActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP)};
    }

    public ITexture[] getTopFacingInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP)};
    }

    public ITexture[] getBottomFacingActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM)};
    }

    public ITexture[] getBottomFacingInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM)};
    }

    public ITexture[] getBottomFacingPipeActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomFacingPipeInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM : Textures.BlockIcons.MACHINE_BRONZE_BOTTOM), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getTopFacingPipeInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP : Textures.BlockIcons.MACHINE_BRONZE_TOP), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeActive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getSideFacingPipeInactive(byte aColor) {
        return new ITexture[]{new GTRenderedTexture(this.mTier == 1 ? Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE : Textures.BlockIcons.MACHINE_BRONZE_SIDE), new GTRenderedTexture(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.getBaseMetaTileEntity().add2by2Slots(builder, new IDrawable[0]);
    }
}

