/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class MTEIndustrialCokeOven
extends GTPPMultiBlockBase<MTEIndustrialCokeOven>
implements ISurvivalConstructable {
    private int mLevel = 0;
    private int mCasing;
    private int mCasing1;
    private int mCasing2;
    private static IStructureDefinition<MTEIndustrialCokeOven> STRUCTURE_DEFINITION = null;

    public MTEIndustrialCokeOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialCokeOven(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialCokeOven(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Coke Oven";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Processes Logs and Coal into Charcoal and Coal Coke.").addInfo("Gain 4% energy discount per voltage tier").addInfo("Process 12x materials with Heat Resistant Casings").addInfo("Or 24x materials with Heat Proof Casings").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front middle at bottom").addCasingInfoMin("Structural Coke Oven Casings", 8, false).addCasingInfoMin("Heat Resistant/Proof Coke Oven Casings", 8, false).addInputBus("Any Structural Coke Oven Casing", 1).addOutputBus("Any Structural Coke Oven Casing", 1).addInputHatch("Any Structural Coke Oven Casing", 1).addOutputHatch("Any Structural Coke Oven Casing", 1).addEnergyHatch("Any Structural Coke Oven Casing", 1).addMaintenanceHatch("Any Structural Coke Oven Casing", 1).addMufflerHatch("Any Structural Coke Oven Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialCokeOven> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addShape(this.mName + "1", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"aaa", "a-a", "aaa"}, {"C~C", "CCC", "CCC"}})).addShape(this.mName + "2", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"bbb", "b-b", "bbb"}, {"C~C", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialCokeOven.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(TAE.GTPP_INDEX(1)).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)1)))).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing1, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)2)), StructureUtility.onElementPass(x -> ++x.mCasing2, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)3))})).addElement('a', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)2)).addElement('b', StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)3)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        if (stackSize.field_77994_a == 1) {
            this.buildPiece(this.mName + "1", stackSize, hintsOnly, 1, 2, 0);
        } else {
            this.buildPiece(this.mName + "2", stackSize, hintsOnly, 1, 2, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        if (stackSize.field_77994_a == 1) {
            return this.survivialBuildPiece(this.mName + "1", stackSize, 1, 2, 0, elementBudget, env, false, true);
        }
        return this.survivialBuildPiece(this.mName + "2", stackSize, 1, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mCasing1 = 0;
        this.mCasing2 = 0;
        this.mLevel = 0;
        if (this.checkPiece(this.mName, 1, 2, 0)) {
            if (this.mCasing1 == 8) {
                this.mLevel = 1;
            }
            if (this.mCasing2 == 8) {
                this.mLevel = 2;
            }
            return this.mLevel > 0 && this.mCasing >= 8 && this.checkHatch();
        }
        return false;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCACokeOvenActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCACokeOven;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(1);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.cokeOvenRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)new ProcessingLogic().setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setEuModifier((100.0f - (float)(GTUtility.getTier(this.getMaxInputVoltage()) * 4)) / 100.0f);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mLevel * 12;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialCokeOven;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

