/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MTEIndustrialVacuumFreezer
extends GTPPMultiBlockBase<MTEIndustrialVacuumFreezer>
implements ISurvivalConstructable {
    public static int CASING_TEXTURE_ID;
    public static String mCryoFuelName;
    public static String mCasingName;
    public static String mHatchName;
    public static FluidStack mFuelStack;
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialVacuumFreezer> STRUCTURE_DEFINITION;
    private final ArrayList<MTEHatchCustomFluidBase> mCryotheumHatches = new ArrayList();

    public MTEIndustrialVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        mFuelStack = FluidUtils.getFluidStack("cryotheum", 1);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 10);
    }

    public MTEIndustrialVacuumFreezer(String aName) {
        super(aName);
        mFuelStack = FluidUtils.getFluidStack("cryotheum", 1);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 10);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialVacuumFreezer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Vacuum Freezer";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Advanced Vacuum Freezer").addInfo("Speed: +100% | EU Usage: 100% | Parallel: 4").addInfo("Consumes 10L of " + mCryoFuelName + "/s during operation").addInfo("Constructed exactly the same as a normal Vacuum Freezer").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin(mCasingName, 10, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addOtherStructurePart(mHatchName, "Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialVacuumFreezer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEIndustrialVacuumFreezer.class).adder(MTEIndustrialVacuumFreezer::addCryotheumHatch).hatchId(967).shouldReject(t -> !t.mCryotheumHatches.isEmpty()).casingIndex(CASING_TEXTURE_ID).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEIndustrialVacuumFreezer.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(CASING_TEXTURE_ID).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)10))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mCryotheumHatches.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    @Override
    public boolean checkHatch() {
        return super.checkHatch() && !this.mCryotheumHatches.isEmpty();
    }

    private boolean addCryotheumHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchCustomFluidBase && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileID() == 967) {
            return this.addToMachineListInternal(this.mCryotheumHatches, aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public void updateSlots() {
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mCryotheumHatches)) {
            tHatch.updateSlots();
        }
        super.updateSlots();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezerActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezer;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.advancedFreezerRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return (ProcessingLogic)((ProcessingLogic)new ProcessingLogic().setSpeedBonus(0.5)).setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialVacuumFreezer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mStartUpCheck < 0 && (this.mMaxProgresstime > 0 && this.mProgresstime != 0 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && (aTick % 20L == 0L || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && !this.depleteInputFromRestrictedHatches(this.mCryotheumHatches, 10)) {
            this.causeMaintenanceIssue();
            this.stopMachine(ShutDownReasonRegistry.outOfFluid(Objects.requireNonNull(FluidUtils.getFluidStack("cryotheum", 10))));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_ADV_FREEZER_LOOP;
    }

    static {
        mCryoFuelName = "Gelid Cryotheum";
        mCasingName = "Advanced Cryogenic Casing";
        mHatchName = "Cryotheum Hatch";
        STRUCTURE_DEFINITION = null;
    }
}

