/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.railcraft;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.BaseItemBurnable;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.railcraft.utils.RailcraftUtils;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class HandlerRailcraft {
    public static void preInit() {
        ModItems.itemCoalCoke = new BaseItemBurnable("itemCoalCoke", "Coking Coal", AddToCreativeTab.tabMisc, 64, 0, "Used for metallurgy.", "fuelCoke", 3200, 0).func_111206_d(Mods.GTPlusPlus.ID + ":burnables/itemCoalCoke");
        ModItems.itemCactusCharcoal = new BaseItemBurnable("itemCactusCharcoal", "Cactus Charcoal", AddToCreativeTab.tabMisc, 64, 0, "Used for smelting.", "fuelCactusCharcoal", 400, 0).func_111206_d(Mods.GTPlusPlus.ID + ":burnables/itemCactusCharcoal");
        ModItems.itemSugarCharcoal = new BaseItemBurnable("itemSugarCharcoal", "Sugar Charcoal", AddToCreativeTab.tabMisc, 64, 0, "Used for smelting.", "fuelSugarCharcoal", 400, 0).func_111206_d(Mods.GTPlusPlus.ID + ":burnables/itemSugarCharcoal");
        ModItems.itemCactusCoke = new BaseItemBurnable("itemCactusCoke", "Cactus Coke", AddToCreativeTab.tabMisc, 64, 0, "Used for smelting.", "fuelCactusCoke", 800, 0).func_111206_d(Mods.GTPlusPlus.ID + ":burnables/itemCactusCoke");
        ModItems.itemSugarCoke = new BaseItemBurnable("itemSugarCoke", "Sugar Coke", AddToCreativeTab.tabMisc, 64, 0, "Used for smelting.", "fuelSugarCoke", 800, 0).func_111206_d(Mods.GTPlusPlus.ID + ":burnables/itemSugarCoke");
        ItemUtils.addItemToOreDictionary(ItemUtils.getSimpleStack(ModItems.itemCactusCharcoal), "itemCharcoalCactus");
        ItemUtils.addItemToOreDictionary(ItemUtils.getSimpleStack(ModItems.itemCactusCoke), "itemCokeCactus");
        ItemUtils.addItemToOreDictionary(ItemUtils.getSimpleStack(ModItems.itemSugarCharcoal), "itemCharcoalSugar");
        ItemUtils.addItemToOreDictionary(ItemUtils.getSimpleStack(ModItems.itemSugarCoke), "itemCokeSugar");
    }

    public static void postInit() {
        HandlerRailcraft.generateCokeOvenRecipes();
    }

    private static void generateCokeOvenRecipes() {
        int i;
        ItemStack[] aInputs1 = new ItemStack[]{ItemUtils.getSimpleStack(Blocks.field_150434_aF), ItemUtils.getSimpleStack(Items.field_151120_aE)};
        ItemStack[] aInputs2 = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemCactusCharcoal), ItemUtils.getSimpleStack(ModItems.itemSugarCharcoal)};
        ItemStack[] aOutputs = new ItemStack[]{ItemUtils.getSimpleStack(ModItems.itemCactusCoke), ItemUtils.getSimpleStack(ModItems.itemSugarCoke)};
        for (i = 0; i < aOutputs.length; ++i) {
            GTValues.RA.stdBuilder().itemInputs(aInputs1[i], GTUtility.getIntegratedCircuit(3)).itemOutputs(aInputs2[i]).fluidOutputs(FluidUtils.getFluidStack("creosote", 100)).eut(16).duration(20).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aInputs1[i], GTUtility.getIntegratedCircuit(4)).itemOutputs(aInputs2[i]).fluidInputs(FluidUtils.getFluidStack("nitrogen", 100)).fluidOutputs(FluidUtils.getFluidStack("charcoal_byproducts", 200)).eut(16).duration(10).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aInputs2[i], GTUtility.getIntegratedCircuit(3)).itemOutputs(aOutputs[i]).fluidOutputs(FluidUtils.getFluidStack("creosote", 200)).eut(16).duration(40).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aInputs2[i], GTUtility.getIntegratedCircuit(4)).itemOutputs(aOutputs[i]).fluidInputs(FluidUtils.getFluidStack("nitrogen", 50)).fluidOutputs(FluidUtils.getFluidStack("charcoal_byproducts", 100)).eut(16).duration(20).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aOutputs[i], GTUtility.getIntegratedCircuit(5)).itemOutputs(Materials.Ash.getDustSmall(1)).fluidInputs(FluidUtils.getFluidStack("steam", 100)).fluidOutputs(Materials.WoodTar.getFluid(200L)).eut(240).duration(60).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aOutputs[i], GTUtility.getIntegratedCircuit(6)).itemOutputs(Materials.Ash.getDustSmall(1)).fluidInputs(FluidUtils.getFluidStack("steam", 100)).fluidOutputs(Materials.WoodGas.getGas(300L)).eut(60).duration(240).addTo(GTPPRecipeMaps.cokeOvenRecipes);
            GTValues.RA.stdBuilder().itemInputs(aInputs2[i]).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Ash, 1L)).outputChances(1000).fluidOutputs(Materials.WoodTar.getFluid(50L)).duration(30).eut(16).addTo(RecipeMaps.fluidExtractionRecipes);
            GTValues.RA.stdBuilder().itemInputs(aInputs2[i], GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Ash.getDustTiny(1)).fluidInputs(Materials.Oxygen.getGas(500L)).fluidOutputs(Materials.CarbonMonoxide.getGas(500L)).duration(80).eut(8).addTo(GTRecipeConstants.UniversalChemical);
            GTValues.RA.stdBuilder().itemInputs(aInputs2[i], GTUtility.getIntegratedCircuit(2)).itemOutputs(Materials.Ash.getDustTiny(1)).fluidInputs(Materials.Oxygen.getGas(2000L)).fluidOutputs(Materials.CarbonDioxide.getGas(1000L)).duration(40).eut(8).addTo(GTRecipeConstants.UniversalChemical);
        }
        if (Mods.Railcraft.isModLoaded()) {
            for (i = 0; i < aOutputs.length; ++i) {
                RailcraftUtils.addCokeOvenRecipe(aInputs1[i], true, true, aInputs2[i], FluidUtils.getFluidStack("creosote", 30), 500);
            }
            for (i = 0; i < aOutputs.length; ++i) {
                RailcraftUtils.addCokeOvenRecipe(aInputs2[i], true, true, aOutputs[i], FluidUtils.getFluidStack("creosote", 30), 500);
            }
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                for (i = 0; i < aOutputs.length; ++i) {
                    RailcraftUtils.addAdvancedCokeOvenRecipe(aInputs1[i], true, true, aInputs2[i], 20);
                }
                for (i = 0; i < aOutputs.length; ++i) {
                    RailcraftUtils.addAdvancedCokeOvenRecipe(aInputs2[i], true, true, aOutputs[i], 20);
                }
            }
        }
    }
}

