/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.base;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IOverclockDescriptionProvider;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.objects.GTChunkManager;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.overclockdescriber.FusionOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.IDualInputHatch;
import gregtech.common.tileentities.machines.multi.drone.MTEHatchDroneDownLink;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public abstract class MTELargeFusionComputer
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable,
IOverclockDescriptionProvider {
    public static final String MAIN_NAME = "largeFusion";
    public static final int M = 1000000;
    private boolean isLoadedChunk;
    public GTRecipe mLastRecipe;
    public int para;
    protected OverclockDescriber overclockDescriber;
    private static final ClassValue<IStructureDefinition<MTELargeFusionComputer>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTELargeFusionComputer>>(){

        @Override
        protected IStructureDefinition<MTELargeFusionComputer> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTELargeFusionComputer.MAIN_NAME, StructureUtility.transpose((String[][])new String[][]{L0, L1, L2, L3, L2, L1, L0})).addElement('H', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCoilBlock(), (int)x.getCoilMeta()))).addElement('C', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getCasingBlock(), (int)x.getCasingMeta()))).addElement('B', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)x.getGlassBlock(), (int)x.getGlassMeta()))).addElement('I', (IStructureElement)StructureUtility.lazy(x -> HatchElementBuilder.builder().atLeast(HatchElement.InputHatch.or(HatchElement.InputBus), HatchElement.OutputHatch).adder((rec$, x$0, x$1) -> ((MTELargeFusionComputer)rec$).addFluidIO(x$0, x$1)).casingIndex(x.textureIndex()).dot(1).hatchItemFilterAnd(x2 -> GTStructureUtility.filterByMTETier(x2.hatchTier(), Integer.MAX_VALUE)).buildAndChain(x.getGlassBlock(), x.getGlassMeta()))).addElement('E', (IStructureElement)StructureUtility.lazy(x -> HatchElementBuilder.builder().anyOf(TTMultiblockBase.HatchElement.EnergyMulti.or(HatchElement.Energy)).adder((rec$, x$0, x$1) -> ((MTELargeFusionComputer)rec$).addEnergyInjector(x$0, x$1)).casingIndex(x.textureIndex()).hatchItemFilterAnd(x2 -> GTStructureUtility.filterByMTETier(x2.hatchTier(), Integer.MAX_VALUE)).dot(2).buildAndChain(x.getCasingBlock(), x.getCasingMeta()))).addElement('F', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.ofFrame(x.getFrameBox()))).addElement('D', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.buildHatchAdder(MTELargeFusionComputer.class).adder((rec$, x$0, x$1) -> ((MTELargeFusionComputer)rec$).addDroneHatch(x$0, x$1)).hatchId(9401).casingIndex(x.textureIndex()).dot(3).buildAndChain(x.getCasingBlock(), x.getCasingMeta()))).build();
        }
    };
    protected long energyStorageCache;
    protected static final NumberFormatMUI numberFormat;
    public static final String[] L0;
    public static final String[] L1;
    public static final String[] L2;
    public static final String[] L3;

    public MTELargeFusionComputer(String name) {
        super(name);
        this.useLongPower = true;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    public MTELargeFusionComputer(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
        this.overclockDescriber = this.createOverclockDescriber();
    }

    protected OverclockDescriber createOverclockDescriber() {
        return new FusionOverclockDescriber((byte)this.tier(), this.capableStartupCanonical());
    }

    @Override
    @Nullable
    public OverclockDescriber getOverclockDescriber() {
        return this.overclockDescriber;
    }

    public abstract int tier();

    @Override
    public long maxEUStore() {
        return this.capableStartupCanonical() * (long)Math.min(32, this.mEnergyHatches.size() + this.eEnergyMulti.size()) / 32L;
    }

    public abstract long capableStartupCanonical();

    public abstract Block getCasingBlock();

    public abstract int getCasingMeta();

    public abstract Block getCoilBlock();

    public abstract int getCoilMeta();

    public abstract Block getGlassBlock();

    public abstract int getGlassMeta();

    public abstract int hatchTier();

    public abstract Materials getFrameBox();

    public abstract int getMaxPara();

    public abstract int extraPara(int var1);

    public int textureIndex() {
        return 53;
    }

    public abstract ITexture getTextureOverlay();

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GTItemStack aStack) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.eEnergyMulti.clear();
        return this.structureCheck_EM(MAIN_NAME, 23, 3, 40) && this.mInputHatches.size() + this.mDualInputHatches.size() != 0 && !this.mOutputHatches.isEmpty() && this.mEnergyHatches.size() + this.eEnergyMulti.size() != 0;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM(MAIN_NAME, 23, 3, 40, itemStack, b);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        return this.survivialBuildPiece(MAIN_NAME, stackSize, 23, 3, 40, realBudget, env, false, true);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && !aBaseMetaTileEntity.isAllowedToWork()) {
            GTChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
            this.isLoadedChunk = false;
        } else if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && !this.isLoadedChunk) {
            GTChunkManager.releaseTicket((TileEntity)aBaseMetaTileEntity);
            int offX = aBaseMetaTileEntity.getFrontFacing().offsetX;
            int offZ = aBaseMetaTileEntity.getFrontFacing().offsetZ;
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + 1 + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + 1 + offX, this.getChunkZ() - 1 + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + 1 + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() - 1 + offX, this.getChunkZ() - 1 + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() + 1 + offZ));
            GTChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity, new ChunkCoordIntPair(this.getChunkX() + offX, this.getChunkZ() - 1 + offZ));
            this.isLoadedChunk = true;
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            ++this.mTotalRunTime;
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad && this.checkMachine(aBaseMetaTileEntity, this.mInventory[1])) {
                this.checkRecipe();
            }
            if (this.mUpdated) {
                this.mUpdate = 50;
                this.mUpdated = false;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0 || this.cyclicUpdate_EM() || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) {
                if (this.mUpdate <= -1000) {
                    this.mUpdate = 5000;
                }
                this.checkStructure(true, aBaseMetaTileEntity);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (aBaseMetaTileEntity.getStoredEU() <= 0L && this.mMaxProgresstime > 0) {
                        this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                    }
                    long energyLimit = this.getSingleHatchPower();
                    List<MTEHatch> hatches = this.getExoticAndNormalEnergyHatchList();
                    for (MTEHatch hatch : GTUtility.validMTEList(hatches)) {
                        long consumableEnergy = Math.min(hatch.getEUVar(), energyLimit);
                        long receivedEnergy = Math.min(consumableEnergy, this.maxEUStore() - aBaseMetaTileEntity.getStoredEU());
                        if (receivedEnergy <= 0L) continue;
                        hatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(receivedEnergy, false);
                        aBaseMetaTileEntity.increaseStoredEnergyUnits(receivedEnergy, true);
                    }
                    if (this.mMaxProgresstime > 0) {
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(-this.lEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputItems != null) {
                                for (ItemStack itemStack : this.mOutputItems) {
                                    if (itemStack == null) continue;
                                    this.addOutput(itemStack);
                                }
                            }
                            if (this.mOutputFluids != null) {
                                for (ItemStack itemStack : this.mOutputFluids) {
                                    if (itemStack == null) continue;
                                    this.addOutput((FluidStack)itemStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1])));
                            this.mOutputItems = null;
                            this.mOutputFluids = null;
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            this.mLastWorkingTick = this.mTotalRunTime;
                            this.para = 0;
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe();
                            }
                        }
                    } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                        this.turnCasingActive(this.mMaxProgresstime > 0);
                        if (aBaseMetaTileEntity.isAllowedToWork() && this.checkRecipe()) {
                            if (aBaseMetaTileEntity.getStoredEU() < (long)this.mLastRecipe.mSpecialValue + this.lEUt) {
                                this.mMaxProgresstime = 0;
                                this.turnCasingActive(false);
                                this.stopMachine(ShutDownReasonRegistry.POWER_LOSS);
                            }
                            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)this.mLastRecipe.mSpecialValue + this.lEUt, false);
                        }
                        if (this.mMaxProgresstime <= 0) {
                            this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                        }
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.turnCasingActive(false);
                    this.mLastRecipe = null;
                    this.stopMachine(ShutDownReasonRegistry.STRUCTURE_INCOMPLETE);
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        } else {
            this.doActivitySound(this.getActivitySoundLoop());
        }
    }

    protected long getSingleHatchPower() {
        return GTValues.V[this.tier()] * (long)this.getMaxPara() * (long)this.extraPara(100) / 32L;
    }

    public boolean turnCasingActive(boolean status) {
        if (this.mEnergyHatches != null) {
            for (Object hatch : this.mEnergyHatches) {
                ((MTEHatch)hatch).updateTexture(status ? 52 : 53);
            }
        }
        if (this.eEnergyMulti != null) {
            for (Object hatch : this.eEnergyMulti) {
                ((MTEHatch)hatch).updateTexture(status ? 52 : 53);
            }
        }
        if (this.mOutputHatches != null) {
            for (Object hatch : this.mOutputHatches) {
                ((MTEHatch)hatch).updateTexture(status ? 52 : 53);
            }
        }
        if (this.mInputHatches != null) {
            for (Object hatch : this.mInputHatches) {
                ((MTEHatch)hatch).updateTexture(status ? 52 : 53);
            }
        }
        if (this.mDualInputHatches != null) {
            for (Object hatch : this.mDualInputHatches) {
                hatch.updateTexture(status ? 52 : 53);
            }
        }
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build(), this.getTextureOverlay()};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(52)};
        }
        return new ITexture[]{TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS).extFacing().build()};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 100;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.fusionRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -2;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(recipe).setConsumption(!MTELargeFusionComputer.this.mRunningOnLoad);
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return MTELargeFusionComputer.this.overclockDescriber.createCalculator(super.createOverclockCalculator(recipe), recipe);
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!MTELargeFusionComputer.this.mRunningOnLoad) {
                    if ((long)recipe.mSpecialValue > MTELargeFusionComputer.this.maxEUStore()) {
                        return CheckRecipeResultRegistry.insufficientStartupPower(recipe.mSpecialValue);
                    }
                    if ((long)recipe.mEUt > GTValues.V[MTELargeFusionComputer.this.tier()]) {
                        return CheckRecipeResultRegistry.insufficientPower(recipe.mEUt);
                    }
                }
                this.maxParallel = MTELargeFusionComputer.this.getMaxPara() * MTELargeFusionComputer.this.extraPara(recipe.mSpecialValue);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (MTELargeFusionComputer.this.mRunningOnLoad) {
                    MTELargeFusionComputer.this.mRunningOnLoad = false;
                }
                MTELargeFusionComputer.this.turnCasingActive(result.wasSuccessful());
                MTELargeFusionComputer.this.mLastRecipe = result.wasSuccessful() ? this.lastRecipe : null;
                MTELargeFusionComputer.this.para = this.getCurrentParallels();
                return result;
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.tier()]);
        logic.setAvailableAmperage(this.getSingleHatchPower() * 32L / GTValues.V[this.tier()]);
    }

    @Override
    public void onRemoval() {
        if (this.isLoadedChunk) {
            GTChunkManager.releaseTicket((TileEntity)this.getBaseMetaTileEntity());
        }
        super.onRemoval();
    }

    public int getChunkX() {
        return this.getBaseMetaTileEntity().getXCoord() >> 4;
    }

    public int getChunkZ() {
        return this.getBaseMetaTileEntity().getZCoord() >> 4;
    }

    private boolean addEnergyInjector(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            MTEHatchEnergy tHatch = (MTEHatchEnergy)aMetaTileEntity;
            if (tHatch.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add(tHatch);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            MTEHatchEnergyMulti tHatch = (MTEHatchEnergyMulti)aMetaTileEntity;
            if (tHatch.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            tHatch.updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add(tHatch);
        }
        return false;
    }

    private boolean addFluidIO(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        Object tInput;
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatch) {
            MTEHatch hatch = (MTEHatch)aMetaTileEntity;
            hatch.updateTexture(aBaseCasingIndex);
            hatch.updateCraftingIcon(this.getMachineCraftingIcon());
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            tInput = (MTEHatchInput)aMetaTileEntity;
            if (((MTEHatch)tInput).getTierForStructure() < this.hatchTier()) {
                return false;
            }
            ((MTEHatchInput)tInput).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add(tInput);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            MTEHatchOutput tOutput = (MTEHatchOutput)aMetaTileEntity;
            if (tOutput.getTierForStructure() < this.hatchTier()) {
                return false;
            }
            return this.mOutputHatches.add(tOutput);
        }
        if (aMetaTileEntity instanceof IDualInputHatch) {
            tInput = (IDualInputHatch)((Object)aMetaTileEntity);
            tInput.updateCraftingIcon(this.getMachineCraftingIcon());
            return this.mDualInputHatches.add(tInput);
        }
        return false;
    }

    private boolean addDroneHatch(IGregTechTileEntity aBaseMetaTileEntity, int aBaseCasingIndex) {
        if (aBaseMetaTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aBaseMetaTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (!(aMetaTileEntity instanceof MTEHatchDroneDownLink)) {
            return false;
        }
        MTEHatchDroneDownLink tHatch = (MTEHatchDroneDownLink)aMetaTileEntity;
        tHatch.updateTexture(aBaseCasingIndex);
        return this.addToMachineList(aBaseMetaTileEntity, aBaseCasingIndex);
    }

    public IStructureDefinition<MTELargeFusionComputer> getStructure_EM() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_FUSION_LOOP;
    }

    @Override
    public String[] getInfoData() {
        String string;
        IGregTechTileEntity baseMetaTileEntity = this.getBaseMetaTileEntity();
        switch (this.tier()) {
            case 6: {
                string = EnumChatFormatting.RED + "I" + EnumChatFormatting.RESET;
                break;
            }
            case 7: {
                string = EnumChatFormatting.RED + "II" + EnumChatFormatting.RESET;
                break;
            }
            case 8: {
                string = EnumChatFormatting.RED + "III" + EnumChatFormatting.RESET;
                break;
            }
            case 9: {
                string = EnumChatFormatting.RED + "IV" + EnumChatFormatting.RESET;
                break;
            }
            default: {
                string = EnumChatFormatting.GOLD + "V" + EnumChatFormatting.RESET;
            }
        }
        String tier = string;
        double plasmaOut = 0.0;
        if (this.mMaxProgresstime > 0) {
            plasmaOut = (double)this.mOutputFluids[0].amount / (double)this.mMaxProgresstime;
        }
        return new String[]{EnumChatFormatting.BLUE + "Fusion Reactor MK " + EnumChatFormatting.RESET + tier, StatCollector.func_74838_a((String)"scanner.info.UX.0") + ": " + EnumChatFormatting.LIGHT_PURPLE + GTUtility.formatNumbers(this.para) + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.fusion.req") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(-this.lEUt) + EnumChatFormatting.RESET + "EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(baseMetaTileEntity != null ? baseMetaTileEntity.getStoredEU() : 0L) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.maxEUStore()) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.fusion.plasma") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(plasmaOut) + EnumChatFormatting.RESET + "L/t"};
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)((Column)((Column)screenElements.widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.LargeFusion.0") + " " + numberFormat.format(this.energyStorageCache) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.LongSyncer(this::maxEUStore, val -> {
            this.energyStorageCache = val;
        }))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"gui.LargeFusion.1") + " " + numberFormat.format(this.getEUVar()) + " EU").setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.LongSyncer(this::getEUVar, this::setEUVar));
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    static {
        Textures.BlockIcons.setCasingTextureForId(52, TextureFactory.of(TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW).extFacing().glow().build()));
        numberFormat = new NumberFormatMUI();
        L0 = new String[]{"                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "  FFF                                     FFF  ", "  CCC                                     CCC  ", "  CIC                                     CIC  ", "  CBC                                     CBC  ", "  CIC                                     CIC  ", "  CCC                                     CCC  ", "  FFF                                     FFF  ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                                               ", "                    FCCCCCF                    ", "                    FCIBICF                    ", "                    FCCCCCF                    ", "                                               ", "                                               "};
        L1 = new String[]{"                                               ", "                    FCBBBCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCCC     CCCCCCC              ", "            CCCCCCC FCBBBCF CCCCCCC            ", "           CCCCC               CCCCC           ", "          CCCC                   CCCC          ", "         CCC                       CCC         ", "        CCC                         CCC        ", "       CCC                           CCC       ", "      CCC                             CCC      ", "     CCC                               CCC     ", "     CCC                               CCC     ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "  CCC                                     CCC  ", " FCCCF                                   FCCCF ", " C   C                                   C   C ", " B   B                                   B   B ", " B   B                                   B   B ", " B   B                                   B   B ", " C   C                                   C   C ", " FCCCF                                   FCCCF ", "  CCC                                     CCC  ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "   CCC                                   CCC   ", "    CCC                                 CCC    ", "    CCC                                 CCC    ", "     CCC                               CCC     ", "     CCC                               CCC     ", "      CCC                             CCC      ", "       CCC                           CCC       ", "        CCC                         CCC        ", "         CCC                       CCC         ", "          CCCC                   CCCC          ", "           CCCCC               CCCCC           ", "            CCCCCCC FCBBBCF CCCCCCC            ", "              CCCCCCC     CCCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCBBBCF                    ", "                                               "};
        L2 = new String[]{"                    FCCCCCF                    ", "                   CC     CC                   ", "                CCCCC     CCCCC                ", "              CCCCCHHHHHHHHHCCCCC              ", "            CCCCHHHCC     CCHHHCCCC            ", "           CCCHHCCCCC     CCCCCHHCCC           ", "          ECHHCCCCC FCCCCCF CCCCCHHCE          ", "         CCHCCCC               CCCCHCC         ", "        CCHCCC                   CCCHCC        ", "       CCHCE                       ECHCC       ", "      ECHCC                         CCHCE      ", "     CCHCE                           ECHCC     ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", " CCHCC                                   CCHCC ", "FCCHCCF                                 FCCHCCF", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "C  H  C                                 C  H  C", "FCCHCCF                                 FCCHCCF", " CCHCC                                   CCHCC ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "  CCHCC                                 CCHCC  ", "   CCHCC                               CCHCC   ", "   CCHCC                               CCHCC   ", "    CCHCC                             CCHCC    ", "    CCHCC                             CCHCC    ", "     CCHCE                           ECHCC     ", "      ECHCC                         CCHCE      ", "       CCHCE                       ECHCC       ", "        CCHCCC                   CCCHCC        ", "         CCHCCCC               CCCCHCC         ", "          ECHHCCCCC FCCDCCF CCCCCHHCE          ", "           CCCHHCCCCC     CCCCCHHCCC           ", "            CCCCHHHCC     CCHHHCCCC            ", "              CCCCCHHHHHHHHHCCCCC              ", "                CCCCC     CCCCC                ", "                   CC     CC                   ", "                    FCCCCCF                    "};
        L3 = new String[]{"                    FCIBICF                    ", "                   CC     CC                   ", "                CCCHHHHHHHHHCCC                ", "              CCHHHHHHHHHHHHHHHCC              ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "           CHHHHHHHCC     CCHHHHHHHC           ", "          CHHHHHCCC FCIBICF CCCHHHHHC          ", "         CHHHHCC               CCHHHHC         ", "        CHHHCC                   CCHHHC        ", "       CHHHC                       CHHHC       ", "      CHHHC                         CHHHC      ", "     CHHHC                           CHHHC     ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", " CHHHC                                   CHHHC ", "FCHHHCF                                 FCHHHCF", "C HHH C                                 C HHH C", "I HHH I                                 I HHH I", "B HHH B                                 B HHH B", "I HHH I                                 I HHH I", "C HHH C                                 C HHH C", "FCHHHCF                                 FCHHHCF", " CHHHC                                   CHHHC ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "  CHHHC                                 CHHHC  ", "   CHHHC                               CHHHC   ", "   CHHHC                               CHHHC   ", "    CHHHC                             CHHHC    ", "    CHHHC                             CHHHC    ", "     CHHHC                           CHHHC     ", "      CHHHC                         CHHHC      ", "       CHHHC                       CHHHC       ", "        CHHHCC                   CCHHHC        ", "         CHHHHCC               CCHHHHC         ", "          CHHHHHCCC FCI~ICF CCCHHHHHC          ", "           CHHHHHHHCC     CCHHHHHHHC           ", "            CCHHHHHHHHHHHHHHHHHHHCC            ", "              CCHHHHHHHHHHHHHHHCC              ", "                CCCHHHHHHHHHCCC                ", "                   CC     CC                   ", "                    FCIBICF                    "};
    }
}

