/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.config;

import com.gtnewhorizon.gtnhlib.config.Config;

@Config(modid="gregtech", category="machine_stats", configSubDirectory="GregTech", filename="MachineStats")
@Config.LangKey(value="GT5U.gui.config.machine_stats")
public class MachineStats {
    @Config.Comment(value={"Bronze solar boiler section"})
    public static BronzeSolarBoiler bronzeSolarBoiler = new BronzeSolarBoiler();
    @Config.Comment(value={"Steel solar boiler section"})
    public static SteelSolarBoiler steelSolarBoiler = new SteelSolarBoiler();
    @Config.Comment(value={"Machines section"})
    public static Machines machines = new Machines();
    @Config.Comment(value={"Mass fabricator section"})
    public static MassFabricator massFabricator = new MassFabricator();
    @Config.Comment(value={"Microwave energy transmitter section"})
    public static MicrowaveEnergyTransmitter microwaveEnergyTransmitter = new MicrowaveEnergyTransmitter();
    @Config.Comment(value={"Teleporter section"})
    public static Teleporter teleporter = new Teleporter();
    @Config.Comment(value={"Cleanroom section"})
    public static Cleanroom cleanroom = new Cleanroom();

    @Config.LangKey(value="GT5U.gui.config.machine_stats.bronze_solar_boiler")
    public static class BronzeSolarBoiler {
        @Config.Comment(value={"Number of run-time ticks before boiler starts calcification.", "100% calcification and minimal output will be reached at 2 times this."})
        @Config.DefaultInt(value=1080000)
        @Config.RequiresMcRestart
        public int calcificationTicks;
        @Config.Comment(value={"Number of ticks it takes to lose 1\u00b0C."})
        @Config.DefaultInt(value=45)
        @Config.RequiresMcRestart
        public int cooldownTicks;
        @Config.DefaultInt(value=120)
        @Config.RequiresMcRestart
        public int maxOutputPerSecond;
        @Config.DefaultInt(value=40)
        @Config.RequiresMcRestart
        public int minOutputPerSecond;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.steel_solar_boiler")
    public static class SteelSolarBoiler {
        @Config.Comment(value={"Number of run-time ticks before boiler starts calcification.", "100% calcification and minimal output will be reached at 2 times this."})
        @Config.DefaultInt(value=1080000)
        @Config.RequiresMcRestart
        public int calcificationTicks;
        @Config.Comment(value={"Number of ticks it takes to lose 1\u00b0C."})
        @Config.DefaultInt(value=75)
        @Config.RequiresMcRestart
        public int cooldownTicks;
        @Config.DefaultInt(value=360)
        @Config.RequiresMcRestart
        public int maxOutputPerSecond;
        @Config.DefaultInt(value=120)
        @Config.RequiresMcRestart
        public int minOutputPerSecond;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.machines")
    public static class Machines {
        @Config.Comment(value={"Controls the damageFactorLow variable in the maintenance damage equation."})
        @Config.DefaultInt(value=5)
        @Config.RequiresMcRestart
        public int damageFactorLow;
        @Config.Comment(value={"Controls the damageFactorHigh variable in the maintenance damage equation."})
        @Config.DefaultFloat(value=0.6f)
        @Config.RequiresMcRestart
        public float damageFactorHigh;
        @Config.Comment(value={"if true, disable maintenance checks."})
        @Config.DefaultBoolean(value=false)
        @Config.RequiresMcRestart
        public boolean disableMaintenanceChecks;
        @Config.Comment(value={"If true, allows for multiple eggs on the magical energy absorber."})
        @Config.DefaultBoolean(value=true)
        @Config.RequiresMcRestart
        public boolean allowMultipleEggs;
        @Config.Comment(value={"If true, requires at least a free face to open a machine gui."})
        @Config.DefaultBoolean(value=false)
        @Config.RequiresMcRestart
        public boolean forceFreeFace;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.mass_fabricator")
    public static class MassFabricator {
        @Config.Comment(value={"if true, requires UUA to run the mass fab."})
        @Config.DefaultBoolean(value=false)
        @Config.RequiresMcRestart
        public boolean requiresUUA;
        @Config.Comment(value={"Duration multiplier."})
        @Config.DefaultInt(value=3215)
        @Config.RequiresMcRestart
        public int durationMultiplier;
        @Config.Comment(value={"mb of UUA per UUM."})
        @Config.DefaultInt(value=1)
        @Config.RequiresMcRestart
        public int UUAPerUUM;
        @Config.Comment(value={"Speed bonus delivered by the UUA."})
        @Config.DefaultInt(value=40)
        @Config.RequiresMcRestart
        public int UUASpeedBonus;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.microwave_energy_transmitter")
    public static class MicrowaveEnergyTransmitter {
        @Config.Comment(value={"if true, it has a passive energy loss."})
        @Config.DefaultBoolean(value=true)
        @Config.RequiresMcRestart
        public boolean passiveEnergyUse;
        @Config.Comment(value={"max loss."})
        @Config.DefaultInt(value=50)
        @Config.RequiresMcRestart
        public int maxLoss;
        @Config.Comment(value={"max loss distance."})
        @Config.DefaultInt(value=10000)
        @Config.RequiresMcRestart
        public int maxLossDistance;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.teleporter")
    public static class Teleporter {
        @Config.Comment(value={"if true, allows interdim tp"})
        @Config.DefaultBoolean(value=true)
        @Config.RequiresMcRestart
        public boolean interDimensionalTPAllowed;
        @Config.Comment(value={"passive energy loss."})
        @Config.DefaultInt(value=2048)
        @Config.RequiresMcRestart
        public int passiveEnergyDrain;
        @Config.Comment(value={"power multiplier."})
        @Config.DefaultInt(value=100)
        @Config.RequiresMcRestart
        public int powerMultiplier;
    }

    @Config.LangKey(value="GT5U.gui.config.machine_stats.cleanroom")
    public static class Cleanroom {
        @Config.Comment(value={"Minimum number of plascrete blocks in a valid cleanroom."})
        @Config.RangeInt(min=0)
        @Config.DefaultInt(value=20)
        @Config.RequiresMcRestart
        public int minCasingCount;
        @Config.Comment(value={"Maximum percentage of plascrete blocks which can be replaced by other valid blocks: glass, doors, hatches, etc."})
        @Config.RangeInt(min=0, max=100)
        @Config.DefaultInt(value=30)
        @Config.RequiresMcRestart
        public int maxReplacementPercentage;
        @Config.Comment(value={"List of other blocks allowed as a part of the cleanroom. Format: <block name> or <block name>:<meta>."})
        @Config.DefaultStringList(value={"BW_GlasBlocks", "tile.openblocks.elevator", "tile.openblocks.elevator_rotating", "tile.blockTravelAnchor", "tile.blockCosmeticOpaque:2", "tile.extrautils:etherealglass"})
        @Config.RequiresMcRestart
        public String[] allowedBlocks;
    }
}

