/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.config.MachineStats;
import gregtech.common.tileentities.boilers.MTEBoiler;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEBoilerSolar
extends MTEBoiler {
    public static final String LPS_FMT = "%s L/s";
    private static final String localizedDescFormat = GTLanguageManager.addStringLocalization("gt.blockmachines.boiler.solar.desc.format", "Steam Power by the Sun%nProduces %sL of Steam per second%nCalcifies over time, reducing Steam output to %sL/s%nBreak and replace to descale");
    protected int calcificationTicks;
    protected int cooldownTicks;
    protected int maxOutputPerSecond;
    protected int minOutputPerSecond;
    protected final int basicTemperatureMod = 5;
    private int mRunTimeTicks;

    public MTEBoilerSolar(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[0], new ITexture[0]);
        this.calcificationTicks = MachineStats.bronzeSolarBoiler.calcificationTicks;
        this.cooldownTicks = MachineStats.bronzeSolarBoiler.cooldownTicks;
        this.maxOutputPerSecond = MachineStats.bronzeSolarBoiler.maxOutputPerSecond;
        this.minOutputPerSecond = MachineStats.bronzeSolarBoiler.minOutputPerSecond;
        this.basicTemperatureMod = 5;
        this.mRunTimeTicks = 0;
    }

    public MTEBoilerSolar(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.calcificationTicks = MachineStats.bronzeSolarBoiler.calcificationTicks;
        this.cooldownTicks = MachineStats.bronzeSolarBoiler.cooldownTicks;
        this.maxOutputPerSecond = MachineStats.bronzeSolarBoiler.maxOutputPerSecond;
        this.minOutputPerSecond = MachineStats.bronzeSolarBoiler.minOutputPerSecond;
        this.basicTemperatureMod = 5;
        this.mRunTimeTicks = 0;
    }

    public MTEBoilerSolar(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.calcificationTicks = MachineStats.bronzeSolarBoiler.calcificationTicks;
        this.cooldownTicks = MachineStats.bronzeSolarBoiler.cooldownTicks;
        this.maxOutputPerSecond = MachineStats.bronzeSolarBoiler.maxOutputPerSecond;
        this.minOutputPerSecond = MachineStats.bronzeSolarBoiler.minOutputPerSecond;
        this.basicTemperatureMod = 5;
        this.mRunTimeTicks = 0;
    }

    public int getMaxOutputPerSecond() {
        return this.maxOutputPerSecond;
    }

    @Override
    public String[] getDescription() {
        return String.format(localizedDescFormat, GTUtility.formatNumbers(this.getMaxOutputPerSecond()), GTUtility.formatNumbers(this.getMinOutputPerSecond())).split("\\R");
    }

    public int getMinOutputPerSecond() {
        return this.minOutputPerSecond;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[4][17][];
        for (int color = -1; color < 16; ++color) {
            int i = color + 1;
            short[] colorModulation = Dyes.getModulation(color, Dyes._NULL.mRGBa);
            rTextures[0][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM, colorModulation)};
            rTextures[1][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP, colorModulation), TextureFactory.of(Textures.BlockIcons.BOILER_SOLAR)};
            rTextures[2][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, colorModulation)};
            rTextures[3][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        int i = colorIndex + 1;
        if ((sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0) {
            if (sideDirection != facingDirection) {
                return this.mTextures[2][i];
            }
            return this.mTextures[3][i];
        }
        return this.mTextures[sideDirection.ordinal()][i];
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mRunTime", this.mRunTimeTicks);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRunTimeTicks = aNBT.func_74762_e("mRunTime");
    }

    @Override
    protected void produceSteam(int aAmount) {
        super.produceSteam(aAmount);
        if (this.mFluid.isFluidEqual(GTModHandler.getWater(1L))) {
            this.mRunTimeTicks = this.mRunTimeTicks >= 0 && this.mRunTimeTicks < 0x7FFFFFF5 ? (this.mRunTimeTicks += 10) : Integer.MAX_VALUE;
        }
    }

    @Override
    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        this.pushSteamToSide(aBaseMetaTileEntity, aBaseMetaTileEntity.getFrontFacing());
    }

    @Override
    protected int getPollution() {
        return 0;
    }

    @Override
    public int getProductionPerSecond() {
        if (this.mTemperature < 100) {
            return 0;
        }
        if (this.mRunTimeTicks > this.getMaxRuntimeTicks()) {
            return this.getMinOutputPerSecond();
        }
        if (this.mRunTimeTicks > this.getCalcificationTicks()) {
            return this.getMaxOutputPerSecond() - this.getMaxOutputPerSecond() * (this.mRunTimeTicks - this.getCalcificationTicks()) / this.getCalcificationTicks();
        }
        return this.getMaxOutputPerSecond();
    }

    protected int getCalcificationTicks() {
        return this.calcificationTicks;
    }

    protected int getCooldownTicks() {
        return this.cooldownTicks;
    }

    protected int getMaxRuntimeTicks() {
        return (this.getMaxOutputPerSecond() - this.getMinOutputPerSecond()) * this.getCalcificationTicks() / this.getMaxOutputPerSecond() + this.getCalcificationTicks();
    }

    @Override
    protected int getMaxTemperature() {
        return 500;
    }

    @Override
    protected int getEnergyConsumption() {
        return 5;
    }

    @Override
    protected int getCooldownInterval() {
        return this.getCooldownTicks() / 5;
    }

    @Override
    protected int getHeatUpAmount() {
        return 5;
    }

    @Override
    protected void updateFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        boolean weatherClear;
        World world = aBaseMetaTileEntity.getWorld();
        if (aTick % 240L != 0L || world.func_72911_I()) {
            return;
        }
        if (!aBaseMetaTileEntity.getSkyAtSide(ForgeDirection.UP)) {
            return;
        }
        boolean bl = weatherClear = !world.func_72896_J() || aBaseMetaTileEntity.getBiome().field_76751_G == 0.0f;
        if (!weatherClear && world.field_73008_k >= 4) {
            return;
        }
        this.mProcessingEnergy = weatherClear ? (world.func_72935_r() ? (this.mProcessingEnergy += 40) : (this.mProcessingEnergy += 5)) : (this.mProcessingEnergy += 5);
    }

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.BRONZE;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return String.format("Heat Capacity: " + EnumChatFormatting.GREEN + "%s %%" + EnumChatFormatting.RESET + "    Hot time: " + EnumChatFormatting.RED + "%s s" + EnumChatFormatting.RESET + "%nMin output: " + EnumChatFormatting.RED + LPS_FMT + EnumChatFormatting.RESET + "    Max output: " + EnumChatFormatting.RED + LPS_FMT + EnumChatFormatting.RESET + "%nCurrent Output: " + EnumChatFormatting.YELLOW + LPS_FMT + EnumChatFormatting.RESET, GTUtility.formatNumbers(this.getHeatCapacityPercent()), GTUtility.formatNumbers(this.getHotTimeSeconds()), GTUtility.formatNumbers(this.getMinOutputPerSecond()), GTUtility.formatNumbers(this.getMaxOutputPerSecond()), GTUtility.formatNumbers(this.getProductionPerSecond())).split("\\R");
    }

    public int getHeatCapacityPercent() {
        return this.mTemperature * 100 / this.maxProgresstime();
    }

    public int getHotTimeSeconds() {
        return this.mRunTimeTicks / 20;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBoilerSolar(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected Widget createFuelSlot() {
        return null;
    }

    @Override
    protected SlotWidget createAshSlot() {
        return null;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        currentTip.add(String.format(SpecialChars.GOLD + "Solar Boiler Output: " + SpecialChars.RESET + "%d/%d L/s", tag.func_74762_e("calcificationOutput"), tag.func_74762_e("maxCalcificationOutput")));
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("calcificationOutput", this.getProductionPerSecond());
        tag.func_74768_a("maxCalcificationOutput", this.getMaxOutputPerSecond());
    }
}

