/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.drone;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.multi.drone.DroneConnection;
import gregtech.common.tileentities.machines.multi.drone.MTEDroneCentre;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEHatchDroneDownLink
extends MTEHatchMaintenance {
    private Vec3Impl downlinkCoord;
    private DroneConnection connection;
    private MTEMultiBlockBase machine;
    private static final IIconContainer moduleActive = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_DRONE_MODULE_ACTIVE");

    public MTEHatchDroneDownLink(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public MTEHatchDroneDownLink(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures, false);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Built-in powerful navigation beacon!"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(moduleActive)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(moduleActive)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDroneDownLink(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.downlinkCoord = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.hasConnection()) {
                if (this.connection.centre.getBaseMetaTileEntity().isActive()) {
                    this.doNormalMaintain();
                }
            } else if (aTick % 200L == 0L) {
                this.connection = null;
                this.tryFindConnection();
            }
        }
    }

    private void doNormalMaintain() {
        this.mSolderingTool = true;
        this.mCrowbar = true;
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mScrewdriver = true;
        this.mWrench = true;
        this.connection.machine.mSolderingTool = true;
        this.connection.machine.mCrowbar = true;
        this.connection.machine.mHardHammer = true;
        this.connection.machine.mSoftHammer = true;
        this.connection.machine.mScrewdriver = true;
        this.connection.machine.mWrench = true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (side == aBaseMetaTileEntity.getFrontFacing()) {
            if (aPlayer instanceof FakePlayer) {
                return false;
            }
            if (this.connection == null || !this.connection.isValid()) {
                aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.noconnection", new Object[0]));
                return false;
            }
            GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
            return true;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public void onRemoval() {
        if (this.hasConnection()) {
            this.connection.machine = null;
        }
    }

    private boolean hasConnection() {
        if (this.connection == null) {
            return false;
        }
        if (this.connection.isValid()) {
            return true;
        }
        return this.connection.reCheckConnection();
    }

    private void tryFindConnection() {
        if (MTEDroneCentre.getCentreMap().containsKey((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g)) {
            List target = MTEDroneCentre.getCentreMap().get((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g).stream().collect(Collectors.toList());
            for (MTEDroneCentre centre : target) {
                MTEMultiBlockBase machine;
                if (!centre.getCoords().withinDistance(this.downlinkCoord, (double)centre.getRange()) || !centre.getBaseMetaTileEntity().isActive() || (machine = this.tryFindCoreGTMultiBlock()) == null || !machine.isValid()) continue;
                this.machine = machine;
                this.connection = new DroneConnection(machine, centre);
                this.connection.centre.getConnectionList().add(this.connection);
                return;
            }
        }
    }

    private MTEMultiBlockBase tryFindCoreGTMultiBlock() {
        LinkedList<ChunkCoordinates> tQueue = new LinkedList<ChunkCoordinates>();
        HashSet<ChunkCoordinates> visited = new HashSet<ChunkCoordinates>(80);
        tQueue.add(this.getBaseMetaTileEntity().getCoords());
        World world = this.getBaseMetaTileEntity().getWorld();
        while (!tQueue.isEmpty()) {
            IGregTechTileEntity te;
            IMetaTileEntity iMetaTileEntity;
            boolean isMachineBlock;
            ChunkCoordinates aCoords = (ChunkCoordinates)tQueue.poll();
            TileEntity tTileEntity = world.func_147438_o(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
            Block block = world.func_147439_a(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c);
            boolean bl = isMachineBlock = GregTechAPI.isMachineBlock(block, world.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c)) || block == GregTechAPI.sBlockReinforced && world.func_72805_g(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c) == 2;
            if (tTileEntity instanceof IGregTechTileEntity && (iMetaTileEntity = (te = (IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof MTEMultiBlockBase) {
                MTEMultiBlockBase mte = (MTEMultiBlockBase)iMetaTileEntity;
                if (mte.mMaintenanceHatches.contains(this)) {
                    return mte;
                }
            }
            if (visited.size() >= 5 && (!(tTileEntity instanceof IMachineBlockUpdateable) || !((IMachineBlockUpdateable)tTileEntity).isMachineBlockUpdateRecursive()) && !isMachineBlock) continue;
            ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.field_71574_a + 1, aCoords.field_71572_b, aCoords.field_71573_c);
            if (visited.add(tCoords)) {
                tQueue.add(tCoords);
            }
            if (visited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a - 1, aCoords.field_71572_b, aCoords.field_71573_c))) {
                tQueue.add(tCoords);
            }
            if (visited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b + 1, aCoords.field_71573_c))) {
                tQueue.add(tCoords);
            }
            if (visited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b - 1, aCoords.field_71573_c))) {
                tQueue.add(tCoords);
            }
            if (visited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c + 1))) {
                tQueue.add(tCoords);
            }
            if (!visited.add(tCoords = new ChunkCoordinates(aCoords.field_71574_a, aCoords.field_71572_b, aCoords.field_71573_c - 1))) continue;
            tQueue.add(tCoords);
        }
        return null;
    }

    @Override
    public boolean doesBindPlayerInventory() {
        return false;
    }

    @Override
    public int getGUIWidth() {
        return 150;
    }

    @Override
    public int getGUIHeight() {
        return 40;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(135, 3))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.drone_custom_name")).setTextAlignment(Alignment.Center).setPos(0, 5).setSize(150, 8))).widget(new TextFieldWidget().setGetter(() -> this.connection == null ? "" : this.connection.getCustomName(false)).setSetter(var -> {
            if (this.connection != null) {
                this.connection.setCustomName((String)var);
            }
        }).setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.dark(1)).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD_LIGHT_GRAY.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 16).setSize(130, 16))).build();
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74757_a("connection", this.connection == null);
        if (this.connection != null) {
            tag.func_74768_a("x", this.connection.centreCoord.field_71574_a);
            tag.func_74768_a("y", this.connection.centreCoord.field_71572_b);
            tag.func_74768_a("z", this.connection.centreCoord.field_71573_c);
            tag.func_74778_a("name", this.connection.customName);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74767_n("connection")) {
            currenttip.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.waila.drone_downlink.noConnection"));
        } else {
            currenttip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"GT5U.waila.drone_downlink.connection") + tag.func_74762_e("x") + " " + tag.func_74762_e("y") + " " + tag.func_74762_e("z"));
            currenttip.add(EnumChatFormatting.YELLOW + tag.func_74779_i("name"));
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }
}

