/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.covers;

import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.XSTR;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class CoverToggleVisual
extends CoverBehavior {
    private static final Map<String, Integer> sConnectionStateForEntityMap = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, String> sPrefixMap = new ConcurrentHashMap<String, String>();
    private static final int VALUE_OFF = 0;
    private static final int VALUE_ON = 1;

    public static String generateUniqueKey(ForgeDirection side, ICoverable aEntity) {
        try {
            BlockPos aPos = new BlockPos(aEntity.getIGregTechTileEntity(aEntity.getXCoord(), aEntity.getYCoord(), aEntity.getZCoord()));
            return aEntity.func_145825_b() + "." + aPos.getUniqueIdentifier() + side.name();
        }
        catch (Throwable aPos) {
            XSTR x = new XSTR();
            return "ERROR." + x.getSeed() + x.hashCode() + x.nextDouble() + ".ID";
        }
    }

    @Override
    public boolean onCoverRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        PlayerUtils.messagePlayer(aPlayer, GTUtility.trans("756", "Connectable: ") + CoverToggleVisual.getConnectionState(aCoverVariable));
        return super.onCoverRightclick(side, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        return super.onCoverScrewdriverclick(side, aCoverID, aCoverVariable, aTileEntity, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        try {
            String aKey = CoverToggleVisual.generateUniqueKey(side, aTileEntity);
            Integer b = sConnectionStateForEntityMap.get(aKey);
            if (b != null && aCoverVariable != b) {
                aCoverVariable = b;
            }
            if (b == null) {
                b = aCoverVariable;
                sConnectionStateForEntityMap.put(aKey, b);
                CoverToggleVisual.trySetState(side, b == 1 ? 1 : 0, aTileEntity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return CoverToggleVisual.getConnectionState(aCoverVariable);
    }

    @Override
    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return super.alwaysLookConnected(side, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public byte getRedstoneInput(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        if (!CoverToggleVisual.getConnectionState(aCoverVariable)) {
            return 0;
        }
        return super.getRedstoneInput(side, aInputRedstone, aCoverID, aCoverVariable, aTileEntity);
    }

    @Override
    public void placeCover(ForgeDirection side, ItemStack aCover, ICoverable aTileEntity) {
        String aKey = CoverToggleVisual.generateUniqueKey(side, aTileEntity);
        boolean state = CoverToggleVisual.getCoverConnections(aCover);
        sPrefixMap.put(aKey, aCover.func_77977_a());
        Logger.INFO("Mapping key " + aKey + " to " + state);
        sConnectionStateForEntityMap.put(aKey, state ? 1 : 0);
        Logger.INFO("Key Value: " + (state ? 1 : 0));
        super.placeCover(side, aCover, aTileEntity);
    }

    @Override
    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        String aKey = CoverToggleVisual.generateUniqueKey(side, aTileEntity);
        sConnectionStateForEntityMap.remove(aKey);
        return true;
    }

    public static boolean getConnectionState(int aCoverVar) {
        return aCoverVar == 1;
    }

    private static void trySetState(ForgeDirection side, int aState, ICoverable aTile) {
        if (aTile instanceof IGregTechTileEntity) {
            IGregTechTileEntity gTileEntity = (IGregTechTileEntity)aTile;
            gTileEntity.setCoverDataAtSide(side, new ISerializableObject.LegacyCoverData(aState));
        }
    }

    public static boolean getConnectionState(ForgeDirection side, ICoverable aTile) {
        String aKey = CoverToggleVisual.generateUniqueKey(side, aTile);
        return CoverToggleVisual.getConnectionState(aKey);
    }

    public static boolean getConnectionState(String aKey) {
        Integer b = sConnectionStateForEntityMap.get(aKey);
        return b != null && b == 1;
    }

    public static boolean getCoverConnections(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("CustomCoverMeta")) != null) {
            return aNBT.func_74767_n("AllowConnections");
        }
        return false;
    }
}

