/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.cover;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gtPlusPlus.core.tileentities.base.TileEntityBase;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import tectech.mechanics.enderStorage.EnderFluidContainer;
import tectech.mechanics.enderStorage.EnderLinkTag;
import tectech.mechanics.enderStorage.EnderWorldSavedData;

public class CoverEnderFluidLink
extends CoverBehavior {
    private static final int L_PER_TICK = 8000;
    private static final int IMPORT_EXPORT_MASK = 1;
    private static final int PUBLIC_PRIVATE_MASK = 2;

    private void transferFluid(IFluidHandler source, ForgeDirection side, IFluidHandler target, ForgeDirection tSide, int amount) {
        FluidStack fluidStack = source.drain(side, amount, false);
        if (fluidStack != null) {
            int fluidTransferred = target.fill(tSide, fluidStack, true);
            source.drain(side, fluidTransferred, true);
        }
    }

    private static boolean testBit(int aCoverVariable, int bitMask) {
        return (aCoverVariable & bitMask) != 0;
    }

    private static int toggleBit(int aCoverVariable, int bitMask) {
        return aCoverVariable ^ bitMask;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IFluidHandler) {
            IFluidHandler teTank = (IFluidHandler)aTileEntity;
            EnderLinkTag tag = EnderWorldSavedData.getEnderLinkTag((IFluidHandler)aTileEntity);
            if (tag != null) {
                boolean isPrivate;
                boolean shouldBePrivate = CoverEnderFluidLink.testBit(aCoverVariable, 2);
                boolean bl = isPrivate = tag.getUUID() != null;
                if (shouldBePrivate != isPrivate) {
                    tag = new EnderLinkTag(tag.getFrequency(), shouldBePrivate ? CoverEnderFluidLink.getOwner(aTileEntity) : null);
                    EnderWorldSavedData.bindEnderLinkTag(teTank, tag);
                }
                EnderFluidContainer enderTank = EnderWorldSavedData.getEnderFluidContainer(tag);
                if (CoverEnderFluidLink.testBit(aCoverVariable, 1)) {
                    this.transferFluid(enderTank, ForgeDirection.UNKNOWN, teTank, side, 8000);
                } else {
                    this.transferFluid(teTank, side, enderTank, ForgeDirection.UNKNOWN, 8000);
                }
            }
        }
        return aCoverVariable;
    }

    private static UUID getOwner(Object te) {
        if (te instanceof IGregTechTileEntity) {
            IGregTechTileEntity igte = (IGregTechTileEntity)te;
            return igte.getOwnerUuid();
        }
        if (te instanceof TileEntityBase) {
            TileEntityBase teb = (TileEntityBase)te;
            return teb.getOwnerUUID();
        }
        return null;
    }

    @Override
    public void onBaseTEDestroyed(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        if (aTileEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)aTileEntity;
            EnderWorldSavedData.unbindTank(fluidHandlerSelf);
        }
    }

    @Override
    public boolean onCoverRemoval(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, boolean aForced) {
        if (aTileEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)aTileEntity;
            EnderWorldSavedData.unbindTank(fluidHandlerSelf);
        }
        return true;
    }

    @Override
    public String getDescription(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int newCoverVariable = CoverEnderFluidLink.toggleBit(aCoverVariable, 1);
        if (CoverEnderFluidLink.testBit(aCoverVariable, 1)) {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Suction Engaged!");
        } else {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Filling Engaged!");
        }
        return newCoverVariable;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        if (buildContext.getTile() instanceof IFluidHandler) {
            return new EnderFluidLinkUIFactory(buildContext).createWindow();
        }
        return null;
    }

    private class EnderFluidLinkUIFactory
    extends CoverBehaviorBase.UIFactory {
        private static final int START_X = 10;
        private static final int START_Y = 25;
        private static final int SPACE_X = 18;
        private static final int SPACE_Y = 18;
        private static final int PUBLIC_BUTTON_ID = 0;
        private static final int PRIVATE_BUTTON_ID = 1;
        private static final int IMPORT_BUTTON_ID = 2;
        private static final int EXPORT_BUTTON_ID = 3;

        public EnderFluidLinkUIFactory(CoverUIBuildContext buildContext) {
            super(CoverEnderFluidLink.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            TextFieldWidget frequencyField = new TextFieldWidget();
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(frequencyField.setGetter(() -> {
                ICoverable te = this.getUIBuildContext().getTile();
                if (!frequencyField.isClient() && te instanceof IFluidHandler) {
                    EnderLinkTag tag = EnderWorldSavedData.getEnderLinkTag((IFluidHandler)te);
                    return tag == null ? "" : tag.getFrequency();
                }
                return "";
            }).setSetter(val -> {
                ICoverable patt7277$temp;
                if (!frequencyField.isClient() && (patt7277$temp = this.getUIBuildContext().getTile()) instanceof IFluidHandler) {
                    IFluidHandler tank = (IFluidHandler)patt7277$temp;
                    UUID uuid = null;
                    if (CoverEnderFluidLink.testBit(CoverEnderFluidLink.convert((ISerializableObject.LegacyCoverData)this.getCoverData()), 2) && !(uuid = this.getUUID()).equals(CoverEnderFluidLink.getOwner(tank))) {
                        return;
                    }
                    EnderWorldSavedData.bindEnderLinkTag(tank, new EnderLinkTag((String)val, uuid));
                }
            }).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 25).setSize(82, 12))).widget(new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, CoverEnderFluidLink.this, (id, coverData) -> !this.getClickable((int)id, CoverEnderFluidLink.convert(coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, CoverEnderFluidLink.convert(coverData)))).addToggleButton(0, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(GTUtility.trans("326", "Public")).setPos(10, 61)).addToggleButton(1, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_BLACKLIST).addTooltip(GTUtility.trans("327", "Private")).setPos(28, 61)).addToggleButton(2, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GTUtility.trans("007", "Import")).setPos(10, 79)).addToggleButton(3, CoverDataFollowerToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GTUITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GTUtility.trans("006", "Export")).setPos(28, 79)))).widget(new TextWidget(GTUtility.trans("328", "Channel")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 29))).widget(new TextWidget(GTUtility.trans("329", "Public/Private")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 65))).widget(new TextWidget(GTUtility.trans("229", "Import/Export")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 83));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: 
                case 1: {
                    return CoverEnderFluidLink.toggleBit(coverVariable, 2);
                }
                case 2: 
                case 3: {
                    return CoverEnderFluidLink.toggleBit(coverVariable, 1);
                }
            }
            return coverVariable;
        }

        private boolean getClickable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    return CoverEnderFluidLink.testBit(coverVariable, 2);
                }
                case 1: {
                    return !CoverEnderFluidLink.testBit(coverVariable, 2);
                }
                case 2: {
                    return CoverEnderFluidLink.testBit(coverVariable, 1);
                }
                case 3: {
                    return !CoverEnderFluidLink.testBit(coverVariable, 1);
                }
            }
            return false;
        }

        private UUID getUUID() {
            return this.getUIBuildContext().getPlayer().func_110124_au();
        }
    }
}

