/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis.mega;

import bartworks.common.configs.Configuration;
import bartworks.common.tileentities.multis.mega.MegaMultiBlockBase;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.blocks.BlockCasingsAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class MTEMegaVacuumFreezer
extends MegaMultiBlockBase<MTEMegaVacuumFreezer>
implements ISurvivalConstructable {
    private int mCasingFrostProof = 0;
    private int mTier = 1;
    private static final ArrayList<SubspaceCoolingFluid> SUBSPACE_COOLING_FLUIDS = new ArrayList<SubspaceCoolingFluid>(Arrays.asList(new SubspaceCoolingFluid(MaterialsUEVplus.SpaceTime, 1, 7500L), new SubspaceCoolingFluid(MaterialsUEVplus.Space, 2, 5000L), new SubspaceCoolingFluid(MaterialsUEVplus.Eternity, 3, 2500L)));
    private SubspaceCoolingFluid currentCoolingFluid = null;
    private static final int CASING_INDEX = 17;
    private static final int CASING_INDEX_T2 = ((BlockCasingsAbstract)GregTechAPI.sBlockCasings8).getTextureIndex(14);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_MAIN_T2 = "main_t2";
    private static final String[][] structure = StructureUtility.transpose((String[][])new String[][]{{"AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAA~AAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA", "AAAAAAAAAAAAAAA"}});
    private static final String[][] structure_tier2 = new String[][]{{"AAAAAAAAAAAAAAA", "ABBBBBBBBBBBBBA", "ABAAAAAAAAAAABA", "ABABBBBBBBBBABA", "ABABAAAAAAABABA", "ABABABBBBBABABA", "ABABABAAABABABA", "ABABABA~ABABABA", "ABABABAAABABABA", "ABABABBBBBABABA", "ABABAAAAAAABABA", "ABABBBBBBBBBABA", "ABAAAAAAAAAAABA", "ABBBBBBBBBBBBBA", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "B             B", "B             B", "B             B", "B             B", "B             B", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "B             B", "A             A", "A             A", "A             A", "B             B", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "B             B", "A             A", "A             A", "A             A", "B             B", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "B             B", "A             A", "A             A", "A             A", "B             B", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "B             B", "B             B", "B             B", "B             B", "B             B", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "A             A", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "B             B", "AAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAA", "ABBBBBBBBBBBBBA", "ABAAAAAAAAAAABA", "ABABBBBBBBBBABA", "ABABAAAAAAABABA", "ABABABBBBBABABA", "ABABABAAABABABA", "ABABABAAABABABA", "ABABABAAABABABA", "ABABABBBBBABABA", "ABABAAAAAAABABA", "ABABBBBBBBBBABA", "ABAAAAAAAAAAABA", "ABBBBBBBBBBBBBA", "AAAAAAAAAAAAAAA"}};
    private static final IStructureDefinition<MTEMegaVacuumFreezer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addShape("main_t2", structure_tier2).addElement('A', GTStructureUtility.buildHatchAdder(MTEMegaVacuumFreezer.class).atLeast(HatchElement.Energy.or(HatchElement.ExoticEnergy), HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputHatch, HatchElement.OutputBus, HatchElement.Maintenance).casingIndex(17).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasingFrostProof, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)1)))).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)14)).build();

    public MTEMegaVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMegaVacuumFreezer(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMegaVacuumFreezer(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Vacuum Freezer, MVF").addInfo("Cools hot ingots and cells").addParallelInfo(Configuration.Multiblocks.megaMachinesMax).addTecTechHatchInfo().addUnlimitedTierSkips().addSeparator().addInfo("Upgrade to Tier 2 to unlock " + EnumChatFormatting.LIGHT_PURPLE + "Subspace Cooling.").addInfo("To activate " + EnumChatFormatting.LIGHT_PURPLE + "Subspace Cooling " + EnumChatFormatting.GRAY + "supply a coolant while running recipes.").addInfo(EnumChatFormatting.RED + "7500 L/s " + EnumChatFormatting.DARK_PURPLE + "Molten SpaceTime" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.RED + "1" + EnumChatFormatting.GRAY + " perfect overclock.").addInfo(EnumChatFormatting.RED + "5000 L/s " + EnumChatFormatting.DARK_PURPLE + "Spatially Enlarged Fluid" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.RED + "2" + EnumChatFormatting.GRAY + " perfect overclocks.").addInfo(EnumChatFormatting.RED + "2500 L/s " + EnumChatFormatting.DARK_PURPLE + "Molten Eternity" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.RED + "3" + EnumChatFormatting.GRAY + " perfect overclocks.").addSeparator().addInfo(EnumChatFormatting.LIGHT_PURPLE + "Reinforcing the structure allows the injection of exotic coolants,").addInfo(EnumChatFormatting.LIGHT_PURPLE + "enabling the capture of heat energy in miniature tears in spacetime,").addInfo(EnumChatFormatting.LIGHT_PURPLE + "massively increasing the efficiency of the cooling process.").beginStructureBlock(15, 15, 15, true).addController("Front center").addEnergyHatch("Any Frost Proof Machine Casing", 1).addMaintenanceHatch("Any Frost Proof Machine Casing", 1).addInputHatch("Any Frost Proof Machine Casing", 1).addOutputHatch("Any Frost Proof Machine Casing", 1).addInputBus("Any Frost Proof Machine Casing", 1).addOutputBus("Any Frost Proof Machine Casing", 1).addStructureInfo(EnumChatFormatting.BLUE + "Base Multi (Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addCasingInfoMinColored("Frost Proof Machine Casing", EnumChatFormatting.GRAY, 800, EnumChatFormatting.GOLD, false).addStructureInfo(EnumChatFormatting.BLUE + "Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.BLUE + " (Upgrades from Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.BLUE + "):").addCasingInfoMinColored("Frost Proof Machine Casing", EnumChatFormatting.GRAY, 700, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Infinity Cooled Casing", EnumChatFormatting.GRAY, 384, EnumChatFormatting.GOLD, false).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEMegaVacuumFreezer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack aStack, boolean aHintsOnly) {
        if (aStack.field_77994_a == 1) {
            this.buildPiece(STRUCTURE_PIECE_MAIN, aStack, aHintsOnly, 7, 7, 0);
        } else {
            this.buildPiece(STRUCTURE_PIECE_MAIN_T2, aStack, aHintsOnly, 7, 7, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        int realBudget;
        if (this.mMachine) {
            return -1;
        }
        int n = realBudget = elementBudget >= 200 ? elementBudget : Math.min(200, elementBudget * 5);
        if (stackSize.field_77994_a == 1) {
            return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 7, 7, 0, realBudget, source, actor, false, true);
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN_T2, stackSize, 7, 7, 0, realBudget, source, actor, false, true);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.vacuumFreezerRecipes;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mUseMultiparallelMode");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return super.onWireCutterRightClick(side, wrenchingSide, aPlayer, aX, aY, aZ, aTool);
    }

    public SubspaceCoolingFluid findSubspaceCoolingFluid() {
        for (MTEHatchInput hatch : this.mInputHatches) {
            Optional<SubspaceCoolingFluid> fluid = SUBSPACE_COOLING_FLUIDS.stream().filter(candidate -> this.drain(hatch, candidate.getStack(), false)).findFirst();
            if (!fluid.isPresent()) continue;
            return fluid.get();
        }
        return null;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                if (MTEMegaVacuumFreezer.this.mTier == 1) {
                    return super.createOverclockCalculator(recipe);
                }
                MTEMegaVacuumFreezer.this.currentCoolingFluid = MTEMegaVacuumFreezer.this.findSubspaceCoolingFluid();
                return super.createOverclockCalculator(recipe).setMachineHeat(MTEMegaVacuumFreezer.this.currentCoolingFluid == null ? 0 : ((MTEMegaVacuumFreezer)MTEMegaVacuumFreezer.this).currentCoolingFluid.perfectOverclocks * 1800).setRecipeHeat(0).setHeatOC(true).setHeatDiscount(false);
            }
        }.noRecipeCaching().setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return Configuration.Multiblocks.megaMachinesMax;
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime > 0 && aTick % 20L == 0L && this.mTier == 2 && this.currentCoolingFluid != null) {
            FluidStack fluid = this.currentCoolingFluid.getStack();
            for (MTEHatchInput hatch : this.mInputHatches) {
                if (!this.drain(hatch, fluid, false)) continue;
                this.drain(hatch, fluid, true);
                return;
            }
            this.stopMachine(ShutDownReasonRegistry.outOfFluid(fluid));
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingFrostProof = 0;
        this.mTier = 1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 7, 7, 0)) {
            this.mCasingFrostProof = 0;
            if (!this.checkPiece(STRUCTURE_PIECE_MAIN_T2, 7, 7, 0)) {
                return false;
            }
            this.mTier = 2;
        }
        return this.mMaintenanceHatches.size() == 1 && this.mCasingFrostProof >= 700;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] rTexture = side == facing ? (aActive ? new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.casingTexturePages[0][17]};
        return rTexture;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(StatCollector.func_74837_a((String)"BW.infoData.mega_vacuum_freezer.tier", (Object[])new Object[]{this.mTier}));
        if (this.mTier == 2) {
            if (this.currentCoolingFluid != null) {
                info.add(StatCollector.func_74837_a((String)"BW.infoData.mega_vacuum_freezer.subspace_cooling.active", (Object[])new Object[]{this.currentCoolingFluid.getStack().getLocalizedName()}));
            } else {
                info.add(StatCollector.func_74838_a((String)"BW.infoData.mega_vacuum_freezer.subspace_cooling.inactive"));
            }
        }
        return info.toArray(new String[0]);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_MEGA_VACUUM_FREEZER_LOOP;
    }

    private static class SubspaceCoolingFluid {
        public Materials material;
        public int perfectOverclocks;
        public long amount;

        public SubspaceCoolingFluid(Materials material, int perfectOverclocks, long amount) {
            this.material = material;
            this.perfectOverclocks = perfectOverclocks;
            this.amount = amount;
        }

        public FluidStack getStack() {
            FluidStack stack = this.material.getFluid(this.amount);
            if (stack == null) {
                return this.material.getMolten(this.amount);
            }
            return stack;
        }
    }
}

