/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.tiered;

import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.util.GTUtility;
import net.minecraftforge.fluids.FluidStack;

public class MTECompressedFluidHatch
extends MTEHatchInput {
    public MTECompressedFluidHatch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0);
        this.mDescriptionArray[1] = "Capacity: 100,000,000L";
    }

    public MTECompressedFluidHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public int getCapacity() {
        return 100000000;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GTUtility.areFluidsEqual(aFluid, Materials.LiquidAir.getFluid(1L)) || GTUtility.areFluidsEqual(aFluid, Materials.NetherSemiFluid.getFluid(1L));
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECompressedFluidHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected FluidSlotWidget createFluidSlot() {
        return super.createFluidSlot().setFilter(f -> f == Materials.LiquidAir.mFluid || f == Materials.NetherSemiFluid.mFluid);
    }
}

