/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util.accessprioritylist;

import bartworks.util.accessprioritylist.AccessPriorityListIterators;
import bartworks.util.accessprioritylist.AccessPriorityListNode;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Spliterator;
import org.apache.commons.lang3.NotImplementedException;

public class AccessPriorityList<E>
implements List<E>,
Deque<E>,
Set<E> {
    transient int size = 0;
    transient AccessPriorityListNode<E> head;
    transient AccessPriorityListNode<E> tail;

    public static <E> AccessPriorityList<E> create() {
        return new AccessPriorityList<E>();
    }

    @Override
    public void addFirst(E t) {
        AccessPriorityListNode<E> first = this.head;
        AccessPriorityListNode<E> newNode = new AccessPriorityListNode<E>(null, t, first);
        this.head = newNode;
        if (first == null) {
            this.tail = newNode;
        } else {
            first.setBefore(newNode);
        }
        ++this.size;
    }

    @Override
    public void addLast(E t) {
        AccessPriorityListNode<E> last = this.tail;
        AccessPriorityListNode<E> newNode = new AccessPriorityListNode<E>(last, t, null);
        this.tail = newNode;
        if (last == null) {
            this.head = newNode;
        } else {
            last.setNext(newNode);
        }
        ++this.size;
    }

    @Override
    public boolean offerFirst(E e) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean offerLast(E e) {
        throw new NotImplementedException("");
    }

    @Override
    public E removeFirst() {
        E first = this.head.getELEMENT();
        AccessPriorityListNode<E> node = this.head;
        this.head = node.getNext();
        this.head.setBefore(null);
        node.destroy();
        --this.size;
        return first;
    }

    @Override
    public E removeLast() {
        E last = this.tail.getELEMENT();
        AccessPriorityListNode<E> node = this.tail;
        this.tail = node.getBefore();
        this.tail.setNext(null);
        node.destroy();
        --this.size;
        return last;
    }

    @Override
    public E pollFirst() {
        throw new NotImplementedException("");
    }

    @Override
    public E pollLast() {
        throw new NotImplementedException("");
    }

    @Override
    public E getFirst() {
        return this.peekFirst();
    }

    @Override
    public E getLast() {
        return this.peekLast();
    }

    @Override
    public E peekFirst() {
        return this.head != null ? (E)this.head.getELEMENT() : null;
    }

    @Override
    public E peekLast() {
        return this.tail != null ? (E)this.tail.getELEMENT() : null;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public Iterator<E> iterator() {
        return new AccessPriorityListIterators.AccessPriorityListIterator<E>(this.head);
    }

    public Iterator<AccessPriorityListNode<E>> nodeIterator() {
        return new AccessPriorityListIterators.AccessPriorityListNodeIterator<E>(this.head);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new AccessPriorityListIterators.AccessPriorityListReverseIterator<E>(this.tail);
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.size];
        int index = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            ret[index] = it.next();
            ++index;
        }
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] ret = new Object[this.size];
        int index = 0;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            ret[index] = it.next();
            ++index;
        }
        return ret;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    private void moveNodeUp(AccessPriorityListNode<E> node) {
        if (node == this.head || node.getBefore() == null) {
            return;
        }
        AccessPriorityListNode<E> before = node.getBefore();
        AccessPriorityListNode<E> beforeBefore = before.getBefore();
        AccessPriorityListNode<E> next = node.getNext();
        node.setBefore(beforeBefore);
        if (beforeBefore != null) {
            beforeBefore.setNext(node);
        } else {
            this.head = node;
        }
        before.setBefore(node);
        before.setNext(next);
        if (next != null) {
            next.setBefore(before);
        } else {
            this.tail = before;
        }
        node.setNext(before);
    }

    AccessPriorityListNode<E> getNode(int index) {
        if (index <= this.size / 2) {
            AccessPriorityListNode<E> x = this.head;
            for (int i = 0; i < index; ++i) {
                x = x.getNext();
            }
            return x;
        }
        AccessPriorityListNode<E> x = this.tail;
        for (int i = this.size - 1; i > index; --i) {
            x = x.getBefore();
        }
        return x;
    }

    @Override
    public boolean offer(E e) {
        throw new NotImplementedException("");
    }

    private boolean isValidIndex(int index) {
        if (index >= 0 && index < this.size) {
            return true;
        }
        throw new ArrayIndexOutOfBoundsException("NOT A VAILD INDEX!");
    }

    @Override
    public E remove() {
        throw new NotImplementedException("");
    }

    @Override
    public E poll() {
        return this.removeFirst();
    }

    @Override
    public E element() {
        throw new NotImplementedException("");
    }

    @Override
    public E peek() {
        return this.getFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        c.forEach(this::addLast);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new NotImplementedException("");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplementedException("");
    }

    @Override
    public void clear() {
        if (this.tail != null) {
            AccessPriorityListNode node = this.tail;
            while (node.getBefore() != null) {
                node.setNext(null);
                node.setPriority(0L);
                node = node.getBefore();
                node.getNext().setBefore(null);
            }
            this.size = 0;
            this.head = null;
            this.tail = null;
        }
    }

    public void addPrioToNode(AccessPriorityListNode<E> node) {
        this.addPrioToNode(node, 1L);
    }

    public void addPrioToNode(AccessPriorityListNode<E> node, long prio) {
        long current = node.getPriority();
        if (current == Long.MAX_VALUE || current > 0L && prio > 0L && prio + current < 0L) {
            node.setPriority(Long.MAX_VALUE);
        } else {
            node.setPriority(current + prio);
        }
        while (node.getBefore() != null && node.getPriority() >= node.getBefore().getPriority()) {
            this.moveNodeUp(node);
        }
    }

    public void addPrioToNode(int index, long prio) {
        if (!this.isValidIndex(index)) {
            return;
        }
        AccessPriorityListNode<E> node = this.getNode(index);
        this.addPrioToNode(node, prio);
    }

    public void addPrioToNode(int index) {
        this.addPrioToNode(index, 1L);
    }

    @Override
    public E get(int index) {
        if (!this.isValidIndex(index)) {
            return null;
        }
        AccessPriorityListNode<E> node = this.getNode(index);
        return node.getELEMENT();
    }

    @Override
    public E set(int index, E element) {
        throw new NotImplementedException("");
    }

    @Override
    public void add(int index, E element) {
        throw new NotImplementedException("");
    }

    @Override
    public E remove(int index) {
        throw new NotImplementedException("");
    }

    @Override
    public int indexOf(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new NotImplementedException("");
    }

    @Override
    public ListIterator<E> listIterator() {
        return new AccessPriorityListIterators.AccessPriorityListListIterator<E>(this.head, this.tail, false);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new AccessPriorityListIterators.AccessPriorityListListIterator(this, index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new NotImplementedException("");
    }

    @Override
    public Spliterator<E> spliterator() {
        throw new NotImplementedException("");
    }
}

