/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg.command;

import appeng.api.util.WorldCoord;
import appeng.items.storage.ItemSpatialStorageCell;
import galacticgreg.GalacticGreg;
import galacticgreg.auxiliary.PlayerChatHelper;
import galacticgreg.schematics.SpaceSchematic;
import galacticgreg.schematics.SpaceSchematicFactory;
import gregtech.commands.GTBaseCommand;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AEStorageCommand
extends GTBaseCommand {
    public AEStorageCommand() {
        super("exportae");
    }

    public String func_71517_b() {
        return "exportae";
    }

    @Override
    public String func_71518_a(ICommandSender pCommandSender) {
        return "exportae <structure name>";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        try {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                if (args.length < 1) {
                    return;
                }
                String tName = args[0];
                ItemStack tIS = player.field_71071_by.func_70448_g();
                Item item = tIS.func_77973_b();
                if (item instanceof ItemSpatialStorageCell) {
                    ItemSpatialStorageCell tCell = (ItemSpatialStorageCell)item;
                    World tSpatialWorld = tCell.getWorld(tIS);
                    WorldCoord storedSize = tCell.getStoredSize(tIS);
                    if (storedSize.x == 0 || storedSize.y == 0 || storedSize.z == 0) {
                        PlayerChatHelper.SendError(sender, "Error: This spatial storage is empty");
                        return;
                    }
                    GalacticGreg.Logger.info("Creating Structure from Spatial AE drive. Dimensions: X [%d] Y [%d] Z [%d]", storedSize.x, storedSize.y, storedSize.z);
                    SpaceSchematic tSchematic = SpaceSchematicFactory.createSchematic(tName);
                    boolean tTEWarningSend = false;
                    for (int lX = 1; lX <= storedSize.x; ++lX) {
                        for (int lY = 65; lY < 65 + storedSize.y; ++lY) {
                            for (int lZ = 1; lZ <= storedSize.z; ++lZ) {
                                Block b = tSpatialWorld.func_147439_a(lX, lY, lZ);
                                int bm = tSpatialWorld.func_72805_g(lX, lY, lZ);
                                String tBlockName = Block.field_149771_c.func_148750_c((Object)b);
                                TileEntity bTE = tSpatialWorld.func_147438_o(lX, lY, lZ);
                                String tMsg = String.format("[X-%d][Y-%d][Z-%d] ", lX, lY, lZ);
                                String nbtComp = "";
                                if (b == null) continue;
                                tMsg = tMsg + tBlockName;
                                if (bTE != null) {
                                    GalacticGreg.Logger.warn("Warning: Found TileEntity at X[%d] Y[%d] Z[%d]. NBT States are not exported!", lX, lY, lZ);
                                    if (!tTEWarningSend) {
                                        tTEWarningSend = true;
                                        PlayerChatHelper.SendWarn(sender, "TileEntity states are not exported!");
                                    }
                                }
                                if (b == Blocks.field_150350_a) continue;
                                tSchematic.addStructureInfo(SpaceSchematicFactory.createStructureInfo(lX, lY, lZ, b, bm));
                            }
                        }
                    }
                    if (!GalacticGreg.SchematicHandler.SaveSpaceStructure(tSchematic)) {
                        PlayerChatHelper.SendError(sender, "Something went wrong. Structure not saved");
                    } else {
                        PlayerChatHelper.SendInfo(sender, "Structure has been exported to " + tSchematic.getName() + ".xml. It contains " + tSchematic.coordInfo().size() + " Blocks");
                        PlayerChatHelper.SendInfo(sender, "You have to edit the file before a reload will accept it!");
                    }
                } else {
                    PlayerChatHelper.SendError(sender, "Error: Item in your hand is not a spatial storage drive!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return AEStorageCommand.isOpedPlayer(sender);
    }
}

