/*
 * Decompiled with CFR 0.152.
 */
package ggfab;

import ggfab.api.GGFabRecipeMaps;
import ggfab.api.GigaGramFabAPI;
import ggfab.items.SingleUseTool;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

class SingleUseToolRecipeLoader
implements Runnable {
    public static final int RECIPE_DURATION = 120;
    public static final int OUTPUT_QUANTITY_MIN = 128;
    public static final int OUTPUT_QUANTITY_MAX = 256;

    SingleUseToolRecipeLoader() {
    }

    @Override
    public void run() {
        this.addSingleUseToolRecipes(Materials.Steel, SingleUseTool.HARD_TOOLS);
        this.addSingleUseToolRecipes(Materials.Silver, SingleUseTool.HARD_TOOLS);
        this.addSingleUseToolRecipes(Materials.VanadiumSteel, SingleUseTool.HARD_TOOLS);
        this.addSingleUseToolRecipes(Materials.TungstenSteel, SingleUseTool.HARD_TOOLS);
        this.addSingleUseToolRecipes(Materials.HSSG, SingleUseTool.HARD_TOOLS);
        this.addSingleUseToolRecipes(Materials.Rubber, SingleUseTool.SOFT_TOOLS);
        this.addSingleUseToolRecipes(Materials.StyreneButadieneRubber, SingleUseTool.SOFT_TOOLS);
        this.addSingleUseToolRecipes(Materials.Silicone, SingleUseTool.SOFT_TOOLS);
        for (SingleUseTool singleUseTool : SingleUseTool.values()) {
            GTModHandler.addCraftingRecipe(singleUseTool.mold.get(1L, new Object[0]), new Object[]{"h", "P", "I", Character.valueOf('P'), ItemList.Shape_Empty, Character.valueOf('I'), singleUseTool.toolDictName});
        }
    }

    private static double findDivisor(long fluidPerCraft, long outputQuantity) {
        for (long i = outputQuantity / 256L; i < Math.min(fluidPerCraft, outputQuantity); ++i) {
            if (fluidPerCraft % i != 0L || outputQuantity % i != 0L || outputQuantity / i > 256L) continue;
            return i;
        }
        return (double)outputQuantity / 256.0;
    }

    private void addSingleUseToolRecipes(Materials material, List<SingleUseTool> singleUseTools) {
        if (material.mStandardMoltenFluid == null) {
            throw new IllegalArgumentException("material does not have molten fluid form");
        }
        for (SingleUseTool singleUseTool : singleUseTools) {
            IToolStats toolStats = GigaGramFabAPI.SINGLE_USE_TOOLS.get((Object)singleUseTool.toolDictName);
            Long toolCost = GigaGramFabAPI.COST_SINGLE_USE_TOOLS.get((Object)singleUseTool.toolDictName);
            if (toolStats == null || toolCost == null) {
                throw new IllegalArgumentException((Object)((Object)singleUseTool) + " not registered");
            }
            float durabilityMultiplier = toolStats.getMaxDurabilityMultiplier();
            int damagePerCraft = toolStats.getToolDamagePerContainerCraft();
            long fluidPerCraft = toolCost * 144L / 3628800L;
            long recipeDuration = 120L;
            long outputQuantity = (long)((float)material.mDurability * durabilityMultiplier * 100.0f / (float)damagePerCraft);
            if (outputQuantity > 256L) {
                double divisor = SingleUseToolRecipeLoader.findDivisor(fluidPerCraft, outputQuantity);
                fluidPerCraft = Math.max((long)((double)fluidPerCraft / divisor), 1L);
                recipeDuration = Math.max((long)((double)recipeDuration / divisor), 1L);
                outputQuantity = Math.min((long)((double)outputQuantity / divisor), 256L);
            } else if (outputQuantity < 128L) {
                long multiplier = GTUtility.ceilDiv(128L, outputQuantity);
                fluidPerCraft *= multiplier;
                recipeDuration *= multiplier;
                outputQuantity *= multiplier;
            }
            ItemStack output = singleUseTool.tool.get(0L, new Object[0]);
            output.field_77994_a = (int)outputQuantity;
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            int maxStackSize = output.func_77976_d();
            while (output.field_77994_a > maxStackSize) {
                outputs.add(output.func_77979_a(maxStackSize));
            }
            outputs.add(output);
            GTValues.RA.stdBuilder().fluidInputs(material.getMolten(fluidPerCraft)).itemInputs(singleUseTool.mold.get(0L, new Object[0])).itemOutputs(outputs.toArray(new ItemStack[0])).eut(TierEU.RECIPE_MV).duration(recipeDuration).addTo(GGFabRecipeMaps.toolCastRecipes);
        }
    }
}

