/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.GTMetaTileEntity;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class MTENeutronAccelerator
extends MTEHatch {
    public MTENeutronAccelerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{"Uses Energy to Accelerate the Neutrons!", "Max consumption: " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(MTENeutronAccelerator.getMaxEUConsume(aTier)) + EnumChatFormatting.WHITE + " EU/t", "Every EU gets converted into 10-20 eV Neutron Kinetic Energy."}, new ITexture[0]);
    }

    public MTENeutronAccelerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    public int getMaxEUConsume() {
        return MTENeutronAccelerator.getMaxEUConsume(this.mTier);
    }

    private static int getMaxEUConsume(int mTier) {
        return (int)(GTValues.V[mTier] * 8L / 10L);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENeutronAccelerator(this.mName, this.mTier, this.getDescription(), this.mTextures);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.getEUVar() >= (long)this.getMaxEUConsume() && aBaseMetaTileEntity.isAllowedToWork()) {
                this.setEUVar(this.getEUVar() - (long)this.getMaxEUConsume());
                aBaseMetaTileEntity.setActive(true);
            } else {
                aBaseMetaTileEntity.setActive(false);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier] * 8L;
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }
}

