/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;

public class MTEFuelRefineFactory
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    private IStructureDefinition<MTEFuelRefineFactory> multiDefinition = null;
    private int tier = -1;
    private static final Block[] coils = new Block[]{Loaders.FRF_Coil_1, Loaders.FRF_Coil_2, Loaders.FRF_Coil_3, Loaders.FRF_Coil_4};

    public MTEFuelRefineFactory(String name) {
        super(name);
        this.useLongPower = true;
    }

    public MTEFuelRefineFactory(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
        this.useLongPower = true;
    }

    @Override
    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 7, 12, 1, itemStack, hintsOnly);
    }

    public IStructureDefinition<MTEFuelRefineFactory> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"               ", "      CCC      ", "               "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"    CC   CC    ", "   CFFCCCFFC   ", "    CC   CC    "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {" X           X ", "CFC         CFC", " X           X "}, {" G           G ", "CFC         CFC", " G           G "}, {" X           X ", "CFC         CFC", " X           X "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"  C         C  ", " CFC       CFC ", "  C         C  "}, {"   C       C   ", "  CFCC   CCFC  ", "   C       C   "}, {"    CC   CC    ", "   CFFC~CFFC   ", "    CC   CC    "}, {"      XGX      ", "    CCFFFCC    ", "      XGX      "}, {"               ", "      CCC      ", "               "}})).addElement('X', GTStructureUtility.buildHatchAdder(MTEFuelRefineFactory.class).atLeast(HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputHatch, TTMultiblockBase.HatchElement.EnergyMulti.or(HatchElement.Energy), TTMultiblockBase.HatchElement.DynamoMulti.or(HatchElement.Dynamo)).casingIndex(179).dot(1).buildAndChain(StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0))).addElement('C', StructureUtility.ofBlock((Block)Loaders.FRF_Casings, (int)0)).addElement('G', StructureUtility.ofBlock((Block)Loaders.fieldRestrictingGlass, (int)0)).addElement('F', StructureUtility.ofBlocksTiered(MTEFuelRefineFactory.fieldCoilTierConverter(), MTEFuelRefineFactory.getAllFieldCoilTiers(), (Object)-1, MTEFuelRefineFactory::setCoilTier, MTEFuelRefineFactory::getCoilTier)).build();
        }
        return this.multiDefinition;
    }

    public static ITierConverter<Integer> fieldCoilTierConverter() {
        return (block, meta) -> {
            for (int i = 0; i < coils.length; ++i) {
                if (!block.equals(coils[i])) continue;
                return i + 1;
            }
            return null;
        };
    }

    public static List<Pair<Block, Integer>> getAllFieldCoilTiers() {
        ArrayList<Pair<Block, Integer>> tiers = new ArrayList<Pair<Block, Integer>>();
        for (Block coil : coils) {
            tiers.add((Pair<Block, Integer>)Pair.of((Object)coil, (Object)0));
        }
        return tiers;
    }

    private void setCoilTier(int tier) {
        this.tier = tier;
    }

    private int getCoilTier() {
        return this.tier;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Naquadah Fuel Refinery").addInfo("But at what cost?").addInfo("Produces naquadah fuels.").addInfo("Needs field restriction coils to control the fatal radiation.").addInfo("Use higher tier coils to unlock more fuel types and perform more perfect overclocks.").addTecTechHatchInfo().addUnlimitedTierSkips().beginStructureBlock(3, 15, 15, false).addController("Mid of the third layer").addCasingInfoExactly("Naquadah Fuel Refinery Casing", 114, false).addCasingInfoExactly("Field Restriction Coil", 32, true).addCasingInfoExactly("Field Restriction Glass", 8, false).addInputHatch("The casings adjacent to field restriction glass.").addInputBus("The casings adjacent to field restriction glass.", 1).addOutputHatch("The casings adjacent to field restriction glass.", 1).addEnergyHatch("The casings adjacent to field restriction glass.", 1).addDynamoHatch("The casings adjacent to field restriction glass.", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.tier = aNBT.func_74762_e("mTier");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mTier", this.tier);
        super.saveNBTData(aNBT);
    }

    @Override
    public String[] getStructureDescription(ItemStack itemStack) {
        return DescTextLocalization.addText("FuelRefineFactory.hint", 8);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.tier = -1;
        return this.structureCheck_EM(this.mName, 7, 12, 1);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.naquadahFuelRefineFactoryRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (recipe.mSpecialValue > MTEFuelRefineFactory.this.tier) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(recipe.mSpecialValue);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected OverclockCalculator createOverclockCalculator(@NotNull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setMaxOverclocks(MTEFuelRefineFactory.this.tier - recipe.mSpecialValue);
            }
        }.enablePerfectOverclock();
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
        logic.setUnlimitedTierSkips();
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFuelRefineFactory(this.mName);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public String[] getInfoData() {
        String[] infoData = new String[super.getInfoData().length + 1];
        System.arraycopy(super.getInfoData(), 0, infoData, 0, super.getInfoData().length);
        infoData[super.getInfoData().length] = StatCollector.func_74838_a((String)"scanner.info.FRF") + " " + this.tier;
        return infoData;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(179)};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 7, 12, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

