/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class BlockGroup
implements Iterable<Vector3ic> {
    private int worldId;
    private WeakReference<World> world;
    private int[] coords;
    private final Vector3i pooledVec = new Vector3i();

    public int size() {
        return this.coords.length / 3;
    }

    public World getWorld() {
        World world = (World)this.world.get();
        if (world != null) {
            return world;
        }
        world = DimensionManager.getWorld((int)this.worldId);
        this.world = new WeakReference<World>(world);
        return world;
    }

    public Vector3ic get(int i) {
        this.pooledVec.x = this.coords[i *= 3];
        this.pooledVec.y = this.coords[i + 1];
        this.pooledVec.z = this.coords[i + 2];
        return this.pooledVec;
    }

    @Override
    public Iterator<Vector3ic> iterator() {
        final int total = this.coords.length / 3;
        return new Iterator<Vector3ic>(){
            int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < total;
            }

            @Override
            public Vector3ic next() {
                return BlockGroup.this.get(this.counter++);
            }
        };
    }
}

