/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs;

import gregtech.api.enums.GTValues;
import gregtech.api.graphs.Lock;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GenerateNodeMap {
    public static void clearNodeMap(Node aNode, int aReturnNodeValue) {
        TileEntity tileEntity = aNode.mTileEntity;
        if (tileEntity instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)tileEntity;
            tPipe.setNode(null);
            tPipe.setNodePath(null);
            if (aNode.mSelfPath != null) {
                aNode.mSelfPath.clearPath();
                aNode.mSelfPath = null;
            }
        }
        for (byte side : GTValues.ALL_VALID_SIDES) {
            Node tNextNode;
            NodePath tPath = aNode.mNodePaths[side];
            if (tPath != null) {
                tPath.clearPath();
                aNode.mNodePaths[side] = null;
            }
            if ((tNextNode = aNode.mNeighbourNodes[side]) == null) continue;
            if (tNextNode.mNodeValue != aReturnNodeValue) {
                GenerateNodeMap.clearNodeMap(tNextNode, aNode.mNodeValue);
            }
            aNode.mNeighbourNodes[side] = null;
        }
    }

    private static int getNumberOfConnections(MetaPipeEntity aPipe) {
        int tCons = 0;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!aPipe.isConnectedAtSide(side)) continue;
            ++tCons;
        }
        return tCons;
    }

    protected void generateNextNode(BaseMetaPipeEntity aPipe, Node aPipeNode, ForgeDirection aInvalidSide, int aNextNodeValue, ArrayList<ConsumerNode> tConsumers, HashSet<Node> tNodeMap) {
        MetaPipeEntity tMetaPipe = (MetaPipeEntity)aPipe.getMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            Node tNextNode;
            ArrayList<MetaPipeEntity> tNewPipes;
            Pair nextTileEntity;
            TileEntity tNextTileEntity;
            if (side == aInvalidSide || (tNextTileEntity = aPipe.getTileEntityAtSide(side)) == null || tMetaPipe != null && !tMetaPipe.isConnectedAtSide(side) || (nextTileEntity = this.getNextValidTileEntity(tNextTileEntity, tNewPipes = new ArrayList<MetaPipeEntity>(), side, tNodeMap)) == null || (tNextNode = this.generateNode(nextTileEntity.mTileEntity, aPipeNode, aNextNodeValue + 1, tNewPipes, nextTileEntity.mSide, tConsumers, tNodeMap)) == null) continue;
            int i = side.ordinal();
            aNextNodeValue = tNextNode.mHighestNodeValue;
            aPipeNode.mHighestNodeValue = tNextNode.mHighestNodeValue;
            aPipeNode.mNeighbourNodes[i] = tNextNode;
            aPipeNode.mNodePaths[i] = aPipeNode.returnValues.mReturnPath;
            aPipeNode.locks[i] = aPipeNode.returnValues.returnLock;
            aPipeNode.mNodePaths[i].reloadLocks();
        }
        aPipe.reloadLocks();
    }

    protected Node generateNode(TileEntity aTileEntity, Node aPreviousNode, int aNextNodeValue, ArrayList<MetaPipeEntity> aPipes, ForgeDirection side, ArrayList<ConsumerNode> aConsumers, HashSet<Node> aNodeMap) {
        if (aTileEntity.func_145837_r()) {
            return null;
        }
        ForgeDirection oppositeSide = side.getOpposite();
        ForgeDirection tInvalidSide = aPreviousNode == null ? ForgeDirection.UNKNOWN : oppositeSide;
        Node tThisNode = null;
        if (this.isPipe(aTileEntity)) {
            Node tPipeNode;
            BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)aTileEntity;
            MetaPipeEntity tMetaPipe = (MetaPipeEntity)tPipe.getMetaTileEntity();
            int tConnections = GenerateNodeMap.getNumberOfConnections(tMetaPipe);
            if (tConnections == 1) {
                tPipeNode = this.getEmptyNode(aNextNodeValue, oppositeSide, aTileEntity, aConsumers);
                if (tPipeNode == null) {
                    return null;
                }
            } else {
                tPipeNode = this.getPipeNode(aNextNodeValue, oppositeSide, aTileEntity, aConsumers);
            }
            tPipe.setNode(tPipeNode);
            aNodeMap.add(tPipeNode);
            tPipeNode.mSelfPath = this.getNewPath(new MetaPipeEntity[]{tMetaPipe});
            tThisNode = tPipeNode;
            if (tInvalidSide != ForgeDirection.UNKNOWN) {
                Lock lock;
                int iInvalid = tInvalidSide.ordinal();
                tPipeNode.mNeighbourNodes[iInvalid] = aPreviousNode;
                tPipeNode.mNodePaths[iInvalid] = this.getNewPath(aPipes.toArray(new MetaPipeEntity[0]));
                tPipeNode.mNodePaths[oppositeSide.ordinal()].lock = lock = new Lock();
                tPipeNode.locks[iInvalid] = lock;
                aPreviousNode.returnValues.mReturnPath = tPipeNode.mNodePaths[iInvalid];
                aPreviousNode.returnValues.returnLock = lock;
            }
            if (tConnections > 1) {
                this.generateNextNode(tPipe, tPipeNode, tInvalidSide, aNextNodeValue, aConsumers, aNodeMap);
            }
        } else if (this.addConsumer(aTileEntity, oppositeSide, aNextNodeValue, aConsumers)) {
            Lock lock;
            int oppositeSideOrdinal = oppositeSide.ordinal();
            ConsumerNode tConsumeNode = aConsumers.get(aConsumers.size() - 1);
            tConsumeNode.mNeighbourNodes[oppositeSideOrdinal] = aPreviousNode;
            tConsumeNode.mNodePaths[oppositeSideOrdinal] = this.getNewPath(aPipes.toArray(new MetaPipeEntity[0]));
            tConsumeNode.mNodePaths[oppositeSideOrdinal].lock = lock = new Lock();
            aPreviousNode.returnValues.mReturnPath = tConsumeNode.mNodePaths[oppositeSideOrdinal];
            aPreviousNode.returnValues.returnLock = lock;
            tThisNode = tConsumeNode;
        }
        return tThisNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Pair getNextValidTileEntity(TileEntity aTileEntity, ArrayList<MetaPipeEntity> aPipes, ForgeDirection side, HashSet<Node> aNodeMap) {
        if (!this.isPipe(aTileEntity)) return new Pair(aTileEntity, side);
        BaseMetaPipeEntity tPipe = (BaseMetaPipeEntity)aTileEntity;
        MetaPipeEntity tMetaPipe = (MetaPipeEntity)tPipe.getMetaTileEntity();
        Node tNode = tPipe.getNode();
        if (tNode != null && aNodeMap.contains(tNode)) {
            return null;
        }
        int tConnections = GenerateNodeMap.getNumberOfConnections(tMetaPipe);
        if (tConnections != 2) return new Pair(aTileEntity, side);
        ForgeDirection tSideOp = side.getOpposite();
        for (ForgeDirection s : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tNewTileEntity;
            if (s == tSideOp || !tMetaPipe.isConnectedAtSide(s) || (tNewTileEntity = tPipe.getTileEntityAtSide(s)) == null) continue;
            if (!this.isPipe(tNewTileEntity)) return new Pair(aTileEntity, s);
            aPipes.add(tMetaPipe);
            return this.getNextValidTileEntity(tNewTileEntity, aPipes, s, aNodeMap);
        }
        return null;
    }

    protected boolean isPipe(TileEntity aTileEntity) {
        return aTileEntity instanceof BaseMetaPipeEntity;
    }

    protected abstract boolean addConsumer(TileEntity var1, ForgeDirection var2, int var3, ArrayList<ConsumerNode> var4);

    protected abstract NodePath getNewPath(MetaPipeEntity[] var1);

    protected Node getEmptyNode(int aNodeValue, ForgeDirection side, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return null;
    }

    protected Node getPipeNode(int aNodeValue, ForgeDirection side, TileEntity aTileEntity, ArrayList<ConsumerNode> aConsumers) {
        return new Node(aNodeValue, aTileEntity, aConsumers);
    }

    private static class Pair {
        public ForgeDirection mSide;
        public TileEntity mTileEntity;

        public Pair(TileEntity aTileEntity, ForgeDirection side) {
            this.mTileEntity = aTileEntity;
            this.mSide = side;
        }
    }
}

