/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.MetaTileEntityIDs;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class MTEBasicMachineWithRecipe
extends MTEBasicMachine {
    private final RecipeMap<?> mRecipes;
    private final int mTankCapacity;
    private final SpecialEffects mSpecialEffect;
    private final ResourceLocation mSoundResourceLocation;
    private FallbackableUITexture progressBarTexture;
    private int recipeCatalystPriority;

    public MTEBasicMachineWithRecipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, ResourceLocation aSound, SpecialEffects aSpecialEffect, String aOverlays, Object[] aRecipe) {
        this(aID, aName, aNameRegional, aTier, new String[]{aDescription}, aRecipes, aInputSlots, aOutputSlots, aTankCapacity, aSound, aSpecialEffect, aOverlays, aRecipe);
    }

    public MTEBasicMachineWithRecipe(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, ResourceLocation aSound, SpecialEffects aSpecialEffect, String aOverlays, Object[] aRecipe) {
        super(aID, aName, aNameRegional, aTier, aRecipes.getAmperage(), aDescription, aInputSlots, aOutputSlots, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon((IIconContainer)new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_GLOW")).glow().build()));
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRecipes = aRecipes;
        this.mSoundResourceLocation = aSound;
        this.progressBarTexture = this.mRecipes.getFrontend().getUIProperties().progressBarTexture;
        GTModHandler.addMachineCraftingRecipe(this.getStackForm(1L), aRecipe, this.mTier);
    }

    public MTEBasicMachineWithRecipe(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, boolean usesFluids, SoundResource aSound, SpecialEffects aSpecialEffect, String aOverlays) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, usesFluids ? MTEBasicMachineWithRecipe.getCapacityForTier(aTier) : 0, aSound.resourceLocation, aSpecialEffect, aOverlays, null);
    }

    public MTEBasicMachineWithRecipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, SoundResource aSound, SpecialEffects aSpecialEffect, String aOverlays) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, aTankCapacity, aSound.resourceLocation, aSpecialEffect, aOverlays, null);
    }

    public MTEBasicMachineWithRecipe(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, SoundResource aSound, SpecialEffects aSpecialEffect, String aOverlays) {
        this(aID, aName, aNameRegional, aTier, aDescription, aRecipes, aInputSlots, aOutputSlots, aTankCapacity, aSound.resourceLocation, aSpecialEffect, aOverlays, null);
    }

    public MTEBasicMachineWithRecipe(String aName, int aTier, String[] aDescription, RecipeMap<?> aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aAmperage, ITexture[][][] aTextures, ResourceLocation aSound, SpecialEffects aSpecialEffect) {
        super(aName, aTier, aAmperage, aDescription, aTextures, aInputSlots, aOutputSlots);
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRecipes = aRecipes;
        this.mSoundResourceLocation = aSound;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBasicMachineWithRecipe(this.mName, this.mTier, this.mDescriptionArray, this.mRecipes, this.mInputSlotCount, this.mOutputItems == null ? 0 : this.mOutputItems.length, this.mTankCapacity, this.mAmperage, this.mTextures, this.mSoundResourceLocation, this.mSpecialEffect).setProgressBarTexture(this.progressBarTexture).setRecipeCatalystPriority(this.recipeCatalystPriority);
    }

    public MTEBasicMachineWithRecipe setProgressBarTexture(FallbackableUITexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
        return this;
    }

    public MTEBasicMachineWithRecipe setProgressBarTextureName(String name, UITexture fallback) {
        return this.setProgressBarTexture(GTUITextures.fallbackableProgressbar(name, fallback));
    }

    public MTEBasicMachineWithRecipe setProgressBarTextureName(String name) {
        return this.setProgressBarTextureName(name, GTUITextures.PROGRESSBAR_ARROW);
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        if (!super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack)) {
            return false;
        }
        switch (this.mInputSlotCount) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.getFillableStack() == null) {
                    return this.getRecipeMap().containsInput(aStack);
                }
                return this.getRecipeMap().findRecipeQuery().items(this.appendSelectedCircuit(aStack)).fluids(this.getFillableStack()).specialSlot(this.getSpecialSlot()).voltage(GTValues.V[this.mTier]).cachedRecipe(this.mLastRecipe).dontCheckStackSizes(true).notUnificated(true).find() != null;
            }
            case 2: {
                return this.getInputAt(0) != null && this.getInputAt(1) != null || (this.getInputAt(0) == null && this.getInputAt(1) == null ? this.getRecipeMap().containsInput(aStack) : this.getRecipeMap().containsInput(aStack) && this.getRecipeMap().findRecipeQuery().items(aIndex == this.getInputSlot() ? this.appendSelectedCircuit(aStack, this.getInputAt(1)) : this.appendSelectedCircuit(this.getInputAt(0), aStack)).fluids(this.getFillableStack()).specialSlot(this.getSpecialSlot()).voltage(GTValues.V[this.mTier]).cachedRecipe(this.mLastRecipe).dontCheckStackSizes(true).notUnificated(true).find() != null);
            }
        }
        int tID = this.getBaseMetaTileEntity().getMetaTileID();
        if ((tID >= MetaTileEntityIDs.ASSEMBLER_LV.ID && tID <= MetaTileEntityIDs.ASSEMBLER_IV.ID || tID >= MetaTileEntityIDs.CIRCUIT_ASSEMBLER_LV.ID && tID <= MetaTileEntityIDs.CIRCUIT_ASSEMBLER_UV.ID || tID >= MetaTileEntityIDs.ASSEMBLING_MACHINE_LuV.ID && tID <= MetaTileEntityIDs.ASSEMBLING_MACHINE_UMV.ID) && GTUtility.isStackValid(aStack)) {
            for (int oreID : OreDictionary.getOreIDs((ItemStack)aStack)) {
                if (!OreDictionary.getOreName((int)oreID).startsWith("circuit")) continue;
                return true;
            }
        }
        return this.getRecipeMap().containsInput(aStack);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            switch (this.mSpecialEffect) {
                case TOP_SMOKE: {
                    if (aBaseMetaTileEntity.getFrontFacing() == ForgeDirection.UP || aBaseMetaTileEntity.hasCoverAtSide(ForgeDirection.UP) || aBaseMetaTileEntity.getOpacityAtSide(ForgeDirection.UP)) break;
                    ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setIdentifier((Enum)ParticleFX.SMOKE)).setPosition((float)aBaseMetaTileEntity.getXCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f, (float)aBaseMetaTileEntity.getYCoord() + 0.9f + XSTR.XSTR_INSTANCE.nextFloat() * 0.2f, (float)aBaseMetaTileEntity.getZCoord() + 0.8f - XSTR.XSTR_INSTANCE.nextFloat() * 0.6f).setWorld(aBaseMetaTileEntity.getWorld()).run();
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mSpecialEffect) {
            case MAIN_RANDOM_SPARKS: {
                double mZ;
                double z;
                double mX;
                double x;
                if (!aBaseMetaTileEntity.isActive() || XSTR.XSTR_INSTANCE.nextInt(3) != 0) break;
                ForgeDirection mainFacing = this.mMainFacing;
                if ((mainFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 || aBaseMetaTileEntity.hasCoverAtSide(mainFacing) || aBaseMetaTileEntity.getOpacityAtSide(mainFacing)) break;
                double oX = aBaseMetaTileEntity.getXCoord();
                double oY = aBaseMetaTileEntity.getYCoord();
                double oZ = aBaseMetaTileEntity.getZCoord();
                double offset = 0.02;
                double horizontal = 0.5 + (double)XSTR.XSTR_INSTANCE.nextFloat() * 8.0 / 16.0 - 0.25;
                double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 + 0.3125;
                if (mainFacing == ForgeDirection.WEST) {
                    x = oX - 0.02;
                    mX = -0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.EAST) {
                    x = oX + 0.02;
                    mX = 0.05;
                    z = oZ + horizontal;
                    mZ = 0.0;
                } else if (mainFacing == ForgeDirection.NORTH) {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ - 0.02;
                    mZ = -0.05;
                } else {
                    x = oX + horizontal;
                    mX = 0.0;
                    z = oZ + 0.02;
                    mZ = 0.05;
                }
                WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(mX, 0.0, mZ).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.LAVA)).run();
                break;
            }
        }
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return this.mRecipes;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return this.recipeCatalystPriority;
    }

    public MTEBasicMachineWithRecipe setRecipeCatalystPriority(int recipeCatalystPriority) {
        this.recipeCatalystPriority = recipeCatalystPriority;
        return this;
    }

    @Override
    public int getCapacity() {
        return this.mTankCapacity;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1 && this.mSoundResourceLocation != null && GTUtility.isStringValid(this.mSoundResourceLocation.func_110624_b()) && GTUtility.isStringValid(this.mSoundResourceLocation.func_110623_a())) {
            GTUtility.doSoundAtClient(this.mSoundResourceLocation, 100, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        BaseMetaTileEntity myMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (myMetaTileEntity.mTickTimer > myMetaTileEntity.mLastSoundTick + (long)GTValues.ticksBetweenSounds) {
            if (this.mSoundResourceLocation != null && GTUtility.isStringValid(this.mSoundResourceLocation.func_110624_b()) && GTUtility.isStringValid(this.mSoundResourceLocation.func_110623_a())) {
                this.sendLoopStart((byte)1);
            }
            myMetaTileEntity.mLastSoundTick = myMetaTileEntity.mTickTimer;
        }
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return super.getUIProperties().toBuilder().progressBarTexture(this.progressBarTexture).build();
    }

    public static enum SpecialEffects {
        NONE,
        TOP_SMOKE,
        MAIN_RANDOM_SPARKS;

        static final SpecialEffects[] VALID_SPECIAL_EFFECTS;

        static SpecialEffects fromId(int id) {
            return id >= 0 && id < VALID_SPECIAL_EFFECTS.length ? VALID_SPECIAL_EFFECTS[id] : NONE;
        }

        static {
            VALID_SPECIAL_EFFECTS = new SpecialEffects[]{NONE, TOP_SMOKE, MAIN_RANDOM_SPARKS};
        }
    }

    public static enum X {
        PUMP,
        WIRE,
        WIRE4,
        HULL,
        PIPE,
        GLASS,
        PLATE,
        MOTOR,
        ROTOR,
        SENSOR,
        PISTON,
        CIRCUIT,
        EMITTER,
        CONVEYOR,
        ROBOT_ARM,
        COIL_HEATING,
        COIL_ELECTRIC,
        STICK_MAGNETIC,
        STICK_DISTILLATION,
        BETTER_CIRCUIT,
        FIELD_GENERATOR,
        COIL_HEATING_DOUBLE,
        STICK_ELECTROMAGNETIC;

    }
}

