/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETransformer;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class MTEWetTransformer
extends MTETransformer {
    private boolean mHalfMode = false;

    public MTEWetTransformer(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aDescription);
    }

    public MTEWetTransformer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEWetTransformer(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[12][17][];
        for (int b = -1; b < 16; b = (int)((byte)(b + 1))) {
            rTextures[0][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[1][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[2][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier]};
            rTextures[3][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_POWER[this.mTier + 1]};
            rTextures[4][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_POWER[this.mTier + 1]};
            rTextures[5][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_POWER[this.mTier + 1]};
            rTextures[6][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[7][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[8][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_IN_MULTI[this.mTier]};
            rTextures[9][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier + 1]};
            rTextures[10][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier + 1]};
            rTextures[11][b + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][b + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier + 1]};
        }
        return rTextures;
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Accepts 16A and outputs 64A", "Toggle 2A/8A half-mode with Screwdriver", EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.BLUE + ": Interdimensional"});
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier + 1] * 128L;
    }

    @Override
    public long maxAmperesOut() {
        if (this.mHalfMode) {
            return this.getBaseMetaTileEntity().isAllowedToWork() ? 32L : 8L;
        }
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 64L : 16L;
    }

    @Override
    public long maxAmperesIn() {
        if (this.mHalfMode) {
            return this.getBaseMetaTileEntity().isAllowedToWork() ? 8L : 32L;
        }
        return this.getBaseMetaTileEntity().isAllowedToWork() ? 16L : 64L;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mHalfMode", this.mHalfMode);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mHalfMode = aNBT.func_74767_n("mHalfMode");
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        boolean bl = this.mHalfMode = !this.mHalfMode;
        if (this.mHalfMode) {
            GTUtility.sendChatToPlayer(aPlayer, "Transformer is now running at 8A:32A in/out Ratio.");
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "Transformer is now running at 16A:64A in/out Ratio.");
        }
    }
}

