/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHasIndexedTexture;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.items.GTGenericBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.common.render.GTRendererCasing;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCasingsAbstract
extends GTGenericBlock
implements IHasIndexedTexture {
    public static final Supplier<String> NO_MOB_SPAWNING = AnimatedTooltipHandler.translatedText((String)"gt.casing.no-mob-spawning");
    public static final Supplier<String> NOT_TILE_ENTITY = AnimatedTooltipHandler.translatedText((String)"gt.casing.not-tile-entity");
    public static final Supplier<String> BLAST_PROOF = AnimatedTooltipHandler.translatedText((String)"gt.casing.blast-proof");

    public BlockCasingsAbstract(Class<? extends ItemBlock> aItemClass, String aName, Material aMaterial) {
        super(aItemClass, aName, aMaterial);
        this.func_149672_a(field_149777_j);
        this.func_149647_a(GregTechAPI.TAG_GREGTECH_CASINGS);
        GregTechAPI.registerMachineBlock((Block)this, -1);
        GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + Short.MAX_VALUE + ".name", "Any Sub Block of this");
    }

    public BlockCasingsAbstract(Class<? extends ItemBlock> aItemClass, String aName, Material aMaterial, int aMaxMeta) {
        this(aItemClass, aName, aMaterial);
        for (int i = 0; i < aMaxMeta; ++i) {
            Textures.BlockIcons.setCasingTextureForId(this.getTextureIndex(i), TextureFactory.of(this, i));
        }
    }

    public int func_149645_b() {
        return GTRendererCasing.mRenderID;
    }

    public String getHarvestTool(int aMeta) {
        return "wrench";
    }

    public int getHarvestLevel(int aMeta) {
        return 2;
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150339_S.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float func_149638_a(Entity aTNT) {
        return Blocks.field_150339_S.func_149638_a(aTNT);
    }

    protected boolean func_149700_E() {
        return false;
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        if (GregTechAPI.isMachineBlock(this, aWorld.func_72805_g(aX, aY, aZ))) {
            GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }

    public String func_149739_a() {
        return this.mUnlocalizedName;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.mUnlocalizedName + ".name"));
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetaData) {
        if (GregTechAPI.isMachineBlock(this, aMetaData)) {
            GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_72805_g(aX, aY, aZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister aIconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aList) {
        for (int i = 0; i < 16; ++i) {
            ItemStack aStack = new ItemStack(aItem, 1, i);
            if (aStack.func_82833_r().contains(".name")) continue;
            aList.add(aStack);
        }
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 225;
    }

    public int func_149720_d(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return Dyes.MACHINE_METAL.toInt();
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
    }

    protected void register(int meta, @Nullable IItemContainer container, @Nonnull String defaultLocalName) {
        this.register(meta, container, defaultLocalName, new Supplier[]{null});
    }

    @SafeVarargs
    protected final void register(int meta, @Nullable IItemContainer container, @Nonnull String defaultLocalName, Supplier<String> ... tooltips) {
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + meta + ".name", defaultLocalName);
        if (container != null) {
            container.set(stack.func_77946_l());
        }
        if (tooltips != null) {
            for (Supplier<String> tooltip : tooltips) {
                AnimatedTooltipHandler.addItemTooltip((ItemStack)stack, tooltip);
            }
        }
    }
}

