/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverLegacyData;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverPlayerDetectorGui;
import gregtech.common.covers.modes.PlayerDetectionMode;
import gregtech.common.gui.mui1.cover.PlayerDetectorUIFactory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverPlayerDetector
extends CoverLegacyData {
    private String placer = "";
    private int range = 8;

    public CoverPlayerDetector(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    public PlayerDetectionMode getPlayerDetectionMode() {
        int coverVariable = this.coverData;
        if (coverVariable >= 0 && coverVariable < PlayerDetectionMode.values().length) {
            return PlayerDetectionMode.values()[coverVariable];
        }
        return PlayerDetectionMode.ANY_PLAYER;
    }

    public void setPlayerDetectionMode(PlayerDetectionMode mode) {
        this.setVariable(mode.ordinal());
    }

    @Override
    public void doCoverThings(byte aInputRedstone, long aTimer) {
        ICoverable coverable = (ICoverable)this.coveredTile.get();
        if (coverable == null) {
            return;
        }
        boolean playerDetected = false;
        if (coverable instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtte = (IGregTechTileEntity)coverable;
            if (gtte.isUniversalEnergyStored(20L)) {
                gtte.decreaseStoredEnergyUnits(20L, true);
                this.range = 32;
            } else {
                this.range = 8;
            }
            this.placer = gtte.getOwnerName();
        }
        for (Object tObject : coverable.getWorld().field_73010_i) {
            EntityPlayerMP tEntity;
            int dist;
            if (!(tObject instanceof EntityPlayerMP) || (dist = Math.max(1, (int)(tEntity = (EntityPlayerMP)tObject).func_70011_f((double)coverable.getXCoord() + 0.5, (double)coverable.getYCoord() + 0.5, (double)coverable.getZCoord() + 0.5))) >= this.range) continue;
            if (this.coverData == 0) {
                playerDetected = true;
                break;
            }
            if (tEntity.getDisplayName().equalsIgnoreCase(this.placer)) {
                if (this.coverData != 1) continue;
                playerDetected = true;
                break;
            }
            if (this.coverData != 2) continue;
            playerDetected = true;
            break;
        }
        coverable.setOutputRedstoneSignal(this.coverSide, (byte)(playerDetected ? 15 : 0));
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.coverData = (this.coverData + (aPlayer.func_70093_af() ? -1 : 1)) % 3;
        if (this.coverData < 0) {
            this.coverData = 2;
        }
        switch (this.coverData) {
            case 0: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("068.1", "Emit if any Player is close"));
                break;
            }
            case 1: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("069.1", "Emit if other Player is close"));
                break;
            }
            case 2: {
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("070", "Emit if you are close"));
            }
        }
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean manipulatesSidedRedstoneOutput() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return 20;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverPlayerDetectorGui(this);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new PlayerDetectorUIFactory(buildContext).createWindow();
    }
}

