/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.MetaBaseItem;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourNone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BehaviourScanner
extends BehaviourNone {
    public static final IItemBehaviour<MetaBaseItem> INSTANCE = new BehaviourScanner();
    private final String mTooltip = GTLanguageManager.addStringLocalization("gt.behaviour.scanning", "Can scan Blocks in World");

    @Override
    public boolean onItemUseFirst(MetaBaseItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ForgeDirection side, float hitX, float hitY, float hitZ) {
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (aPlayer instanceof EntityPlayerMP && aItem.canUse(aStack, 20000.0)) {
            ArrayList<String> tList = new ArrayList<String>();
            if (aItem.use(aStack, GTUtility.getCoordinateScan(tList, aPlayer, aWorld, 1, aX, aY, aZ, side, hitX, hitY, hitZ), (EntityLivingBase)aPlayer)) {
                int tList_sS = tList.size();
                tNBT.func_74768_a("dataLinesCount", tList_sS);
                for (int i = 0; i < tList_sS; ++i) {
                    tNBT.func_74778_a("dataLines" + i, tList.get(i));
                    GTUtility.sendChatToPlayer(aPlayer, tList.get(i));
                }
            }
            return true;
        }
        GTUtility.doSoundAtClient(SoundResource.IC2_TOOLS_OD_SCANNER, 1, 1.0f, (double)aX, (double)aY, (double)aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    public List<String> getAdditionalToolTips(MetaBaseItem aItem, List<String> aList, ItemStack aStack) {
        try {
            NBTTagCompound tNBT = aStack.func_77978_p();
            int lines = tNBT.func_74762_e("dataLinesCount");
            if (lines < 1) {
                throw new Exception();
            }
            aList.add(EnumChatFormatting.BLUE + "Block scan data result:");
            for (int i = 0; i < lines; ++i) {
                aList.add(EnumChatFormatting.RESET + tNBT.func_74779_i("dataLines" + i));
            }
        }
        catch (Exception e) {
            aList.add(this.mTooltip);
        }
        return aList;
    }
}

