/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import gregtech.GTMod;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.LightingHelper;
import gregtech.common.render.GTIconFlipped;
import gregtech.common.render.GTTextureBase;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GTRenderedTexture
extends GTTextureBase
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;
    private final boolean glow;
    private final boolean stdOrient;
    private final boolean useExtFacing;
    private static final int NORMAL = 0;
    private static final int CLOCKWISE = 1;
    private static final int COUNTER_CLOCKWISE = 2;
    private static final int UPSIDE_DOWN = 3;

    protected GTRenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean glow, boolean stdOrient, boolean extFacing) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GTRenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mRGBa = aRGBa;
        this.glow = glow;
        this.stdOrient = stdOrient;
        this.useExtFacing = extFacing;
    }

    @Override
    public boolean isOldTexture() {
        return false;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 1.0f, 0.0f, 0.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.EAST, 0xFFFFFF);
            this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, -1.0f, 0.0f, 0.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            lighting.setBrightnessOverride(0xF000F0);
        }
        lighting.setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.WEST, 0xFFFFFF);
            this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 1.0f, 0.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            lighting.setBrightnessOverride(0xF000F0);
        }
        lighting.setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.UP, 0xFFFFFF);
            this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, -1.0f, 0.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            lighting.setBrightnessOverride(0xF000F0);
        }
        lighting.setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78370_a(255, 255, 255, 255);
            this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, 1.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            lighting.setBrightnessOverride(0xF000F0);
        }
        lighting.setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.SOUTH, 0xFFFFFF);
            this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        this.startDrawingQuads(aRenderer, 0.0f, 0.0f, -1.0f);
        boolean enableAO = aRenderer.field_147863_w;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (!GTMod.proxy.mRenderGlowTextures) {
                this.draw(aRenderer);
                return;
            }
            aRenderer.field_147863_w = false;
            lighting.setLightnessOverride(1.0f);
            lighting.setBrightnessOverride(0xF000F0);
        }
        lighting.setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH, this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.NORTH, 0xFFFFFF);
            this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.field_147863_w = enableAO;
        this.draw(aRenderer);
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }

    protected void renderFaceYNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147865_v = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.DOWN, extendedFacing, icon);
        aRenderer.func_147768_a(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147865_v = 0;
    }

    protected void renderFaceYPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147867_u = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.UP, extendedFacing, icon);
        aRenderer.func_147806_b(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147867_u = 0;
    }

    protected void renderFaceZNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147875_q = this.getRotation(extendedFacing);
        aRenderer.field_152631_f = true;
        icon = this.getFlipped(ForgeDirection.NORTH, extendedFacing, icon);
        aRenderer.func_147761_c(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147875_q = 0;
        aRenderer.field_152631_f = false;
    }

    protected void renderFaceZPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147873_r = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.SOUTH, extendedFacing, icon);
        aRenderer.func_147734_d(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147873_r = 0;
    }

    protected void renderFaceXNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147869_t = this.getRotation(extendedFacing);
        icon = this.getFlipped(ForgeDirection.WEST, extendedFacing, icon);
        aRenderer.func_147798_e(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147869_t = 0;
    }

    protected void renderFaceXPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_147871_s = this.getRotation(extendedFacing);
        aRenderer.field_152631_f = true;
        icon = this.getFlipped(ForgeDirection.EAST, extendedFacing, icon);
        aRenderer.func_147764_f(Blocks.field_150350_a, x, y, z, icon);
        aRenderer.field_147871_s = 0;
        aRenderer.field_152631_f = false;
    }

    private int getRotation(ExtendedFacing extendedFacing) {
        int n;
        if (extendedFacing == null) {
            return 0;
        }
        switch (extendedFacing.getRotation()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NORMAL: {
                n = 0;
                break;
            }
            case CLOCKWISE: {
                n = 1;
                break;
            }
            case UPSIDE_DOWN: {
                n = 3;
                break;
            }
            case COUNTER_CLOCKWISE: {
                n = 2;
            }
        }
        return n;
    }

    private IIcon getFlipped(ForgeDirection side, ExtendedFacing extendedFacing, IIcon icon) {
        boolean flipU = false;
        boolean flipV = false;
        if (extendedFacing == null) {
            if (side == ForgeDirection.EAST || side == ForgeDirection.DOWN) {
                flipU ^= true;
            }
            if (side == ForgeDirection.NORTH) {
                flipV = true;
            }
            return new GTIconFlipped(icon, flipU, flipV);
        }
        ForgeDirection dir = extendedFacing.getDirection();
        if (extendedFacing.getRotation().getIndex() % 2 == 0) {
            flipU ^= extendedFacing.getFlip().isHorizontallyFlipped();
        } else {
            flipV ^= extendedFacing.getFlip().isHorizontallyFlipped();
            if (side == ForgeDirection.EAST || side == ForgeDirection.NORTH) {
                flipU ^= true;
            }
        }
        if (side == ForgeDirection.DOWN) {
            flipU ^= true;
        }
        return new GTIconFlipped(icon, flipU, flipV);
    }

    private ExtendedFacing getExtendedFacing(int x, int y, int z) {
        if (this.stdOrient || !this.useExtFacing) {
            return ExtendedFacing.DEFAULT;
        }
        EntityPlayer player = GTMod.proxy.getThePlayer();
        if (player == null) {
            return ExtendedFacing.DEFAULT;
        }
        World w = player.func_130014_f_();
        if (w == null) {
            return ExtendedFacing.DEFAULT;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        IAlignment alignment = null;
        if (te instanceof IGregTechTileEntity) {
            IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
            if (meta instanceof IAlignmentProvider) {
                alignment = ((IAlignmentProvider)meta).getAlignment();
            }
        } else if (te instanceof IAlignmentProvider) {
            alignment = ((IAlignmentProvider)te).getAlignment();
        }
        if (alignment != null) {
            return alignment.getExtendedFacing();
        }
        return null;
    }
}

