/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.ProgressManager;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTCLSCompat;
import gregtech.api.util.GTForestryCompat;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourDataOrb;
import gregtech.common.tileentities.machines.basic.MTEMassfabricator;
import gregtech.common.tileentities.machines.basic.MTERockBreaker;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GTPostLoad {
    public static void activateOreDictHandler() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GTMod.proxy.activateOreDictHandler();
        GTMod.GT_FML_LOGGER.info("Congratulations, you have been waiting long enough (" + stopwatch.stop() + "). Have a Cake.");
        GTLog.out.println("GTMod: List of Lists of Tool Recipes: " + GTModHandler.sSingleNonBlockDamagableRecipeList_list.toString());
        GTLog.out.println("GTMod: Vanilla Recipe List -> Outputs null or stackSize <=0: " + GTModHandler.sVanillaRecipeList_warntOutput.toString());
        GTLog.out.println("GTMod: Single Non Block Damageable Recipe List -> Outputs null or stackSize <=0: " + GTModHandler.sSingleNonBlockDamagableRecipeList_warntOutput.toString());
    }

    public static void removeIc2Recipes(Map<IRecipeInput, RecipeOutput> aMaceratorRecipeList, Map<IRecipeInput, RecipeOutput> aCompressorRecipeList, Map<IRecipeInput, RecipeOutput> aExtractorRecipeList, Map<IRecipeInput, RecipeOutput> aOreWashingRecipeList, Map<IRecipeInput, RecipeOutput> aThermalCentrifugeRecipeList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ItemStack iridiumOre = GTModHandler.getIC2Item("iridiumOre", 1L);
        aCompressorRecipeList.entrySet().parallelStream().filter(e -> ((IRecipeInput)e.getKey()).getInputs().size() == 1 && ((ItemStack)((IRecipeInput)e.getKey()).getInputs().get(0)).func_77969_a(iridiumOre)).findAny().ifPresent(e -> aCompressorRecipeList.remove(e.getKey()));
        GTModHandler.removeAllIC2Recipes();
        GTMod.GT_FML_LOGGER.info("IC2 Removal (" + stopwatch.stop() + "). Have a Cake.");
    }

    public static void registerFluidCannerRecipes() {
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.fluid.amount <= 0) continue;
            ItemStack emptyContainer = tData.emptyContainer.func_77946_l();
            emptyContainer.field_77994_a = 1;
            GTValues.RA.stdBuilder().itemInputs(emptyContainer).itemOutputs(tData.filledContainer).fluidInputs(tData.fluid).duration(tData.fluid.amount / 62 * 1).eut(1).addTo(RecipeMaps.fluidCannerRecipes);
            GTRecipeBuilder builder = GTValues.RA.stdBuilder().itemInputs(tData.filledContainer);
            if (tData.emptyContainer.field_77994_a > 0) {
                builder.itemOutputs(tData.emptyContainer);
            }
            builder.fluidOutputs(tData.fluid).duration(tData.fluid.amount / 62 * 1).eut(1).addTo(RecipeMaps.fluidCannerRecipes);
        }
    }

    public static void addFakeRecipes() {
        GTLog.out.println("GTMod: Adding Fake Recipes for NEI");
        if (Mods.Forestry.isModLoaded()) {
            GTForestryCompat.populateFakeNeiRecipes();
        }
        if (ItemList.IC2_Crop_Seeds.get(1L, new Object[0]) != null) {
            GTValues.RA.stdBuilder().itemInputs(ItemList.IC2_Crop_Seeds.getWildcard(1L, new Object[0])).itemOutputs(ItemList.IC2_Crop_Seeds.getWithName(1L, "Scanned Seeds", new Object[0])).duration(160).eut(8).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        }
        GTValues.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151164_bB, 1, Short.MAX_VALUE)).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Scanned Book Data", new Object[0])).special(ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0])).duration(128).eut(TierEU.RECIPE_LV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        GTValues.RA.stdBuilder().itemInputs(new ItemStack((Item)Items.field_151098_aY, 1, Short.MAX_VALUE)).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Scanned Map Data", new Object[0])).special(ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0])).duration(128).eut(TierEU.RECIPE_LV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Tool_DataOrb.getWithName(1L, "Orb to overwrite", new Object[0])).itemOutputs(ItemList.Tool_DataOrb.getWithName(1L, "Copy of the Orb", new Object[0])).duration(512).eut(TierEU.RECIPE_LV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Tool_DataStick.getWithName(1L, "Stick to overwrite", new Object[0])).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Copy of the Stick", new Object[0])).special(ItemList.Tool_DataStick.getWithName(0L, "Stick to copy", new Object[0])).duration(128).eut(TierEU.RECIPE_LV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Tool_DataStick.getWithName(1L, "Raw Prospection Data", new Object[0])).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Analyzed Prospection Data", new Object[0])).duration(1000).eut(TierEU.RECIPE_LV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
        if (Mods.GalacticraftCore.isModLoaded()) {
            GTValues.RA.stdBuilder().itemInputs(Objects.requireNonNull(GTModHandler.getModItem(Mods.GalacticraftCore.ID, "item.schematic", 1L, Short.MAX_VALUE)).func_151001_c("Any Schematic")).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])).special(ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0])).duration(36000).eut(TierEU.RECIPE_HV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
            if (Mods.GalacticraftMars.isModLoaded()) {
                GTValues.RA.stdBuilder().itemInputs(Objects.requireNonNull(GTModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, Short.MAX_VALUE)).func_151001_c("Any Schematic")).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])).special(ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0])).duration(36000).eut(TierEU.RECIPE_MV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
            }
            if (Mods.GalaxySpace.isModLoaded()) {
                for (int i = 4; i < 9; ++i) {
                    GTValues.RA.stdBuilder().itemInputs(GTModHandler.getModItem(Mods.GalaxySpace.ID, "item.SchematicTier" + i, 1L).func_151001_c("Any Schematic")).itemOutputs(ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])).special(ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0])).duration(36000).eut(TierEU.RECIPE_HV).ignoreCollision().fake().addTo(RecipeMaps.scannerFakeRecipes);
                }
            }
        }
        Materials.getMaterialsMap().values().forEach(tMaterial -> {
            if (tMaterial.mElement != null && !tMaterial.mElement.mIsIsotope && tMaterial != Materials.Magic && tMaterial.getMass() > 0L) {
                ItemStack dataOrb = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                BehaviourDataOrb.setDataTitle(dataOrb, "Elemental-Scan");
                BehaviourDataOrb.setDataName(dataOrb, tMaterial.mElement.name());
                ItemStack dustItem = GTOreDictUnificator.get(OrePrefixes.dust, tMaterial, 1L);
                if (dustItem != null) {
                    GTValues.RA.stdBuilder().itemInputs(dustItem).itemOutputs(dataOrb).special(ItemList.Tool_DataOrb.get(1L, new Object[0])).duration((int)(tMaterial.getMass() * 8192L)).eut(TierEU.RECIPE_LV).fake().ignoreCollision().addTo(RecipeMaps.scannerFakeRecipes);
                    GTValues.RA.stdBuilder().itemOutputs(dustItem).special(dataOrb).metadata(GTRecipeConstants.MATERIAL, tMaterial).addTo(RecipeMaps.replicatorRecipes);
                    return;
                }
                ItemStack cellItem = GTOreDictUnificator.get(OrePrefixes.cell, tMaterial, 1L);
                if (cellItem != null) {
                    GTValues.RA.stdBuilder().itemInputs(cellItem).itemOutputs(dataOrb).special(ItemList.Tool_DataOrb.get(1L, new Object[0])).duration((int)(tMaterial.getMass() * 8192L)).eut(TierEU.RECIPE_LV).fake().ignoreCollision().addTo(RecipeMaps.scannerFakeRecipes);
                    FluidStack fluidStack = GTUtility.getFluidForFilledItem(cellItem, false);
                    GTRecipeBuilder builder = GTValues.RA.stdBuilder();
                    if (fluidStack != null) {
                        builder.fluidOutputs(fluidStack);
                    } else {
                        builder.itemInputs(Materials.Empty.getCells(1)).itemOutputs(cellItem);
                    }
                    builder.special(dataOrb).metadata(GTRecipeConstants.MATERIAL, tMaterial).addTo(RecipeMaps.replicatorRecipes);
                }
            }
        });
        if (!MTEMassfabricator.sRequiresUUA) {
            MTEMassfabricator.nonUUARecipe = GTValues.RA.stdBuilder().fluidOutputs(Materials.UUMatter.getFluid(1L)).duration(MTEMassfabricator.sDurationMultiplier).eut(MTEMassfabricator.BASE_EUT).ignoreCollision().fake().build().get();
            RecipeMaps.massFabFakeRecipes.add(MTEMassfabricator.nonUUARecipe);
        }
        MTEMassfabricator.uuaRecipe = GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.UUAmplifier.getFluid(MTEMassfabricator.sUUAperUUM)).fluidOutputs(Materials.UUMatter.getFluid(1L)).duration(MTEMassfabricator.sDurationMultiplier / MTEMassfabricator.sUUASpeedBonus).eut(MTEMassfabricator.BASE_EUT).ignoreCollision().fake().build().get();
        RecipeMaps.massFabFakeRecipes.add(MTEMassfabricator.uuaRecipe);
        MTERockBreaker.addRockBreakerRecipe(b -> b.recipeDescription("IT'S FREE! Place Lava on Side").sideBlocks(Blocks.field_150355_j).topBlock(Blocks.field_150353_l).outputItem(new ItemStack(Blocks.field_150348_b, 1)).duration(16));
        MTERockBreaker.addRockBreakerRecipe(b -> b.recipeDescription("IT'S FREE! Place Lava on Side").sideBlocks(Blocks.field_150355_j, Blocks.field_150353_l).outputItem(new ItemStack(Blocks.field_150347_e, 1)).duration(16));
        MTERockBreaker.addRockBreakerRecipe(b -> b.sideBlocks(Blocks.field_150355_j).anywhereBlocks(Blocks.field_150353_l).inputItem(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Redstone, 1L), true).circuit(1).outputItem(new ItemStack(Blocks.field_150343_Z, 1)).duration(128));
        MTERockBreaker.addRockBreakerRecipe(b -> b.sideBlocks(Blocks.field_150355_j).anywhereBlocks(Blocks.field_150353_l).inputItem(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Glowstone, 1L), true).circuit(6).outputItem(new ItemStack(Blocks.field_150424_aL, 1)).duration(16));
        if (Mods.EtFuturumRequiem.isModLoaded()) {
            MTERockBreaker.addRockBreakerRecipe(b -> b.sideBlocks(Blocks.field_150353_l).bottomBlock(Blocks.field_150425_aM).inputItem(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "blue_ice", 0L, 0), false).circuit(1).outputItem(GTOreDictUnificator.get(OrePrefixes.stone, Materials.Basalt, 1L)).duration(16));
            MTERockBreaker.addRockBreakerRecipe(b -> b.sideBlocks(Blocks.field_150353_l).bottomBlock(Blocks.field_150425_aM).inputItem(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "magma", 0L, 0), false).circuit(1).outputItem(GTModHandler.getModItem(Mods.EtFuturumRequiem.ID, "cobbled_deepslate", 1L, 0)).duration(16));
        }
    }

    public static void changeWoodenVanillaTools() {
        if (!GTMod.proxy.mChangeWoodenVanillaTools) {
            return;
        }
        GTLog.out.println("GTMod: Updating Vanilla Wooden Tools");
        Items.field_151041_m.func_77656_e(64);
        Items.field_151039_o.func_77656_e(64);
        Items.field_151038_n.func_77656_e(64);
        Items.field_151053_p.func_77656_e(64);
        Items.field_151017_I.func_77656_e(64);
    }

    public static void replaceVanillaMaterials() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GTMod.GT_FML_LOGGER.info("Replacing Vanilla Materials in recipes, please wait.");
        Set<Materials> replaceVanillaItemsSet = Arrays.stream(Materials.values()).filter(GTRecipeRegistrator::hasVanillaRecipes).collect(Collectors.toSet());
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register materials", (int)replaceVanillaItemsSet.size());
        if (Mods.BetterLoadingScreen.isModLoaded()) {
            GTCLSCompat.doActualRegistrationCLS(progressBar, replaceVanillaItemsSet);
            GTCLSCompat.pushToDisplayProgress();
        } else {
            replaceVanillaItemsSet.forEach(m -> {
                progressBar.step(m.mDefaultLocalName);
                GTPostLoad.doActualRegistration(m);
            });
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        GTMod.GT_FML_LOGGER.info("Replaced Vanilla Materials (" + stopwatch.stop() + "). Have a Cake.");
    }

    public static void doActualRegistration(Materials m) {
        boolean noSmash;
        String plateName = OrePrefixes.plate.get(m).toString();
        boolean bl = noSmash = !m.contains(SubTag.NO_SMASHING);
        if ((m.mTypes & 2) != 0) {
            GTRecipeRegistrator.registerUsagesForMaterials(plateName, noSmash, m.getIngots(1));
        }
        if ((m.mTypes & 4) != 0) {
            GTRecipeRegistrator.registerUsagesForMaterials(plateName, noSmash, m.getGems(1));
        }
        if (m.getBlocks(1) != null) {
            GTRecipeRegistrator.registerUsagesForMaterials(null, noSmash, m.getBlocks(1));
        }
    }

    public static void addSolidFakeLargeBoilerFuels() {
        RecipeMaps.largeBoilerFakeFuels.getBackend().addSolidRecipes(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Charcoal, 1L), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 1L), GTOreDictUnificator.get(OrePrefixes.block, Materials.Charcoal, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Coal, 1L), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), GTOreDictUnificator.get(OrePrefixes.block, Materials.Coal, 1L), GTOreDictUnificator.get(OrePrefixes.crushed, Materials.Coal, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lignite, 1L), GTOreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), GTOreDictUnificator.get(OrePrefixes.block, Materials.Lignite, 1L), GTOreDictUnificator.get(OrePrefixes.crushed, Materials.Lignite, 1L), GTOreDictUnificator.get(OrePrefixes.log, Materials.Wood, 1L), GTOreDictUnificator.get(OrePrefixes.plank, Materials.Wood, 1L), GTOreDictUnificator.get(OrePrefixes.stick, Materials.Wood, 1L), GTOreDictUnificator.get(OrePrefixes.slab, Materials.Wood, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Wood, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sodium, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Caesium, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Sulfur, 1L), GTOreDictUnificator.get(ItemList.Block_SSFUEL.get(1L, new Object[0])), GTOreDictUnificator.get(ItemList.Block_MSSFUEL.get(1L, new Object[0])), GTOreDictUnificator.get(OrePrefixes.rod, Materials.Blaze, 1L));
        if (Mods.Thaumcraft.isModLoaded()) {
            RecipeMaps.largeBoilerFakeFuels.getBackend().addSolidRecipe(GTModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L));
        }
    }

    public static void identifyAnySteam() {
        String[] steamCandidates = new String[]{"steam", "ic2steam"};
        String[] superHeatedSteamCandidates = new String[]{"ic2superheatedsteam"};
        GTModHandler.sAnySteamFluidIDs = Arrays.stream(steamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
        GTModHandler.sSuperHeatedSteamFluidIDs = Arrays.stream(superHeatedSteamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
    }
}

