/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class MTEFrothFlotationCell
extends GTPPMultiBlockBase<MTEFrothFlotationCell>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<MTEFrothFlotationCell> STRUCTURE_DEFINITION = null;
    private String lockedMaterialName = null;

    public MTEFrothFlotationCell(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEFrothFlotationCell(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEFrothFlotationCell(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Flotation Cell, FCR";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Process that milled ore!").addInfo("You can only ever process one type of material per controller").addPerfectOCInfo().addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(7, 9, 7, true).addController("Front Center").addCasingInfoMin("Inconel Reinforced Casing", 68, false).addCasingInfoMin("Flotation Casing", 52, false).addInputBus("Bottom Casing", 1).addInputHatch("Bottom Casing", 1).addOutputHatch("Bottom Casing", 1).addEnergyHatch("Bottom Casing", 1).addMaintenanceHatch("Bottom Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCDFrothFlotationCellActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCDFrothFlotationCellActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCDFrothFlotationCell;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCDFrothFlotationCellGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(2, 1);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.flotationCellRecipes;
    }

    @Override
    public IStructureDefinition<MTEFrothFlotationCell> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, (String[][])new String[][]{{"       ", "       ", "   X   ", "  X~X  ", "   X   ", "       ", "       "}, {"       ", "   F   ", "  FFF  ", " FF FF ", "  FFF  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}}).addElement('C', GTStructureUtility.buildHatchAdder(MTEFrothFlotationCell.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy).casingIndex(this.getCasingTextureId()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1)))).addElement('F', StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)9)).addElement('X', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 3, 3, 0) && this.mCasing >= 64 && this.checkHatch();
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiFrothFlotationCell;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                String milledName = this.getMilledStackName(recipe);
                if (milledName == null) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                if (MTEFrothFlotationCell.this.lockedMaterialName == null || !MTEFrothFlotationCell.this.lockedMaterialName.startsWith("milled")) {
                    MTEFrothFlotationCell.this.lockedMaterialName = milledName;
                }
                if (!Objects.equals(MTEFrothFlotationCell.this.lockedMaterialName, milledName)) {
                    return SimpleCheckRecipeResult.ofFailure("machine_locked_to_different_recipe");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            private String getMilledStackName(GTRecipe recipe) {
                if (recipe == null || recipe.mInputs == null) {
                    return null;
                }
                for (ItemStack stack : recipe.mInputs) {
                    for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
                        String oredict = OreDictionary.getOreName((int)oreID);
                        if (!oredict.startsWith(OrePrefixes.milled.toString())) continue;
                        return oredict;
                    }
                }
                return null;
            }
        }.enablePerfectOverclock();
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_150297_b("lockedMaterialName", 8)) {
            this.lockedMaterialName = aNBT.func_74779_i("lockedMaterialName");
        }
    }

    @Override
    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("lockedMaterialName")) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.flotationCell.lockedTo") + " " + StatCollector.func_74838_a((String)stack.func_77978_p().func_74779_i("lockedMaterialName")));
        }
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Locked material: " + this.lockedMaterialName};
    }

    @Override
    public boolean isRecipeLockingEnabled() {
        return this.lockedMaterialName != null && !this.lockedMaterialName.isEmpty();
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.lockedMaterialName, val -> {
            this.lockedMaterialName = val;
        }));
    }
}

