/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import cofh.asmhooks.block.BlockTickingWater;
import cofh.asmhooks.block.BlockWater;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ReflectionUtil;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialFishingPond
extends GTPPMultiBlockBase<MTEIndustrialFishingPond>
implements ISurvivalConstructable {
    public static final int FISH_MODE = 14;
    public static final int JUNK_MODE = 15;
    public static final int TREASURE_MODE = 16;
    private static IStructureDefinition<MTEIndustrialFishingPond> STRUCTURE_DEFINITION;
    private int mCasing;
    private static final Class<?> cofhWater;

    public MTEIndustrialFishingPond(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialFishingPond(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialFishingPond(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fish Trap";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Can process (Tier + 1) * 2 recipes").addInfo("Put a numbered circuit into the input bus.").addInfo("Circuit 14 for Fish").addInfo("Circuit 15 for Junk").addInfo("Circuit 16 for Treasure").addInfo("Needs to be filled with water.").addInfo("Will automatically fill water from input hatch.").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfoMin("Aquatic Casings", 64, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public IStructureDefinition<MTEIndustrialFishingPond> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXX~XXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX"}})).addElement('X', GTStructureUtility.buildHatchAdder(MTEIndustrialFishingPond.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 4, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 4, 1, 0);
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        if (this.mCasing < 64) {
            errors.add(StructureError.TOO_FEW_CASINGS);
            context.func_74768_a("casings", this.mCasing);
        }
    }

    @Override
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        if (errors.contains((Object)StructureError.TOO_FEW_CASINGS)) {
            lines.add(StatCollector.func_74837_a((String)"GT5U.gui.missing_casings", (Object[])new Object[]{64, context.func_74762_e("casings")}));
        }
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE_GLOW;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_GLOW;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureIndex();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.fishPondRecipes;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!MTEIndustrialFishingPond.this.checkForWater()) {
                    return SimpleCheckRecipeResult.ofFailure("no_water");
                }
                return super.validateRecipe(recipe);
            }
        }.setMaxParallelSupplier(this::getMaxParallelRecipes);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * (GTUtility.getTier(this.getMaxInputVoltage()) + 1);
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialFishingPond;
    }

    private Block getCasingBlock() {
        return ModBlocks.blockCasings3Misc;
    }

    private byte getCasingMeta() {
        return 0;
    }

    private int getCasingTextureIndex() {
        return TAE.GTPP_INDEX(32);
    }

    private boolean checkForWater() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        int mOffsetX_Lower = -4;
        int mOffsetX_Upper = 4;
        int mOffsetZ_Lower = -4;
        int mOffsetZ_Upper = 4;
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * 4;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * 4;
        int tAmount = 0;
        for (int i = -3; i <= 3; ++i) {
            for (int j = -3; j <= 3; ++j) {
                for (int h = 0; h < 2; ++h) {
                    int tMeta;
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if (this.isNotStaticWater(tBlock, tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(Materials.Water.getFluid(1L)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, Blocks.field_150355_j);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) {
                        ++tAmount;
                        continue;
                    }
                    if (!Mods.COFHCore.isModLoaded() || !(tBlock instanceof BlockWater) && !(tBlock instanceof BlockTickingWater)) continue;
                    ++tAmount;
                }
            }
        }
        return tAmount >= 60;
    }

    private boolean isNotStaticWater(Block block, int meta) {
        return block == Blocks.field_150350_a || block == Blocks.field_150358_i || block == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater) || cofhWater != null && cofhWater.isAssignableFrom(block.getClass()) && meta != 0;
    }

    static {
        cofhWater = ReflectionUtil.getClass("cofh.asmhooks.block.BlockWater");
    }
}

