/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.register;

import bartworks.system.material.Werkstoff;
import bartworks.util.BWUtil;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TextureSet;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;

public class WerkstoffMaterialPool
implements Runnable {
    private static final int offsetID = 11000;
    private static final int offsetID2 = 11100;
    private static final int offsetID3 = 11300;
    private static final int offsetID3b = 11350;
    private static final int offsetID4 = 11400;
    private static final int offsetID5 = 11460;
    public static final Werkstoff Hafnium = new Werkstoff(new short[]{232, 224, 219}, "Hafnium", BWUtil.subscriptNumbers("Hf"), new Werkstoff.Stats(), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().enforceUnification(), 11000, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff LowPurityHafnium = new Werkstoff(new short[]{240, 223, 208}, "Low-Purity Hafnium", BWUtil.subscriptNumbers("Hf?"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11001, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Hafnia = new Werkstoff(new short[]{247, 223, 203}, "Hafnia", BWUtil.subscriptNumbers("HfO2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11002, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff HafniumTetrachloride = new Werkstoff(new short[]{238, 247, 249}, "Hafnium Tetrachloride", BWUtil.subscriptNumbers("HfCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11003, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff HafniumTetrachlorideSolution = new Werkstoff(new short[]{238, 247, 249}, "Hafnium Tetrachloride Solution", BWUtil.subscriptNumbers("HfCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11004, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff HafniumIodide = new Werkstoff(new short[]{216, 60, 1}, "Hafnium Iodide", BWUtil.subscriptNumbers("HfI4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11005, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff HafniumRunoff = new Werkstoff(new short[]{74, 65, 42}, "Hafnium Runoff", "??????", new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11006, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Zirconium = new Werkstoff(new short[]{225, 230, 225}, "Zirconium", BWUtil.subscriptNumbers("Zr"), new Werkstoff.Stats().setBlastFurnace(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems(), 11007, TextureSet.SET_METALLIC, new Pair[0]);
    public static final Werkstoff Zirconia = new Werkstoff(new short[]{177, 152, 101}, "Zirconia", BWUtil.subscriptNumbers("ZrO2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11008, TextureSet.SET_SHINY, new Pair[0]);
    public static final Werkstoff ZirconiumTetrachloride = new Werkstoff(new short[]{179, 164, 151}, "Zirconium Tetrachloride", BWUtil.subscriptNumbers("ZrCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11009, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff ZirconiumTetrachlorideSolution = new Werkstoff(new short[]{179, 164, 151}, "Zirconium Tetrachloride Solution", BWUtil.subscriptNumbers("ZrCl4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11010, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff HafniaZirconiaBlend = new Werkstoff(new short[]{247, 223, 203}, "Hafnia-Zirconia Blend", BWUtil.subscriptNumbers("Hf?Zr?"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11011, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Iodine = new Werkstoff(new short[]{171, 40, 175}, "Iodine", BWUtil.subscriptNumbers("I"), new Werkstoff.Stats().setProtons(53L).setMass(127L).setSublimation(true).setBoilingPoint(484).setGas(true), Werkstoff.Types.ELEMENT, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells().enforceUnification(), 11012, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff MuddyRareEarthMonaziteSolution = new Werkstoff(new short[]{111, 78, 55}, "Muddy Monazite Rare Earth Solution", BWUtil.subscriptNumbers("Sm?Hf?Zr?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11014, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DilutedRareEarthMonaziteMud = new Werkstoff(new short[]{160, 120, 90}, "Diluted Monazite Rare Earth Mud", BWUtil.subscriptNumbers("Sm?Ti?Si?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11015, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DilutedMonaziteSulfate = new Werkstoff(new short[]{237, 201, 175}, "Diluted Monazite Sulfate", BWUtil.subscriptNumbers("Sm?Th?U?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11016, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff NitratedRareEarthMonaziteConcentrate = new Werkstoff(new short[]{250, 223, 173}, "Nitrogenated Monazite Rare Earth Concentrate", BWUtil.subscriptNumbers("Sm?Ce?Eu?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11017, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff NitricMonaziteLeachedConcentrate = new Werkstoff(new short[]{244, 202, 22}, "Nitric Monazite Leached Concentrate", BWUtil.subscriptNumbers("Sm?Gd?Eu?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11018, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff MonaziteSulfate = new Werkstoff(new short[]{152, 118, 84}, "Monazite Sulfate", BWUtil.subscriptNumbers("Sm?Th?U?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11019, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff AcidicMonazitePowder = new Werkstoff(new short[]{50, 23, 77}, "Acidic Monazite Powder", BWUtil.subscriptNumbers("Sm?Th?U?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11020, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MonaziteRareEarthFiltrate = new Werkstoff(new short[]{72, 60, 50}, "Monazite Rare Earth Filtrate", BWUtil.subscriptNumbers("Sm?Ce?U?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11021, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NeutralizedMonaziteRareEarthFiltrate = new Werkstoff(new short[]{50, 23, 77}, "Neutralized Monazite Rare Earth Filtrate", BWUtil.subscriptNumbers("Sm?Ce?U?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11022, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MonaziteRareEarthHydroxideConcentrate = new Werkstoff(new short[]{193, 154, 107}, "Monazite Rare Earth Hydroxide Concentrate", BWUtil.subscriptNumbers("Sm?Ce?Eu?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11023, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff DriedMonaziteRareEarthConcentrate = new Werkstoff(new short[]{250, 214, 165}, "Dried Monazite Rare Earth Concentrate", BWUtil.subscriptNumbers("Sm?Ce?Eu?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11024, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumDioxide = new Werkstoff(new short[]{255, 255, 255}, "Cerium Dioxide", BWUtil.subscriptNumbers("CeO2"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().enforceUnification(), 11025, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumChloride = new Werkstoff(new short[]{255, 255, 255}, "Cerium Chloride", BWUtil.subscriptNumbers("CeCl3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11026, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumOxalate = new Werkstoff(new short[]{255, 255, 224}, "Cerium Oxalate", BWUtil.subscriptNumbers("Ce2(C2O4)3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11027, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumIIIOxide = new Werkstoff(new short[]{255, 255, 102}, "Cerium (III) Oxide", BWUtil.subscriptNumbers("Ce2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11028, TextureSet.SET_DULL, Arrays.asList(Materials.Cerium, Materials.Oxygen), Pair.of((Object)Materials.Cerium, (Object)2), Pair.of((Object)Materials.Oxygen, (Object)3));
    public static final Werkstoff CeriumRichMixture = new Werkstoff(new short[]{244, 164, 96}, "Cerium-Rich Mixture", BWUtil.subscriptNumbers("Ce?"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11029, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CooledMonaziteRareEarthConcentrate = new Werkstoff(new short[]{250, 214, 165}, "Cooled Monazite Rare Earth Concentrate", BWUtil.subscriptNumbers("Sm?Gd?Eu?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11030, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MonaziteRarerEarthSediment = new Werkstoff(new short[]{250, 214, 165}, "Monazite Rarer Earth Sediment", BWUtil.subscriptNumbers("Sm?Gd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11031, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MonaziteHeterogenousHalogenicRareEarthMixture = new Werkstoff(new short[]{250, 214, 165}, "Heterogenous Halogenic Monazite Rare Earth Mixture", BWUtil.subscriptNumbers("Sm?Gd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11032, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SaturatedMonaziteRareEarthMixture = new Werkstoff(new short[]{250, 214, 165}, "Saturated Monazite Rare Earth", BWUtil.subscriptNumbers("Sm?Gd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11033, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SamaricResidue = new Werkstoff(new short[]{248, 243, 231}, "Samaric Residue", BWUtil.subscriptNumbers("Sm2Gd"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11034, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff AmmoniumNitrate = new Werkstoff(new short[]{255, 255, 255}, "Ammonium Nitrate Solution", BWUtil.subscriptNumbers("NH4NO3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11036, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ThoriumPhosphateCake = new Werkstoff(new short[]{188, 143, 143}, "Thorium-Phosphate Cake", BWUtil.subscriptNumbers("Th?P?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11037, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff ThoriumPhosphateConcentrate = new Werkstoff(new short[]{217, 144, 88}, "Thorium-Phosphate Concentrate", BWUtil.subscriptNumbers("Th?P?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11038, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff UraniumFiltrate = new Werkstoff(new short[]{190, 240, 94}, "Uranium Filtrate", BWUtil.subscriptNumbers("U?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11039, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NeutralizedUraniumFiltrate = new Werkstoff(new short[]{217, 120, 88}, "Neutralized Uranium Filtrate", BWUtil.subscriptNumbers("U?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11040, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SeaweedAsh = new Werkstoff(new short[]{70, 75, 71}, "Seaweed Ash", "C?I?Ca?", new Werkstoff.Stats(), Werkstoff.Types.BIOLOGICAL, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11041, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SeaweedConcentrate = new Werkstoff(new short[]{70, 100, 71}, "Seaweed Concentrate", BWUtil.subscriptNumbers("I?"), new Werkstoff.Stats(), Werkstoff.Types.BIOLOGICAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11042, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PotassiumPermanganate = new Werkstoff(new short[]{165, 50, 138}, "Potassium Permanganate", BWUtil.subscriptNumbers("KMnO4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11043, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff PotassiumPermanganateSolution = new Werkstoff(new short[]{165, 50, 138}, "Potassium Permanganate Solution", BWUtil.subscriptNumbers("KMnO4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11044, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SeaweedByproducts = new Werkstoff(new short[]{125, 50, 138}, "Seaweed Byproducts", "????", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11045, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff NitricLeachedMonaziteMixture = new Werkstoff(new short[]{125, 50, 138}, "Nitric-Leached Monazite Mixture", BWUtil.subscriptNumbers("Sm?Ce?Eu?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11046, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff EuropiumOxide = new Werkstoff(new short[]{255, 255, 255}, "Europium Oxide", BWUtil.subscriptNumbers("EuO"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11047, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff EuropiumSulfide = new Werkstoff(new short[]{5, 0, 5}, "Europium Sulfide", BWUtil.subscriptNumbers("EuS"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11048, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff UnknownBlend = new Werkstoff(new short[]{0, 0, 5}, "Unknown Blend", BWUtil.subscriptNumbers("?????"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11049, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff EuropiumIIIOxide = new Werkstoff(new short[]{255, 230, 255}, "Europium III Oxide", BWUtil.subscriptNumbers("Eu2O3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11050, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MuddyRareEarthBastnasiteSolution = new Werkstoff(new short[]{205, 133, 63}, "Muddy Bastnasite Rare Earth Solution", BWUtil.subscriptNumbers("Sm?Ti?Si?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11100, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SodiumFluorosilicate = new Werkstoff(new short[]{205, 133, 63}, "Sodiumfluorosilicate", BWUtil.subscriptNumbers("Na2SiF6"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11102, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SteamCrackedBasnasiteSolution = new Werkstoff(new short[]{205, 133, 63}, "Steam-Cracked Bastnasite Mud", BWUtil.subscriptNumbers("Sm?Ti?Si?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11103, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ConditionedBastnasiteMud = new Werkstoff(new short[]{205, 133, 63}, "Conditioned Bastnasite Mud", BWUtil.subscriptNumbers("Sm?Ti?Si?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11104, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DiltedRareEarthBastnasiteMud = new Werkstoff(new short[]{205, 133, 63}, "Diluted Bastnasite Mud", BWUtil.subscriptNumbers("Sm?Ti?Si?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11105, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilteredBastnasiteMud = new Werkstoff(new short[]{205, 133, 63}, "Filtered Bastnasite Mud", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11106, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff BastnasiteRareEarthOxidePowder = new Werkstoff(new short[]{205, 133, 63}, "Bastnasite Rare Earth Oxides", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11107, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff LeachedBastnasiteRareEarthOxides = new Werkstoff(new short[]{205, 133, 63}, "Acid-Leached Bastnasite Rare Earth Oxides", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11108, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Gangue = new Werkstoff(new short[]{0, 0, 0}, "Gangue", BWUtil.subscriptNumbers("Useless...?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addPrefix(OrePrefixes.block).removePrefix(OrePrefixes.ingot).removePrefix(OrePrefixes.gem), 11109, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff RoastedRareEarthOxides = new Werkstoff(new short[]{160, 82, 45}, "Roasted Rare Earth Oxides", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11110, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff WetRareEarthOxides = new Werkstoff(new short[]{160, 82, 49}, "Wet Rare Earth Oxides", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11111, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumOxidisedRareEarthOxides = new Werkstoff(new short[]{160, 82, 49}, "Cerium-Oxidised Rare Earth Oxides", BWUtil.subscriptNumbers("Sm?La?Ce?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11112, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff BastnasiteRarerEarthOxides = new Werkstoff(new short[]{160, 82, 49}, "Bastnasite Rarer Earth Oxides", BWUtil.subscriptNumbers("Sm?La?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11113, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NitratedBastnasiteRarerEarthOxides = new Werkstoff(new short[]{160, 90, 60}, "Nitrogenated Bastnasite Rarer Earth Oxides", BWUtil.subscriptNumbers("Sm?La?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11114, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SaturatedBastnasiteRarerEarthOxides = new Werkstoff(new short[]{170, 90, 60}, "Bastnasite Rarer Earth Oxide Suspension", BWUtil.subscriptNumbers("Sm?La?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11115, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SamaricRareEarthConcentrate = new Werkstoff(new short[]{170, 90, 60}, "Samaric Rare Earth Concentrate", BWUtil.subscriptNumbers("Sm?Ho?Tb?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11116, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NeodymicRareEarthConcentrate = new Werkstoff(new short[]{170, 90, 60}, "Neodymium Rare Earth Concentrate", BWUtil.subscriptNumbers("La?Nd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11117, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff LanthaniumChloride = new Werkstoff(new short[]{82, 112, 102}, "Lanthanium Chloride", BWUtil.subscriptNumbers("LaCl3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11121, TextureSet.SET_DULL, Arrays.asList(Materials.Lanthanum, Materials.Chlorine), Pair.of((Object)Materials.Lanthanum, (Object)1), Pair.of((Object)Materials.Chlorine, (Object)3));
    public static final Werkstoff NeodymiumOxide = new Werkstoff(new short[]{82, 112, 102}, "Neodymium Oxide", BWUtil.subscriptNumbers("Nd2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11122, TextureSet.SET_DULL, Arrays.asList(Materials.Neodymium, Materials.Oxygen), Pair.of((Object)Materials.Neodymium, (Object)2), Pair.of((Object)Materials.Oxygen, (Object)3));
    public static final Werkstoff FluorinatedSamaricConcentrate = new Werkstoff(new short[]{255, 182, 193}, "Fluorinated Samaric Concentrate", BWUtil.subscriptNumbers("Sm?Ho?Tb?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11123, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CalciumFluoride = new Werkstoff(new short[]{255, 250, 250}, "Calcium Fluoride", BWUtil.subscriptNumbers("CaF2"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 11124, TextureSet.SET_DULL, Arrays.asList(Materials.Calcium, Materials.Fluorine), Pair.of((Object)Materials.Calcium, (Object)1), Pair.of((Object)Materials.Fluorine, (Object)2));
    public static final Werkstoff SamariumTerbiumMixture = new Werkstoff(new short[]{223, 182, 193}, "Samarium-Terbium Mixture", BWUtil.subscriptNumbers("Sm?Tb?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11125, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NitratedSamariumTerbiumMixture = new Werkstoff(new short[]{223, 182, 193}, "Nitrogenated Samarium-Terbium Mixture", BWUtil.subscriptNumbers("Sm?Tb?NH4NO3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11126, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff TerbiumNitrate = new Werkstoff(new short[]{167, 252, 0}, "Terbium Nitrate", BWUtil.subscriptNumbers("TbNO3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11127, TextureSet.SET_DULL, Arrays.asList(Materials.Terbium, Materials.Nitrogen, Materials.Oxygen), Pair.of((Object)Materials.Terbium, (Object)1), Pair.of((Object)Materials.Nitrogen, (Object)1), Pair.of((Object)Materials.Oxygen, (Object)3));
    public static final Werkstoff SamariumOreConcentrate = new Werkstoff(new short[]{255, 200, 230}, "Samarium Ore Concentrate", BWUtil.subscriptNumbers("Sm?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11128, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff DephosphatedSamariumConcentrate = new Werkstoff(new short[]{255, 170, 220}, "Dephosphated Samarium Concentrate", BWUtil.subscriptNumbers("Sm?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11129, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Tetrahydrofuran = new Werkstoff(new short[]{222, 165, 164}, "Tetrahydrofuran", BWUtil.subscriptNumbers("(CH2)4O"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11300, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff Butanediol = new Werkstoff(new short[]{185, 78, 72}, "1,4-Butanediol", BWUtil.subscriptNumbers("HO(CH2)4OH"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11301, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff AcidicButanediol = new Werkstoff(new short[]{255, 239, 213}, "Acidicised 1,4-Butanediol", BWUtil.subscriptNumbers("HO(CH2)4OH"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11302, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff MoTeOCatalyst = new Werkstoff(new short[]{238, 131, 238}, "Tellurium-Molybdenum-Oxide Catalyst", BWUtil.subscriptNumbers("(MoO2)(TeO2)"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11303, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff TelluriumIVOxide = new Werkstoff(new short[]{229, 199, 187}, "Tellurium (IV) Oxide", BWUtil.subscriptNumbers("TeO2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11304, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MolybdenumIVOxide = new Werkstoff(new short[]{52, 53, 57}, "Molybdenum (IV) Oxide", BWUtil.subscriptNumbers("MoO2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11305, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Polytetrahydrofuran = new Werkstoff(new short[]{192, 128, 129}, "Polytetrahydrofuran", BWUtil.subscriptNumbers("(C4H8O)OH2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addCells(), 11306, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff TungstophosphoricAcid = new Werkstoff(new short[]{223, 255, 0}, "Tungstophosphoric Acid", BWUtil.subscriptNumbers("H3PW12O40"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11307, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff TolueneDiisocyanate = new Werkstoff(new short[]{255, 255, 102}, "Toluene Diisocyanate", BWUtil.subscriptNumbers("CH3C6H3(NCO)2"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11308, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff Dinitrotoluene = new Werkstoff(new short[]{216, 191, 216}, "Dinitrotoluene", BWUtil.subscriptNumbers("C7H6N2O4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11309, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff Diaminotoluene = new Werkstoff(new short[]{227, 218, 201}, "Diaminotoluene", BWUtil.subscriptNumbers("C6H3(NH2)2CH3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11310, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff TolueneTetramethylDiisocyanate = new Werkstoff(new short[]{255, 255, 255}, "Toluene Tetramethyl Diisocyanate", BWUtil.subscriptNumbers("(CONH)2(C6H4)2CH2(C4O)"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11311, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PTMEGElastomer = new Werkstoff(new short[]{248, 248, 255}, "PTMEG Elastomer", BWUtil.subscriptNumbers("C4H8O"), new Werkstoff.Stats().setMeltingPoint(600).setMeltingVoltage(64), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten().addMetalItems().addMetalCraftingSolidifierRecipes(), 11312, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff PotassiumChlorate = new Werkstoff(new short[]{240, 255, 255}, "Potassium Chlorate", BWUtil.subscriptNumbers("KClO3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten(), 11314, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff DilutedAcetone = new Werkstoff(new short[]{254, 254, 250}, "Diluted Acetone", BWUtil.subscriptNumbers("C3H6O"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11316, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff MolybdenumTrioxide = new Werkstoff(new short[]{236, 255, 248}, "Molybdenum Trioxide", BWUtil.subscriptNumbers("MoO3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11317, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff MuddySamariumRareEarthSolution = new Werkstoff(new short[]{226, 180, 108}, "Muddy Samarium Rare Earth Solution", BWUtil.subscriptNumbers("Sm?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11461, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SamariumRareEarthMud = new Werkstoff(new short[]{226, 180, 128}, "Samarium Rare Earth Mud", BWUtil.subscriptNumbers("Sm?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11462, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DilutedSamariumRareEarthSolution = new Werkstoff(new short[]{226, 180, 148}, "Diluted Samarium Rare Earth Solution", BWUtil.subscriptNumbers("Sm?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11463, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SamariumOxalate = new Werkstoff(new short[]{248, 248, 180}, "Samarium(III) Oxalate", BWUtil.subscriptNumbers("Sm2(C2O4)3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11464, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SamariumChloride = new Werkstoff(new short[]{248, 248, 120}, "Samarium(III)-Chloride", BWUtil.subscriptNumbers("SmCl3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten(), 11465, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SamariumChlorideSodiumChlorideBlend = new Werkstoff(new short[]{255, 200, 230}, "Samarium Chloride-Sodium Chloride Blend", BWUtil.subscriptNumbers("SmCl3NaCl"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11466, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff ImpureLanthanumChloride = new Werkstoff(new short[]{90, 100, 30}, "Impure Lanthanum Chloride", BWUtil.subscriptNumbers("La?Cl3"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11467, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SamariumOxide = new Werkstoff(new short[]{223, 182, 193}, "Samarium Oxide", BWUtil.subscriptNumbers("Sm2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11468, TextureSet.SET_DULL, Arrays.asList(Materials.Samarium, Materials.Oxygen), Pair.of((Object)Materials.Samarium, (Object)2), Pair.of((Object)Materials.Oxygen, (Object)3));
    public static final Werkstoff ChlorinatedRareEarthConcentrate = new Werkstoff(new short[]{130, 80, 60}, "Chlorinated Rare Earth Concentrate", BWUtil.subscriptNumbers("Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11469, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ChlorinatedRareEarthEnrichedSolution = new Werkstoff(new short[]{130, 90, 60}, "Chlorinated Rare Earth Enriched Solution", BWUtil.subscriptNumbers("Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11470, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ChlorinatedRareEarthDilutedSolution = new Werkstoff(new short[]{216, 180, 100}, "Chlorinated Rare Earth Diluted Solution", BWUtil.subscriptNumbers("Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11471, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff RarestEarthResidue = new Werkstoff(new short[]{224, 211, 211}, "Rarest Earth Residue", BWUtil.subscriptNumbers("????"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11472, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff LanthanumExtractingNanoResin = new Werkstoff(new short[]{50, 80, 40}, "Lanthanum Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11401, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledLanthanumExtractingNanoResin = new Werkstoff(new short[]{128, 128, 80}, "Filled Lanthanum Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11402, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PraseodymiumExtractingNanoResin = new Werkstoff(new short[]{80, 192, 130}, "Praseodymium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11403, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledPraseodymiumExtractingNanoResin = new Werkstoff(new short[]{140, 192, 130}, "Filled Praseodymium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11404, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff CeriumExtractingNanoResin = new Werkstoff(new short[]{80, 240, 160}, "Cerium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11405, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledCeriumExtractingNanoResin = new Werkstoff(new short[]{160, 240, 180}, "Filled Cerium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11406, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff NeodymiumExtractingNanoResin = new Werkstoff(new short[]{128, 140, 128}, "Neodymium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11407, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledNeodymiumExtractingNanoResin = new Werkstoff(new short[]{150, 150, 150}, "Filled Neodymium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11408, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PromethiumExtractingNanoResin = new Werkstoff(new short[]{110, 255, 60}, "Promethium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11409, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledPromethiumExtractingNanoResin = new Werkstoff(new short[]{150, 255, 140}, "Filled Promethium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11410, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SamariumExtractingNanoResin = new Werkstoff(new short[]{255, 240, 100}, "Samarium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11411, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledSamariumExtractingNanoResin = new Werkstoff(new short[]{255, 240, 196}, "Filled Samarium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11412, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff EuropiumExtractingNanoResin = new Werkstoff(new short[]{240, 160, 240}, "Europium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11413, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledEuropiumExtractingNanoResin = new Werkstoff(new short[]{240, 200, 240}, "Filled Europium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11414, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff GadoliniumExtractingNanoResin = new Werkstoff(new short[]{120, 255, 80}, "Gadolinium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11415, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledGadoliniumExtractingNanoResin = new Werkstoff(new short[]{160, 255, 140}, "Filled Gadolinium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11416, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff TerbiumExtractingNanoResin = new Werkstoff(new short[]{200, 200, 200}, "Terbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11417, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledTerbiumExtractingNanoResin = new Werkstoff(new short[]{255, 255, 255}, "Filled Terbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11418, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DysprosiumExtractingNanoResin = new Werkstoff(new short[]{110, 240, 180}, "Dysprosium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11419, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledDysprosiumExtractingNanoResin = new Werkstoff(new short[]{150, 240, 180}, "Filled Dysprosium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11420, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff HolmiumExtractingNanoResin = new Werkstoff(new short[]{16, 16, 216}, "Holmium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11421, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledHolmiumExtractingNanoResin = new Werkstoff(new short[]{60, 90, 255}, "Filled Holmium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11422, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ErbiumExtractingNanoResin = new Werkstoff(new short[]{200, 160, 80}, "Erbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11423, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledErbiumExtractingNanoResin = new Werkstoff(new short[]{233, 170, 100}, "Filled Erbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11424, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ThuliumExtractingNanoResin = new Werkstoff(new short[]{128, 178, 255}, "Thulium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11425, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledThuliumExtractingNanoResin = new Werkstoff(new short[]{160, 200, 255}, "Filled Thulium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11426, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff YtterbiumExtractingNanoResin = new Werkstoff(new short[]{0, 255, 0}, "Ytterbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11427, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledYtterbiumExtractingNanoResin = new Werkstoff(new short[]{100, 255, 100}, "Filled Ytterbium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11428, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff LutetiumExtractingNanoResin = new Werkstoff(new short[]{230, 16, 230}, "Lutetium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11429, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff FilledLutetiumExtractingNanoResin = new Werkstoff(new short[]{240, 100, 240}, "Filled Lutetium Extracting Nano Resin", new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addCells(), 11430, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff LanthanumChlorideConcentrate = new Werkstoff(new short[]{128, 128, 80}, "Lanthanum Chloride Concentrate", BWUtil.subscriptNumbers("La?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11431, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PraseodymiumChlorideConcentrate = new Werkstoff(new short[]{140, 192, 130}, "Praseodymium Chloride Concentrate", BWUtil.subscriptNumbers("Pr?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11432, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff CeriumChlorideConcentrate = new Werkstoff(new short[]{160, 240, 180}, "Cerium Chloride Concentrate", BWUtil.subscriptNumbers("Ce?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11433, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff NeodymiumChlorideConcentrate = new Werkstoff(new short[]{150, 150, 150}, "Neodymium Chloride Concentrate", BWUtil.subscriptNumbers("Nd?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11434, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff PromethiumChlorideConcentrate = new Werkstoff(new short[]{150, 255, 140}, "Promethium Chloride Concentrate", BWUtil.subscriptNumbers("Pm?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11435, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff SamariumChlorideConcentrate = new Werkstoff(new short[]{255, 240, 196}, "Samarium Chloride Concentrate", BWUtil.subscriptNumbers("Sm?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11436, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff EuropiumChlorideConcentrate = new Werkstoff(new short[]{240, 200, 240}, "Europium Chloride Concentrate", BWUtil.subscriptNumbers("Eu?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11437, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff GadoliniumChlorideConcentrate = new Werkstoff(new short[]{160, 255, 140}, "Gadolinium Chloride Concentrate", BWUtil.subscriptNumbers("Gd?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11438, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff TerbiumChlorideConcentrate = new Werkstoff(new short[]{255, 255, 255}, "Terbium Chloride Concentrate", BWUtil.subscriptNumbers("Tb?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11439, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff DysprosiumChlorideConcentrate = new Werkstoff(new short[]{150, 240, 180}, "Dysprosium Chloride Concentrate", BWUtil.subscriptNumbers("Dy?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11440, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff HolmiumChlorideConcentrate = new Werkstoff(new short[]{60, 90, 255}, "Holmium Chloride Concentrate", BWUtil.subscriptNumbers("Ho?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11441, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ErbiumChlorideConcentrate = new Werkstoff(new short[]{233, 170, 100}, "Erbium Chloride Concentrate", BWUtil.subscriptNumbers("Er?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11442, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff ThuliumChlorideConcentrate = new Werkstoff(new short[]{160, 200, 255}, "Thulium Chloride Concentrate", BWUtil.subscriptNumbers("Tm?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11443, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff YtterbiumChlorideConcentrate = new Werkstoff(new short[]{100, 255, 100}, "Ytterbium Chloride Concentrate", BWUtil.subscriptNumbers("Yb?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11444, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff LutetiumChlorideConcentrate = new Werkstoff(new short[]{240, 100, 240}, "Lutetium Chloride Concentrate", BWUtil.subscriptNumbers("Lu?Cl?") + "??", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11445, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff LanthanumOreConcentrate = new Werkstoff(new short[]{128, 128, 96}, "Lanthanum Ore Concentrate", BWUtil.subscriptNumbers("La?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11446, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff PraseodymiumOreConcentrate = new Werkstoff(new short[]{140, 192, 130}, "Praseodymium Ore Concentrate", BWUtil.subscriptNumbers("Pr?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11447, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumOreConcentrate = CeriumRichMixture;
    public static final Werkstoff NeodymiumOreConcentrate = new Werkstoff(new short[]{128, 128, 128}, "Neodymium Ore Concentrate", BWUtil.subscriptNumbers("Nd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11449, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff PromethiumOreConcentrate = new Werkstoff(new short[]{150, 255, 140}, "Promethium Ore Concentrate", BWUtil.subscriptNumbers("Po?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11450, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff EuropiumOreConcentrate = new Werkstoff(new short[]{240, 200, 240}, "Europium Ore Concentrate", BWUtil.subscriptNumbers("Eu?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11451, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff GadoliniumOreConcentrate = new Werkstoff(new short[]{160, 255, 140}, "Gadolinium Ore Concentrate", BWUtil.subscriptNumbers("Gd?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11452, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff TerbiumOreConcentrate = new Werkstoff(new short[]{255, 255, 255}, "Terbium Ore Concentrate", BWUtil.subscriptNumbers("Tb?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11453, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff DysprosiumOreConcentrate = new Werkstoff(new short[]{150, 240, 180}, "Dysprosium Ore Concentrate", BWUtil.subscriptNumbers("Dy?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11454, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff HolmiumOreConcentrate = new Werkstoff(new short[]{60, 90, 255}, "Holmium Ore Concentrate", BWUtil.subscriptNumbers("Ho?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11455, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff ErbiumOreConcentrate = new Werkstoff(new short[]{233, 170, 100}, "Erbium Ore Concentrate", BWUtil.subscriptNumbers("Er?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11456, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff ThuliumOreConcentrate = new Werkstoff(new short[]{160, 200, 255}, "Thulium Ore Concentrate", BWUtil.subscriptNumbers("Tm?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11457, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff YtterbiumOreConcentrate = new Werkstoff(new short[]{100, 255, 100}, "Ytterbium Ore Concentrate", BWUtil.subscriptNumbers("Yb?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11458, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff LutetiumOreConcentrate = new Werkstoff(new short[]{240, 100, 240}, "Lutetium Ore Concentrate", BWUtil.subscriptNumbers("Lu?"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11459, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumDopedLutetiumAluminiumOxygenBlend = new Werkstoff(new short[]{128, 192, 80}, "Cerium-doped Lutetium Aluminium Oxygen Blend", BWUtil.subscriptNumbers("CeLu3(Al2O3)5"), new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().onlyDust().addMolten(), 11498, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff CeriumDopedLutetiumAluminiumGarnet = new Werkstoff(new short[]{144, 255, 63}, "Cerium-doped Lutetium Aluminium Garnet (Ce:LuAG)", BWUtil.subscriptNumbers("CeLu3(Al2O3)5"), new Werkstoff.Stats(), Werkstoff.Types.MATERIAL, new Werkstoff.GenerationFeatures().disable().addGems(), 11499, TextureSet.SET_GEM_VERTICAL, new Pair[0]);
    public static final Werkstoff Permalloy = new Werkstoff(new short[]{195, 230, 225}, "Permalloy", BWUtil.subscriptNumbers("Ni4FeMo"), new Werkstoff.Stats().setCentrifuge(true), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addMixerRecipes((short)3).enforceUnification(), 11350, TextureSet.SET_DULL, Pair.of((Object)Materials.Nickel, (Object)4), Pair.of((Object)Materials.Iron, (Object)1), Pair.of((Object)Materials.Molybdenum, (Object)1));
    public static final Werkstoff MuMetal = new Werkstoff(new short[]{210, 230, 225}, "Mu-metal", new Werkstoff.Stats().setBlastFurnace(true).setCentrifuge(true).setMass(180L).setSpeedOverride(3.0f), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().addDoubleAndDensePlates().addCraftingMetalWorkingItems().enforceUnification(), 11351, TextureSet.SET_METALLIC, Pair.of((Object)Permalloy, (Object)9), Pair.of((Object)Materials.Copper, (Object)1), Pair.of((Object)Materials.Chrome, (Object)1));
    public static final Werkstoff Thorium234 = new Werkstoff(new short[]{0, 40, 0}, "Thorium 234", BWUtil.superscriptNumbers("234Th"), new Werkstoff.Stats().setBlastFurnace(true).setRadioactive(true), Werkstoff.Types.ISOTOPE, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11352, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff SiliconNitride = new Werkstoff(new short[]{132, 140, 120}, "Silicon Nitride", BWUtil.subscriptNumbers("Si3N4"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addMetalItems().enforceUnification(), 11353, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff Fluoroform = new Werkstoff(new short[]{0, 0, 0}, "Fluoroform", BWUtil.subscriptNumbers("CHF3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11354, TextureSet.SET_FLUID, Pair.of((Object)Materials.Carbon, (Object)1), Pair.of((Object)Materials.Hydrogen, (Object)1), Pair.of((Object)Materials.Fluorine, (Object)3));
    public static final Werkstoff FluoroformOxygenMix = new Werkstoff(new short[]{0, 0, 0}, "Reactive-Ion Etching Mixture", BWUtil.subscriptNumbers("CHF3/O2"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11355, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff BoronTrioxide = new Werkstoff(new short[]{238, 222, 209}, "Boron Trioxide", BWUtil.subscriptNumbers("B2O3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11356, TextureSet.SET_DULL, Pair.of((Object)Materials.Boron, (Object)2), Pair.of((Object)Materials.Oxygen, (Object)3));
    public static final Werkstoff BoronTrichloride = new Werkstoff(new short[]{154, 96, 208}, "Boron Trichloride", BWUtil.subscriptNumbers("BCl3"), new Werkstoff.Stats().setElektrolysis(true), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().addCells(), 11357, TextureSet.SET_FLUID, Pair.of((Object)Materials.Boron, (Object)1), Pair.of((Object)Materials.Chlorine, (Object)3));
    public static final Werkstoff LanthanumHexaboride = new Werkstoff(new short[]{140, 110, 120}, "Lanthanum Hexaboride", BWUtil.subscriptNumbers("LaB6"), new Werkstoff.Stats().setMass(200L), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust().addGems().addSimpleMetalWorkingItems(), 11358, TextureSet.SET_GEM_HORIZONTAL, Pair.of((Object)Materials.Lanthanum, (Object)1), Pair.of((Object)Materials.Boron, (Object)6));
    public static final Werkstoff LanthanumOxide = new Werkstoff(new short[]{105, 209, 180}, "Lanthanum Oxide", BWUtil.subscriptNumbers("La2O3"), new Werkstoff.Stats(), Werkstoff.Types.COMPOUND, new Werkstoff.GenerationFeatures().disable().onlyDust(), 11359, TextureSet.SET_DULL, new Pair[0]);
    public static final Werkstoff NitrogenPlasmaSilaneMix = new Werkstoff(new short[]{140, 125, 220}, "Silane-Nitrogen Plasma Mixture", BWUtil.subscriptNumbers("SiH4/N"), new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11360, TextureSet.SET_FLUID, new Pair[0]);
    public static final Werkstoff HotSuperCoolant = new Werkstoff(new short[]{155, 17, 30}, "Hot Super Coolant", new Werkstoff.Stats(), Werkstoff.Types.MIXTURE, new Werkstoff.GenerationFeatures().disable().addCells(), 11361, TextureSet.SET_FLUID, new Pair[0]);

    public static void runInit() {
        WerkstoffMaterialPool.addSubTags();
    }

    private static void addSubTags() {
    }

    @Override
    public void run() {
    }
}

