/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.google.common.math.LongMath;
import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.NumericWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;

public class MTEHatchWirelessMulti
extends MTEHatchEnergyMulti {
    private final long precisionMultiplier = LongMath.pow((long)10L, (int)15);
    private final BigInteger eu_transferred_per_operation = BigInteger.valueOf((long)this.Amperes * GTValues.V[this.mTier]).multiply(BigInteger.valueOf(WirelessNetworkManager.ticks_between_energy_addition));
    private final double overflowDivisor = this.getOverflowDivisor(this.eu_transferred_per_operation);
    private final long actualTicksBetweenEnergyAddition = this.overflowDivisor > 1.0 ? (long)((double)WirelessNetworkManager.ticks_between_energy_addition / (this.overflowDivisor * 2.0)) : WirelessNetworkManager.ticks_between_energy_addition;
    private final long eu_transferred_per_operation_long = this.overflowDivisor > 1.0 ? this.eu_transferred_per_operation.divide(BigInteger.valueOf((long)(this.overflowDivisor * (double)this.precisionMultiplier * 2.0))).multiply(BigInteger.valueOf(this.precisionMultiplier)).longValue() : this.eu_transferred_per_operation.longValue();
    private UUID owner_uuid;
    private ITexture[] TEXTURE_OVERLAY;

    public MTEHatchWirelessMulti(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{AnimatedTooltipHandler.GRAY + "Stores energy globally in a network, up to 2^(2^31) EU.", AnimatedTooltipHandler.GRAY + "Does not connect to wires. This block withdraws EU from the network.", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.screwdrivertooltip"), GTValues.AuthorColen + AnimatedTooltipHandler.GRAY + AnimatedTooltipHandler.BOLD + " & " + AnimatedTooltipHandler.BLUE + AnimatedTooltipHandler.BOLD + "Cloud", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + AnimatedTooltipHandler.YELLOW + GTUtility.formatNumbers((long)aAmp * GTValues.V[aTier]) + AnimatedTooltipHandler.GRAY + " EU/t"}, aAmp);
    }

    @Override
    public int getHatchType() {
        return this.maxAmperes <= 64 ? 1 : 2;
    }

    public MTEHatchWirelessMulti(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    private double getOverflowDivisor(BigInteger euTransferredPerOperation) {
        if (euTransferredPerOperation.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            return euTransferredPerOperation.doubleValue() / 9.223372036854776E18;
        }
        return 1.0;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        switch (this.Amperes) {
            case 4: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_4A;
                break;
            }
            case 16: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_16A;
                break;
            }
            case 64: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_64A;
                break;
            }
            default: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER;
            }
        }
        return new ITexture[]{aBaseTexture, this.TEXTURE_OVERLAY[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        switch (this.Amperes) {
            case 4: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_4A;
                break;
            }
            case 16: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_16A;
                break;
            }
            case 64: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_64A;
                break;
            }
            default: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER;
            }
        }
        return new ITexture[]{aBaseTexture, this.TEXTURE_OVERLAY[this.mTier]};
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return (long)this.Amperes * GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return (long)((double)WirelessNetworkManager.totalStorage(GTValues.V[this.mTier]) / (2.0 * this.overflowDivisor) * (double)this.Amperes);
    }

    @Override
    public long maxAmperesIn() {
        return this.Amperes;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessMulti(this.mName, this.mTier, this.Amperes, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.WIRELESS;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.owner_uuid = aBaseMetaTileEntity.getOwnerUuid();
            WirelessNetworkManager.strongCheckOrAddUser(this.owner_uuid);
            this.tryFetchingEnergy();
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % this.actualTicksBetweenEnergyAddition == 0L) {
            this.tryFetchingEnergy();
        }
    }

    private void tryFetchingEnergy() {
        long currentEU = this.getBaseMetaTileEntity().getStoredEU();
        long maxEU = this.maxEUStore();
        long euToTransfer = Long.min(maxEU - currentEU, this.eu_transferred_per_operation_long);
        if (euToTransfer <= 0L) {
            return;
        }
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap(this.owner_uuid, -euToTransfer)) {
            return;
        }
        this.setEUVar(currentEU + euToTransfer);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.Amperes != this.maxAmperes) {
            aNBT.func_74768_a("amperes", this.Amperes);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        int savedAmperes = aNBT.func_74762_e("amperes");
        if (savedAmperes != 0) {
            this.Amperes = savedAmperes;
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.openGui(aPlayer);
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        int x = this.getGUIWidth() / 2 - 37;
        int y = this.getGUIHeight() / 5 - 7;
        ((ModularWindow.Builder)builder.widget(TextWidget.localised((String)"GT5U.machines.laser_hatch.amperage", (Object[])new Object[0]).setPos(x, y).setSize(74, 14))).widget(new NumericWidget().setSetter(val -> {
            this.Amperes = (int)val;
        }).setGetter(() -> this.Amperes).setBounds(1.0, (double)this.maxAmperes).setScrollValues(1.0, 4.0, 64.0).setTextAlignment(Alignment.Center).setTextColor(Color.WHITE.normal).setSize(70, 18).setPos(x, y + 16).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD}));
    }
}

