/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.casing.Casings;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.StructureError;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.structure.IStructureInstance;
import gregtech.api.structure.IStructureProvider;
import gregtech.api.structure.StructureWrapper;
import gregtech.api.structure.StructureWrapperInstanceInfo;
import gregtech.api.structure.StructureWrapperTooltipBuilder;
import gregtech.api.util.GTDataUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.misc.GTStructureChannels;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.CustomItemList;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTENetworkSwitchAdv
extends TTMultiblockBase
implements ISurvivalConstructable,
IStructureProvider<MTENetworkSwitchAdv> {
    private static final String STRUCTURE_SHAPE_FIRST = "first";
    private static final String STRUCTURE_SHAPE_MIDDLE = "middle";
    private static final String STRUCTURE_SHAPE_LAST = "last";
    private static final String[] FIRST = new String[]{"AAA", "A~A", "AAA"};
    private static final String[] MIDDLE = new String[]{"ACA", "CBC", "ACA"};
    private static final String[] LAST = new String[]{"AAA", "ACA", "AAA"};
    private static final int MAX_LENGTH = 16;
    protected final StructureWrapper<MTENetworkSwitchAdv> structure;
    protected final StructureWrapperInstanceInfo<MTENetworkSwitchAdv> structureInstanceInfo;
    private int length;
    private long pendingComputation;
    private long wastedComputation;

    public MTENetworkSwitchAdv(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.structure = new StructureWrapper<MTENetworkSwitchAdv>(this);
        this.structureInstanceInfo = null;
        this.structure.loadStructure();
    }

    public MTENetworkSwitchAdv(MTENetworkSwitchAdv prototype) {
        super(prototype.mName);
        this.structure = prototype.structure;
        this.structureInstanceInfo = new StructureWrapperInstanceInfo<MTENetworkSwitchAdv>(this.structure);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENetworkSwitchAdv(this);
    }

    @Override
    public String[][] getDefinition() {
        return new String[][]{FIRST, MIDDLE, LAST};
    }

    @Override
    public String[][] getMaxDefinition() {
        ArrayList<String[]> slices = new ArrayList<String[]>();
        slices.add(FIRST);
        for (int i = 0; i < 16; ++i) {
            slices.add(MIDDLE);
        }
        slices.add(LAST);
        return (String[][])slices.toArray((T[])new String[0][]);
    }

    @Override
    public IStructureDefinition<MTENetworkSwitchAdv> compile(String[][] definition) {
        this.structure.addCasing('A', Casings.ComputerCasing).withUnlimitedHatches(1, Arrays.asList(HatchElement.Energy, TTMultiblockBase.HatchElement.EnergyMulti, HatchElement.Dynamo, TTMultiblockBase.HatchElement.DynamoMulti, TTMultiblockBase.HatchElement.OutputData));
        this.structure.addCasing('B', Casings.AdvancedComputerCasing);
        this.structure.addCasing('C', Casings.AdvancedComputerCasing).withUnlimitedHatches(2, Arrays.asList(TTMultiblockBase.HatchElement.InputData, TTMultiblockBase.HatchElement.OutputData));
        List<Pair<String, String[][]>> shapes = Arrays.asList(Pair.of((Object)STRUCTURE_SHAPE_FIRST, (Object)new String[][]{FIRST}), Pair.of((Object)STRUCTURE_SHAPE_MIDDLE, (Object)new String[][]{MIDDLE}), Pair.of((Object)STRUCTURE_SHAPE_LAST, (Object)new String[][]{LAST}));
        return this.structure.getStructureBuilder(shapes).build();
    }

    @Override
    public IStructureInstance getStructureInstance() {
        return this.structureInstanceInfo;
    }

    @Override
    public IStructureDefinition<? extends TTMultiblockBase> getStructure_EM() {
        return this.structure.structureDefinition;
    }

    public void construct(ItemStack trigger, boolean hintsOnly) {
        int length = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(trigger, 1, 16);
        Vec3Impl offset = new Vec3Impl(0, 0, 0);
        Vec3Impl inc = new Vec3Impl(0, 0, -1);
        this.structure.construct(this, trigger, hintsOnly, STRUCTURE_SHAPE_FIRST, offset);
        for (int i = 0; i < length; ++i) {
            offset = offset.add(inc);
            this.structure.construct(this, trigger, hintsOnly, STRUCTURE_SHAPE_MIDDLE, offset);
        }
        offset = offset.add(inc);
        this.structure.construct(this, trigger, hintsOnly, STRUCTURE_SHAPE_LAST, offset);
    }

    public int survivalConstruct(ItemStack trigger, int elementBudget, ISurvivalBuildEnvironment env) {
        int length = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(trigger, 1, 16);
        Vec3Impl offset = new Vec3Impl(0, 0, 0);
        Vec3Impl inc = new Vec3Impl(0, 0, -1);
        int built = 0;
        int temp = this.structure.survivalConstruct(this, trigger, elementBudget - built, env, STRUCTURE_SHAPE_FIRST, offset);
        if (temp > -1) {
            built += temp;
        }
        if (elementBudget - built <= 0) {
            return built;
        }
        for (int i = 0; i < length; ++i) {
            temp = this.structure.survivalConstruct(this, trigger, elementBudget - built, env, STRUCTURE_SHAPE_MIDDLE, offset = offset.add(inc));
            if (temp > -1) {
                built += temp;
            }
            if (elementBudget - built > 0) continue;
            return built;
        }
        temp = this.structure.survivalConstruct(this, trigger, elementBudget - built, env, STRUCTURE_SHAPE_LAST, offset = offset.add(inc));
        if (temp > -1) {
            built += temp;
        }
        return temp == -1 ? -1 : built;
    }

    private void resetDataHatches() {
        for (MTEHatchDataOutput output : GTUtility.validMTEList(this.eOutputData)) {
            output.allowComputationConfiguring = false;
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.resetDataHatches();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.resetDataHatches();
    }

    @Override
    protected void clearHatches_EM() {
        this.resetDataHatches();
        super.clearHatches_EM();
        this.length = 0;
        this.structureInstanceInfo.clearHatches();
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        Vec3Impl offset = new Vec3Impl(0, 0, 0);
        Vec3Impl inc = new Vec3Impl(0, 0, -1);
        if (!this.structure.checkStructure(this, STRUCTURE_SHAPE_FIRST, offset)) {
            return false;
        }
        offset = offset.add(inc);
        while (this.length < 16 && this.structure.checkStructure(this, STRUCTURE_SHAPE_MIDDLE, offset)) {
            ++this.length;
            offset = offset.add(inc);
        }
        if (!this.structure.checkStructure(this, STRUCTURE_SHAPE_LAST, offset)) {
            return false;
        }
        for (MTEHatchDataOutput output : GTUtility.validMTEList(this.eOutputData)) {
            output.allowComputationConfiguring = true;
        }
        GTDataUtils.dedupList(this.mExoticEnergyHatches);
        GTDataUtils.dedupList(this.mEnergyHatches);
        GTDataUtils.dedupList(this.eEnergyMulti);
        GTDataUtils.dedupList(this.eDynamoMulti);
        GTDataUtils.dedupList(this.eInputData);
        GTDataUtils.dedupList(this.eOutputData);
        return true;
    }

    @Override
    protected void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        this.structureInstanceInfo.validate(errors, context);
    }

    @Override
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        this.structureInstanceInfo.localizeStructureErrors(errors, context, lines);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        StructureWrapperTooltipBuilder<MTENetworkSwitchAdv> tt = new StructureWrapperTooltipBuilder<MTENetworkSwitchAdv>(this.structure);
        tt.addMachineType("Static Network Switch With QoS").addInfo("Variable-length version of the Weighted Network Switch.").addSeparator().addInfo("Consumes \u00a7b524,288\u00a77 EU/t per middle slice while active.").addSeparator().addInfo("Computation output is configured by right clicking transmission connectors with a screwdriver.").addInfo("Transmission connectors must be part of the structure for them to be configurable.").addInfo("Computation output for a hatch is directly controlled by the hatch's setting.").addInfo("For weighted computation distribution, use the \u00a76" + CustomItemList.Machine_Multi_Switch.get(1L, new Object[0]).func_82833_r() + "\u00a7r.").addSeparator();
        tt.beginStructureBlock();
        tt.addAllCasingInfo();
        tt.addSubChannelUsage(GTStructureChannels.STRUCTURE_LENGTH, "middle slice count");
        tt.toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public boolean shouldCheckMaintenance() {
        return false;
    }

    @Override
    protected boolean checkComputationTimeout() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ArrayList<ITexture> textures = new ArrayList<ITexture>();
        textures.add(Casings.AdvancedComputerCasing.getCasingTexture());
        if (side == facing) {
            textures.add(new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF));
        }
        return textures.toArray(new ITexture[0]);
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.useLongPower = true;
        this.lEUt = 0L;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.pendingComputation = 0L;
        for (MTEHatchDataInput di : GTUtility.validMTEList(this.eInputData)) {
            if (di.q == null) continue;
            this.pendingComputation += ((Long)((QuantumDataPacket)di.q).getContent()).longValue();
            di.setContents(null);
        }
        if (this.pendingComputation < 0L) {
            this.pendingComputation = Long.MAX_VALUE;
        }
        if (this.pendingComputation == 0L) {
            return SimpleCheckRecipeResult.ofFailure("no_routing");
        }
        this.lEUt = (long)this.length * -524288L;
        this.mMaxProgresstime = 20;
        this.mEfficiencyIncrease = 10000;
        return SimpleCheckRecipeResult.ofSuccess("routing");
    }

    @Override
    public void outputAfterRecipe_EM() {
        super.outputAfterRecipe_EM();
        Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
        for (MTEHatchDataOutput output : GTUtility.validMTEList(this.eOutputData)) {
            if (this.pendingComputation <= 0L) break;
            long toConsume = Math.min(this.pendingComputation, output.requestedComputation);
            this.pendingComputation -= toConsume;
            output.providePacket(new QuantumDataPacket(toConsume).unifyTraceWith(pos));
        }
        this.wastedComputation = this.pendingComputation;
        this.pendingComputation = 0L;
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        screenElements.widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.pendingComputation, value -> {
            this.pendingComputation = value;
        }));
        screenElements.widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.wastedComputation, value -> {
            this.wastedComputation = value;
        }));
        screenElements.widget(TextWidget.dynamicString(() -> GTUtility.translate("GT5U.machines.computation_hatch.pending_computation", GTUtility.formatNumbers(this.pendingComputation))).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.mMaxProgresstime > 0));
        screenElements.widget(TextWidget.dynamicString(() -> GTUtility.translate("GT5U.machines.computation_hatch.wasted_computation", GTUtility.formatNumbers(this.wastedComputation))).setSynced(false).setTextAlignment(Alignment.CenterLeft).setEnabled(w -> this.mMaxProgresstime > 0));
    }
}

