/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.API.SideReference;
import bartworks.MainMod;
import bartworks.common.tileentities.multis.MTEBioVat;
import bartworks.util.BWColorUtil;
import bartworks.util.Coords;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.IBlockAccess;

public class PacketBioVatRenderer
extends GTPacket {
    private Coords coords;
    private int integer;
    private byte removal;

    public PacketBioVatRenderer() {
    }

    public PacketBioVatRenderer(Coords coords, int integer, boolean removal) {
        this.coords = coords;
        this.integer = integer;
        this.removal = (byte)(removal ? 1 : 0);
    }

    @Override
    public byte getPacketID() {
        return 23;
    }

    @Override
    public void encode(ByteBuf aOut) {
        byte r = (byte)(this.integer >> 16 & 0xFF);
        byte g = (byte)(this.integer >> 8 & 0xFF);
        byte b = (byte)(this.integer & 0xFF);
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        aOut.writeInt(this.coords.x).writeShort((int)this.coords.y).writeInt(this.coords.z).writeInt(this.coords.wID).writeByte((int)r).writeByte((int)g).writeByte((int)b).writeByte((int)this.removal).writeByte((int)checksum);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput dataInput) {
        this.coords = new Coords(dataInput.readInt(), dataInput.readShort(), dataInput.readInt(), dataInput.readInt());
        this.integer = BWColorUtil.getColorFromRGBArray(new int[]{dataInput.readByte(), dataInput.readByte(), dataInput.readByte()});
        this.removal = dataInput.readByte();
        byte checksum = (byte)(this.coords.x % 25 + this.coords.y % 25 + this.coords.z % 25 + this.coords.wID % 25 + this.integer % 25 + this.removal);
        if (checksum != dataInput.readByte()) {
            MainMod.LOGGER.error("BW Packet was corrupted or modified!");
            return null;
        }
        return new PacketBioVatRenderer(this.coords, this.integer, this.removal == 1);
    }

    @Override
    public void process(IBlockAccess iBlockAccess) {
        if (SideReference.Side.Client) {
            if (this.removal == 0) {
                MTEBioVat.staticColorMap.put(this.coords, this.integer);
            } else {
                MTEBioVat.staticColorMap.remove(this.coords);
            }
        }
    }
}

