/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.gtenhancement;

import bartworks.system.material.BWMetaGeneratedItems;
import bartworks.system.material.Werkstoff;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.items.GTGenericBlock;
import gregtech.api.items.GTGenericItem;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.mixin.interfaces.accessors.IRecipeMutableAccess;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import tectech.recipe.TecTechRecipeMaps;

public class PlatinumSludgeOverHaul {
    private static final Materials[] BLACKLIST = new Materials[]{Materials.HSSS, Materials.EnderiumBase, Materials.Osmiridium, Materials.TPV, Materials.get("Uraniumtriplatinid"), Materials.get("Tetranaquadahdiindiumhexaplatiumosminid"), Materials.get("Longasssuperconductornameforuvwire")};
    private static final OrePrefixes[] OPBLACKLIST = new OrePrefixes[]{OrePrefixes.crushedCentrifuged, OrePrefixes.crushed, OrePrefixes.crushedPurified, OrePrefixes.dustPure, OrePrefixes.dustImpure, OrePrefixes.dustRefined, OrePrefixes.dust, OrePrefixes.dustTiny, OrePrefixes.dustSmall};

    private PlatinumSludgeOverHaul() {
    }

    private static void runHelperrecipes() {
        GTValues.RA.stdBuilder().itemInputs(Materials.SulfuricAcid.getCells(2), Materials.Water.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.DilutedSulfuricAcid.getCells(3)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Water.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Empty.getCells(1)).fluidInputs(Materials.SulfuricAcid.getFluid(2000L)).fluidOutputs(Materials.DilutedSulfuricAcid.getFluid(3000L)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.SulfuricAcid.getCells(2), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Empty.getCells(2)).fluidInputs(Materials.Water.getFluid(1000L)).fluidOutputs(Materials.DilutedSulfuricAcid.getFluid(3000L)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.CarbonMonoxide.getCells(1), Materials.SodiumHydroxide.getDust(3)).itemOutputs(WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell)).duration(15).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Sodiumformate.get(OrePrefixes.cell, 2), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.FormicAcid.get(OrePrefixes.cell, 2), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7)).fluidInputs(Materials.SulfuricAcid.getFluid(1000L)).duration(15).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(Materials.SulfuricAcid.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Empty.getCells(1), WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7)).fluidInputs(WerkstoffLoader.Sodiumformate.getFluidOrGas(2000)).fluidOutputs(WerkstoffLoader.FormicAcid.getFluidOrGas(2000)).duration(15).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.HydrochloricAcid.getCells(3), Materials.NitricAcid.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.AquaRegia.get(OrePrefixes.cell, 4)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.HydrochloricAcid.getCells(3), Materials.NitricAcid.getCells(1), GTUtility.getIntegratedCircuit(2)).itemOutputs(Materials.Empty.getCells(4)).fluidOutputs(WerkstoffLoader.AquaRegia.getFluidOrGas(4000)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.NitricAcid.getCells(1), GTUtility.getIntegratedCircuit(3)).itemOutputs(Materials.Empty.getCells(1)).fluidInputs(Materials.HydrochloricAcid.getFluid(3000L)).fluidOutputs(WerkstoffLoader.AquaRegia.getFluidOrGas(4000)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.HydrochloricAcid.getCells(3), GTUtility.getIntegratedCircuit(4)).itemOutputs(Materials.Empty.getCells(3)).fluidInputs(Materials.NitricAcid.getFluid(1000L)).fluidOutputs(WerkstoffLoader.AquaRegia.getFluidOrGas(4000)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Ammonia.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 1)).fluidInputs(Materials.HydrochloricAcid.getFluid(1000L)).duration(15).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(Materials.HydrochloricAcid.getCells(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Empty.getCells(1)).fluidInputs(Materials.Ammonia.getGas(1000L)).fluidOutputs(WerkstoffLoader.AmmoniumChloride.getFluidOrGas(1000)).duration(15).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(9)).fluidInputs(Materials.Ammonia.getGas(64000L), Materials.HydrochloricAcid.getFluid(64000L)).fluidOutputs(WerkstoffLoader.AmmoniumChloride.getFluidOrGas(64000)).duration(60).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        for (Werkstoff w : Werkstoff.werkstoffHashSet) {
            if (!w.containsStuff(Materials.Sulfur) || !w.containsStuff(Materials.Copper) && !w.containsStuff(Materials.Nickel)) continue;
            GTValues.RA.stdBuilder().itemInputs(w.get(OrePrefixes.crushedPurified), GTUtility.getIntegratedCircuit(1)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(300)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(300)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
            GTValues.RA.stdBuilder().itemInputs(w.get(OrePrefixes.crushedPurified, 9), GTUtility.getIntegratedCircuit(9)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(2700)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(2700)).duration(225).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
            GTValues.RA.stdBuilder().itemInputs(w.get(OrePrefixes.crushedPurified, 9), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9)).itemOutputs(WerkstoffLoader.PTResidue.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(20700)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(20700)).duration(2250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        }
        for (Materials m : Materials.values()) {
            if (!PlatinumSludgeOverHaul.materialsContains(m, Materials.Sulfur) || !PlatinumSludgeOverHaul.materialsContains(m, Materials.Copper) && !PlatinumSludgeOverHaul.materialsContains(m, Materials.Nickel)) continue;
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.crushedPurified, m, 1L), GTUtility.getIntegratedCircuit(1)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(300)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(300)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.crushedPurified, m, 9L), GTUtility.getIntegratedCircuit(9)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(2700)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(2700)).duration(2250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.crushedPurified, m, 9L), WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9)).itemOutputs(WerkstoffLoader.PTResidue.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(20700)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(20700)).duration(2250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        }
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 3), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Platinum.getNuggets(2)).duration(600).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, Materials.Platinum.mMeltingPoint).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.PTResidue.get(OrePrefixes.dustTiny)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(2000)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(2000)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, 9), GTUtility.getIntegratedCircuit(9)).itemOutputs(WerkstoffLoader.PTResidue.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.AquaRegia.getFluidOrGas(18000)).fluidOutputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(18000)).duration(2250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTConcentrate.get(OrePrefixes.cell, 8)).itemOutputs(WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 32), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 8), Materials.NitrogenDioxide.getCells(2), Materials.HydrochloricAcid.getCells(6)).fluidInputs(WerkstoffLoader.AmmoniumChloride.getFluidOrGas(800)).fluidOutputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(800)).duration(2400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dustTiny, 32), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dustTiny, 8)).fluidInputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(8000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(800)).fluidOutputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(800), Materials.NitrogenDioxide.getGas(2000L), Materials.HydrochloricAcid.getFluid(6000L)).duration(1200).eut(30).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3)).itemOutputs(WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust, 16), WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 4)).fluidInputs(WerkstoffLoader.PTConcentrate.getFluidOrGas(36000), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(3600)).fluidOutputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(3600), Materials.NitrogenDioxide.getGas(9000L), Materials.HydrochloricAcid.getFluid(27000L)).duration(700).eut(480).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTSaltCrude.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust)).outputChances(1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500).duration(600).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTSaltRefined.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust)).fluidOutputs(Materials.Chlorine.getGas(87L)).duration(200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 900).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTRawPowder.get(OrePrefixes.dust, 4), Materials.Calcium.getDust(1)).itemOutputs(Materials.Platinum.getDust(2), WerkstoffLoader.CalciumChloride.get(OrePrefixes.dust, 3)).duration(30).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).fluidInputs(Materials.Ammonia.getGas(1000L)).fluidOutputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.PDSalt.get(OrePrefixes.dustTiny, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dustTiny, 2)).fluidInputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, 9), GTUtility.getIntegratedCircuit(9)).itemOutputs(WerkstoffLoader.PDSalt.get(OrePrefixes.dust, 16), WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 2)).fluidInputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(9000)).duration(2250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2)).itemOutputs(WerkstoffLoader.PDSalt.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.PDAmmonia.getFluidOrGas(1000)).duration(250).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDSalt.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust)).outputChances(1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500).duration(600).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 4), Materials.Empty.getCells(1)).itemOutputs(Materials.Palladium.getDust(2), Materials.Ethylene.getCells(1)).fluidInputs(WerkstoffLoader.FormicAcid.getFluidOrGas(4000)).fluidOutputs(Materials.Ammonia.getGas(4000L)).duration(250).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.chemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PDRawPowder.get(OrePrefixes.dust, 4)).itemOutputs(Materials.Palladium.getDust(2)).fluidInputs(WerkstoffLoader.FormicAcid.getFluidOrGas(4000)).fluidOutputs(Materials.Ammonia.getGas(4000L), Materials.Ethylene.getGas(1000L), Materials.Water.getFluid(1000L)).duration(250).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.Sodiumsulfate.get(OrePrefixes.dust, 7), Materials.Hydrogen.getCells(2)).itemOutputs(Materials.Sodium.getDust(2), Materials.Empty.getCells(2)).fluidOutputs(Materials.SulfuricAcid.getFluid(1000L)).duration(30).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.PTResidue.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(11)).itemOutputs(WerkstoffLoader.LeachResidue.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.PotassiumDisulfate.getMolten(360)).fluidOutputs(WerkstoffLoader.RHSulfate.getFluidOrGas(360)).duration(200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 775).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, 10), Materials.Saltpeter.getDust(10)).itemOutputs(WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 3), WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 6)).fluidInputs(Materials.SaltWater.getFluid(1000L)).fluidOutputs(Materials.Steam.getGas(1000L)).duration(200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 775).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.SodiumRuthenate.get(OrePrefixes.dust, 6), Materials.Chlorine.getCells(3)).itemOutputs(Materials.Empty.getCells(3)).fluidOutputs(WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(9000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(WerkstoffLoader.RutheniumTetroxideSollution.getFluidOrGas(1000)).fluidOutputs(WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(2000)).duration(300).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidHeaterRecipes);
        GTValues.RA.stdBuilder().itemOutputs(Materials.Salt.getDust(6)).fluidInputs(WerkstoffLoader.HotRutheniumTetroxideSollution.getFluidOrGas(9000)).fluidOutputs(Materials.Water.getFluid(1800L), WerkstoffLoader.RutheniumTetroxide.getFluidOrGas(7200)).duration(1500).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.distillationTowerRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RutheniumTetroxide.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getCells(6)).itemOutputs(WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), Materials.Chlorine.getCells(6)).fluidOutputs(Materials.Water.getFluid(2000L)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, 2), GTUtility.getIntegratedCircuit(11)).itemOutputs(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, 1)).fluidInputs(Materials.HydrochloricAcid.getFluid(500L)).fluidOutputs(WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000)).duration(100).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 775).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().fluidInputs(WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000)).fluidOutputs(WerkstoffLoader.OsmiumSolution.getFluidOrGas(100), Materials.Water.getFluid(900L)).duration(150).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.distillationTowerRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.OsmiumSolution.get(OrePrefixes.cell), Materials.HydrochloricAcid.getCells(6)).itemOutputs(Materials.Osmium.getDust(1), Materials.Chlorine.getCells(7)).fluidOutputs(Materials.Water.getFluid(2000L)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.PGSDResidue.get(OrePrefixes.dust), WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust)).duration(200).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 775).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.IridiumDioxide.get(OrePrefixes.dust), Materials.HydrochloricAcid.getCells(1)).itemOutputs(Materials.Empty.getCells(1)).fluidOutputs(WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.AcidicIridiumSolution.get(OrePrefixes.cell), WerkstoffLoader.AmmoniumChloride.get(OrePrefixes.cell, 3)).itemOutputs(Materials.Empty.getCells(4), WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust)).fluidOutputs(Materials.Ammonia.getGas(3000L)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.IridiumChloride.get(OrePrefixes.dust), Materials.Calcium.getDust(1)).itemOutputs(WerkstoffLoader.PGSDResidue2.get(OrePrefixes.dust), Materials.Iridium.getDust(1)).fluidOutputs(WerkstoffLoader.CalciumChloride.getFluidOrGas(3000)).duration(300).eut(TierEU.RECIPE_EV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RHSulfate.get(OrePrefixes.cell, 11), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.RHSulfateSolution.get(OrePrefixes.cell, 11), WerkstoffLoader.LeachResidue.get(OrePrefixes.dustTiny, 10)).fluidInputs(Materials.Water.getFluid(10000L)).fluidOutputs(Materials.Potassium.getMolten(2000L)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3)).itemOutputs(WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, 4)).fluidInputs(Materials.Water.getFluid(36000L), WerkstoffLoader.RHSulfate.getFluidOrGas(39600)).fluidOutputs(Materials.Potassium.getMolten(7200L), WerkstoffLoader.RHSulfateSolution.getFluidOrGas(39600)).duration(1200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(Materials.Zinc.getDust(1)).itemOutputs(WerkstoffLoader.ZincSulfate.get(OrePrefixes.dust, 6), WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.RHSulfateSolution.getFluidOrGas(1000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust), Materials.Salt.getDust(1)).itemOutputs(WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 3)).fluidInputs(Materials.Chlorine.getGas(1000L)).duration(300).eut(TierEU.RECIPE_MV).metadata(GTRecipeConstants.COIL_HEAT, 600).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RHSalt.get(OrePrefixes.dust, 1)).fluidInputs(Materials.Water.getFluid(200L)).fluidOutputs(WerkstoffLoader.RHSaltSolution.getFluidOrGas(200)).duration(30).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.SodiumNitrate.get(OrePrefixes.dust, 5), GTUtility.getIntegratedCircuit(1)).itemOutputs(WerkstoffLoader.RHNitrate.get(OrePrefixes.dust), Materials.Salt.getDust(2)).fluidInputs(WerkstoffLoader.RHSaltSolution.getFluidOrGas(1000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(Materials.Sodium.getDust(1)).itemOutputs(WerkstoffLoader.SodiumNitrate.get(OrePrefixes.dust, 5)).fluidInputs(Materials.NitricAcid.getFluid(1000L)).fluidOutputs(Materials.Hydrogen.getGas(1000L)).duration(8).eut(60).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RHNitrate.get(OrePrefixes.dust)).itemOutputs(WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust), WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust)).outputChances(1000, 1000, 1000, 1000, 1000, 1000, 1000, 1000, 1500).duration(600).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.RhFilterCake.get(OrePrefixes.dust)).fluidInputs(Materials.Water.getFluid(1000L)).fluidOutputs(WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.mixerRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2)).itemOutputs(WerkstoffLoader.ReRh.get(OrePrefixes.dust)).fluidInputs(WerkstoffLoader.RHFilterCakeSolution.getFluidOrGas(1000)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(WerkstoffLoader.ReRh.get(OrePrefixes.dust), Materials.Empty.getCells(1)).itemOutputs(WerkstoffLoader.Rhodium.get(OrePrefixes.dust), Materials.Ammonia.getCells(1)).fluidInputs(Materials.HydrochloricAcid.getFluid(1000L)).fluidOutputs(Materials.Chlorine.getGas(1000L)).duration(300).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
    }

    private static boolean materialsContains(Materials one, ISubTagContainer other) {
        if (one == null || one.mMaterialList == null || one.mMaterialList.isEmpty()) {
            return false;
        }
        for (MaterialStack stack : one.mMaterialList) {
            if (!stack.mMaterial.equals(other)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMapIgnored(RecipeMap<?> map) {
        return map == RecipeMaps.fusionRecipes || map == RecipeMaps.unpackagerRecipes || map == RecipeMaps.packagerRecipes || map == RecipeMaps.replicatorRecipes || map == TecTechRecipeMaps.eyeOfHarmonyRecipes || map == GTPPRecipeMaps.quantumForceTransformerRecipes || map == RecipeMaps.fluidExtractionRecipes || map == GTPPRecipeMaps.alloyBlastSmelterRecipes || map == GTPPRecipeMaps.vacuumFurnaceRecipes;
    }

    public static String displayRecipe(GTRecipe recipe) {
        StringBuilder result = new StringBuilder();
        result.append("Item inputs: ");
        for (ItemStack itemStack : recipe.mInputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.func_77977_a());
            result.append(", ");
        }
        result.append(" Fluid inputs: ");
        for (ItemStack itemStack : recipe.mFluidInputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.getUnlocalizedName());
            result.append(", ");
        }
        result.append(" Item outputs: ");
        for (ItemStack itemStack : recipe.mOutputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.func_77977_a());
            result.append(", ");
        }
        result.append(" Fluid outputs: ");
        for (ItemStack itemStack : recipe.mFluidOutputs) {
            if (itemStack == null) {
                result.append("nullstack, ");
                continue;
            }
            result.append(itemStack.getUnlocalizedName());
            result.append(", ");
        }
        return result.toString();
    }

    public static void replacePureElements() {
        ItemList[] values = ItemList.values();
        ArrayList<ItemStack> ITEMLIST_VALUES = new ArrayList<ItemStack>(values.length);
        for (ItemList e : values) {
            if (!e.hasBeenSet()) continue;
            ITEMLIST_VALUES.add(e.get(1L, new Object[0]));
        }
        for (Object e : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            Werkstoff mat;
            Map.Entry realEntry = (Map.Entry)e;
            if (!GTUtility.isStackValid(realEntry.getKey()) || !BWUtil.checkStackAndPrefix((ItemStack)realEntry.getKey())) continue;
            ItemData association = GTOreDictUnificator.getAssociation((ItemStack)realEntry.getKey());
            boolean isDust = OrePrefixes.dust.equals((Object)association.mPrefix) || OrePrefixes.dustTiny.equals((Object)association.mPrefix);
            ItemStack stack = (ItemStack)realEntry.getValue();
            if (isDust && association.mMaterial.mMaterial.equals(Materials.Platinum) || !GTUtility.isStackValid(stack) || !BWUtil.checkStackAndPrefix(stack)) continue;
            ItemData ass = GTOreDictUnificator.getAssociation(stack);
            OrePrefixes prefix = ass.mPrefix == OrePrefixes.nugget ? OrePrefixes.dustTiny : OrePrefixes.dust;
            boolean isPlatinumOrPalladium = ass.mMaterial.mMaterial.equals(Materials.Platinum) || ass.mMaterial.mMaterial.equals(Materials.Palladium);
            if (!isPlatinumOrPalladium) continue;
            Werkstoff werkstoff = mat = ass.mMaterial.mMaterial.equals(Materials.Platinum) ? WerkstoffLoader.PTMetallicPowder : WerkstoffLoader.PDMetallicPowder;
            if (PlatinumSludgeOverHaul.isInBlackList((ItemStack)realEntry.getKey(), ITEMLIST_VALUES)) continue;
            realEntry.setValue(mat.get(prefix, stack.field_77994_a * 2));
        }
        CraftingManager.func_77594_a().func_77592_b().forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        GTModHandler.sBufferRecipeList.forEach(PlatinumSludgeOverHaul::setnewMaterialInRecipe);
        block2: for (RecipeMap recipeMap : RecipeMap.ALL_RECIPE_MAPS.values()) {
            GTLog.err.println("Processing recipmap: " + recipeMap.unlocalizedName);
            if (PlatinumSludgeOverHaul.isMapIgnored(recipeMap)) continue;
            HashSet<GTRecipe> toDel = new HashSet<GTRecipe>();
            block3: for (GTRecipe recipe : recipeMap.getAllRecipes()) {
                int i;
                if (recipe.mFakeRecipe) continue block2;
                for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                    if (recipeMap.equals(RecipeMaps.multiblockChemicalReactorRecipes) || recipeMap.equals(RecipeMaps.chemicalReactorRecipes)) {
                        if (GTUtility.areFluidsEqual(WerkstoffLoader.Ruthenium.getMolten(1), recipe.mFluidOutputs[i]) || GTUtility.areFluidsEqual(WerkstoffLoader.Rhodium.getMolten(1), recipe.mFluidOutputs[i])) {
                            toDel.add(recipe);
                            GTLog.err.println("Recipe marked for deletion: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            continue;
                        }
                        if (GTUtility.areFluidsEqual(Materials.Iridium.getMolten(1L), recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicIridiumSolution.getFluidOrGas(1000);
                            recipe.reloadOwner();
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            continue;
                        }
                        if (GTUtility.areFluidsEqual(Materials.Platinum.getMolten(1L), recipe.mFluidOutputs[i])) {
                            recipe.mFluidOutputs[i] = WerkstoffLoader.PTConcentrate.getFluidOrGas(2000);
                            recipe.reloadOwner();
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            continue;
                        }
                        if (!GTUtility.areFluidsEqual(Materials.Osmium.getMolten(1L), recipe.mFluidOutputs[i])) continue;
                        recipe.mFluidOutputs[i] = WerkstoffLoader.AcidicOsmiumSolution.getFluidOrGas(1000);
                        recipe.reloadOwner();
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        continue;
                    }
                    if (!GTUtility.areFluidsEqual(WerkstoffLoader.Ruthenium.getMolten(1), recipe.mFluidOutputs[i]) && !GTUtility.areFluidsEqual(WerkstoffLoader.Rhodium.getMolten(1), recipe.mFluidOutputs[i]) && !GTUtility.areFluidsEqual(Materials.Iridium.getMolten(1L), recipe.mFluidOutputs[i]) && !GTUtility.areFluidsEqual(Materials.Platinum.getMolten(1L), recipe.mFluidOutputs[i]) && !GTUtility.areFluidsEqual(Materials.Osmium.getMolten(1L), recipe.mFluidOutputs[i])) continue;
                    GTLog.err.println("Recipe marked for deletion: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                    toDel.add(recipe);
                }
                for (i = 0; i < recipe.mOutputs.length; ++i) {
                    if (!GTUtility.isStackValid(recipe.mOutputs[i])) continue;
                    if ((BWUtil.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BWUtil.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BWUtil.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BWUtil.areStacksEqualOrNull(WerkstoffLoader.Ruthenium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                        }
                        int amount = recipe.mOutputs[i].field_77994_a * 2;
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.mOutputs[i] = WerkstoffLoader.LeachResidue.get(OrePrefixes.dust, amount);
                        recipe.reloadOwner();
                    }
                    if ((BWUtil.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dust), recipe.mOutputs[i]) || BWUtil.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustImpure), recipe.mOutputs[i]) || BWUtil.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.dustPure), recipe.mOutputs[i])) && !BWUtil.areStacksEqualOrNull(WerkstoffLoader.Rhodium.get(OrePrefixes.ingot), recipe.mInputs[0])) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                        }
                        int amount = recipe.mOutputs[i].field_77994_a * 2;
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.mOutputs[i] = WerkstoffLoader.CrudeRhMetall.get(OrePrefixes.dust, amount);
                        recipe.reloadOwner();
                    }
                    if (!BWUtil.checkStackAndPrefix(recipe.mOutputs[i])) continue;
                    if (GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Platinum)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                        }
                        if (OrePrefixes.dust.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust), amount * 2);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustSmall), amount * 2);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        int amount = recipe.mOutputs[i].field_77994_a;
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dustTiny), amount * 2);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Palladium)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                        }
                        if (OrePrefixes.dust.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust), amount * 4);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustSmall), amount * 4);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        int amount = recipe.mOutputs[i].field_77994_a;
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dustTiny), amount * 4);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Osmium)) {
                        for (ItemStack mInput : recipe.mInputs) {
                            if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                        }
                        if (OrePrefixes.dust.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust), amount);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (OrePrefixes.dustSmall.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                            int amount = recipe.mOutputs[i].field_77994_a;
                            GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                            recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustSmall), amount);
                            recipe.reloadOwner();
                            continue;
                        }
                        if (!OrePrefixes.dustTiny.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dustTiny), amount);
                        recipe.reloadOwner();
                        continue;
                    }
                    if (!GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mMaterial.mMaterial.equals(Materials.Iridium)) continue;
                    for (ItemStack mInput : recipe.mInputs) {
                        if (PlatinumSludgeOverHaul.isInBlackList(mInput, ITEMLIST_VALUES)) continue block3;
                    }
                    if (OrePrefixes.dust.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustImpure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix) || OrePrefixes.dustPure.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust), amount);
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.reloadOwner();
                        continue;
                    }
                    if (OrePrefixes.dustSmall.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) {
                        int amount = recipe.mOutputs[i].field_77994_a;
                        recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustSmall), amount);
                        GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                        recipe.reloadOwner();
                        continue;
                    }
                    if (!OrePrefixes.dustTiny.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)recipe.mOutputs[i]).mPrefix)) continue;
                    int amount = recipe.mOutputs[i].field_77994_a;
                    recipe.mOutputs[i] = BWUtil.setStackSize(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dustTiny), amount);
                    GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                    recipe.reloadOwner();
                }
            }
            ((RecipeMapBackend)recipeMap.getBackend()).removeRecipes(toDel);
        }
        PlatinumSludgeOverHaul.replaceHVCircuitMaterials();
        PlatinumSludgeOverHaul.runHelperrecipes();
    }

    private static void replaceHVCircuitMaterials() {
        GTValues.RA.stdBuilder().itemInputs(Materials.Redstone.getDust(1), Materials.Electrum.getDust(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(Materials.Electrotine.getDust(8)).duration(1800).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.mixerRecipes);
        GTLog.err.println("Processing hv circuit materials (circuit assembler map)");
        for (GTRecipe recipe : RecipeMaps.circuitAssemblerRecipes.getAllRecipes()) {
            if (recipe.mEUt > 512 || !BWUtil.checkStackAndPrefix(recipe.mOutputs[0])) continue;
            for (int i = 0; i < recipe.mInputs.length; ++i) {
                ItemStack stack = recipe.mInputs[i];
                ItemData ass = GTOreDictUnificator.getAssociation(stack);
                if (!BWUtil.checkStackAndPrefix(stack) || !ass.mMaterial.mMaterial.equals(Materials.Platinum)) continue;
                recipe.mInputs[i] = GTOreDictUnificator.get(ass.mPrefix, Materials.BlueAlloy, (long)stack.field_77994_a);
                GTLog.err.println("Recipe edited: " + PlatinumSludgeOverHaul.displayRecipe(recipe));
                recipe.reloadOwner();
            }
        }
    }

    private static void setnewMaterialInRecipe(IRecipe recipe) {
        ItemStack otpt = recipe.func_77571_b();
        if (!(recipe instanceof IRecipeMutableAccess)) {
            return;
        }
        IRecipeMutableAccess mutableRecipe = (IRecipeMutableAccess)recipe;
        Object input = mutableRecipe.gt5u$getRecipeInputs();
        if (input == null) {
            return;
        }
        if (GTUtility.areStacksEqual(otpt, Materials.Platinum.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Platinum)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(WerkstoffLoader.PTMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
        } else if (GTUtility.areStacksEqual(otpt, Materials.Palladium.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Palladium)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(WerkstoffLoader.PDMetallicPowder.get(OrePrefixes.dust, otpt.field_77994_a * 2));
        } else if (GTUtility.areStacksEqual(otpt, Materials.Iridium.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Iridium)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(WerkstoffLoader.IrLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
        } else if (GTUtility.areStacksEqual(otpt, Materials.Osmium.getDust(1), true)) {
            if (PlatinumSludgeOverHaul.checkRecipe(input, Materials.Osmium)) {
                return;
            }
            mutableRecipe.gt5u$setRecipeOutputItem(WerkstoffLoader.IrOsLeachResidue.get(OrePrefixes.dust, otpt.field_77994_a));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkRecipe(Object input, Materials mat) {
        if (input instanceof List || input instanceof Object[]) {
            void var8_13;
            HashSet<Object> lists = new HashSet<Object>();
            HashSet<Object> stacks = new HashSet<Object>();
            List ip = input instanceof List ? (List)input : new ArrayList();
            Object[] ip2 = input instanceof Object[] ? (Object[])input : GTValues.emptyObjectArray;
            for (Object e : ip) {
                if (e instanceof List) {
                    lists.add(e);
                    continue;
                }
                if (!(e instanceof ItemStack)) continue;
                stacks.add(e);
            }
            Object[] objectArray = ip2;
            int n = objectArray.length;
            boolean bl = false;
            while (var8_13 < n) {
                Object o = objectArray[var8_13];
                if (o instanceof List) {
                    lists.add(o);
                } else if (o instanceof ItemStack) {
                    stacks.add(o);
                }
                ++var8_13;
            }
            for (Object e : lists) {
                if (((List)e).isEmpty()) continue;
                stacks.add(((List)e).get(0));
            }
            boolean allSame = false;
            for (Object e : stacks) {
                if (!(e instanceof ItemStack)) {
                    allSame = false;
                    break;
                }
                allSame = BWUtil.checkStackAndPrefix((ItemStack)e) && GTOreDictUnificator.getAssociation((ItemStack)((ItemStack)e)).mMaterial.mMaterial.equals(mat);
                if (allSame) continue;
                break;
            }
            return allSame;
        }
        return false;
    }

    private static boolean isInBlackList(ItemStack stack, List<ItemStack> ITEMLIST_VALUES) {
        if (stack == null || stack.func_77973_b() instanceof BWMetaGeneratedItems || "bartworks".equals(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId) || "bartworkscrossmod".equals(GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId)) {
            return true;
        }
        if (GameRegistry.findUniqueIdentifierFor((Item)stack.func_77973_b()).modId.equals(Mods.NewHorizonsCoreMod.ID) && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
            return true;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof GTGenericBlock && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockOresAbstract)) {
            return true;
        }
        for (ItemStack itemStack : ITEMLIST_VALUES) {
            if (BWUtil.checkStackAndPrefix(stack) || !GTUtility.areStacksEqual(itemStack, stack, true)) continue;
            return true;
        }
        if (stack.func_77973_b() instanceof GTGenericItem) {
            if (!BWUtil.checkStackAndPrefix(stack)) {
                return false;
            }
            if (GTOreDictUnificator.getAssociation((ItemStack)stack).mPrefix != OrePrefixes.rawOre) {
                return !Arrays.asList(OPBLACKLIST).contains((Object)GTOreDictUnificator.getAssociation((ItemStack)stack).mPrefix) || Arrays.asList(BLACKLIST).contains(GTOreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
            }
        }
        if (stack.func_77973_b() instanceof BaseItemComponent && !stack.func_77977_a().contains("dust") && !stack.func_77977_a().contains("Dust")) {
            return true;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockBaseModular) {
            return true;
        }
        if (stack.func_77973_b() == MaterialsAlloy.HELICOPTER.getDust(1).func_77973_b()) {
            return true;
        }
        if (stack.func_77973_b() == MaterialsElements.STANDALONE.WHITE_METAL.getDust(1).func_77973_b()) {
            return true;
        }
        if (Mods.GalaxySpace.isModLoaded() && stack.func_77973_b() == GTModHandler.getModItem(Mods.GalaxySpace.ID, "metalsblock", 1L, 7).func_77973_b()) {
            return true;
        }
        if (Mods.NewHorizonsCoreMod.isModLoaded() && stack.func_77973_b() == GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IndustryFrame", 1L).func_77973_b()) {
            return true;
        }
        if (!BWUtil.checkStackAndPrefix(stack)) {
            return false;
        }
        return Arrays.asList(BLACKLIST).contains(GTOreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial);
    }
}

