/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.misc;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.TileEntityOres;
import gregtech.common.misc.IDrillingLogicDelegateOwner;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class DrillingLogicDelegate {
    public static final ItemStack MINING_PIPE_STACK = GTModHandler.getIC2Item("miningPipe", 0L);
    public static final Block MINING_PIPE_BLOCK = GTUtility.getBlockFromStack(MINING_PIPE_STACK);
    public static final Block MINING_PIPE_TIP_BLOCK = GTUtility.getBlockFromStack(GTModHandler.getIC2Item("miningPipeTip", 0L));
    private final IDrillingLogicDelegateOwner owner;
    private boolean isRetractDone;
    private boolean isWaitingForPipeItem;
    private int tipDepth;
    private FakePlayer mFakePlayer;

    public DrillingLogicDelegate(IDrillingLogicDelegateOwner owner) {
        this.owner = owner;
    }

    public boolean descent(IGregTechTileEntity te) {
        boolean pipeTaken;
        if (!te.isAllowedToWork()) {
            return false;
        }
        int xCoord = te.getXCoord();
        int zCoord = te.getZCoord();
        short yCoord = te.getYCoord();
        int checkY = yCoord + this.tipDepth - 1;
        boolean isHitsTheVoid = checkY < 0;
        boolean isHitsBedrock = GTUtility.getBlockHardnessAt(te.getWorld(), xCoord, checkY, zCoord) < 0.0f;
        boolean isFakePlayerAllowed = this.canFakePlayerInteract(te, xCoord, checkY, zCoord);
        if (isHitsTheVoid || isHitsBedrock || !isFakePlayerAllowed) {
            te.disableWorking();
            if (GTValues.debugBlockMiner) {
                if (isHitsTheVoid) {
                    GTLog.out.println("MINER: Hit bottom");
                }
                if (isHitsBedrock) {
                    GTLog.out.println("MINER: Hit block with -1 hardness");
                }
                if (!isFakePlayerAllowed) {
                    GTLog.out.println("MINER: Unable to set mining pipe tip");
                }
            }
            return false;
        }
        if (te.getBlockOffset(0, this.tipDepth, 0) == MINING_PIPE_TIP_BLOCK) {
            te.getWorld().func_147449_b(xCoord, yCoord + this.tipDepth, zCoord, MINING_PIPE_BLOCK);
        }
        if (!(pipeTaken = this.owner.pullInputs(MINING_PIPE_STACK.func_77973_b(), 1, false))) {
            this.isWaitingForPipeItem = true;
            return false;
        }
        Block block = te.getBlockOffset(0, this.tipDepth - 1, 0);
        if (!block.isAir((IBlockAccess)te.getWorld(), xCoord, (int)yCoord, zCoord)) {
            this.mineBlock(te, block, xCoord, yCoord + this.tipDepth - 1, zCoord);
        }
        te.getWorld().func_147449_b(xCoord, yCoord + this.tipDepth - 1, zCoord, MINING_PIPE_TIP_BLOCK);
        --this.tipDepth;
        return true;
    }

    public void onOwnerPostTick(IGregTechTileEntity te, long tick) {
        if (!te.isAllowedToWork()) {
            this.onPostTickRetract(te, tick);
            return;
        }
        this.isRetractDone = false;
    }

    private void onPostTickRetract(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.isRetractDone) {
            return;
        }
        if (this.tipDepth == 0) {
            this.isRetractDone = true;
            return;
        }
        if (aTick % (long)(this.owner.getMachineSpeed() / 5) != 0L) {
            return;
        }
        boolean canPush = this.owner.pushOutputs(MINING_PIPE_STACK, 1, true, true);
        if (!canPush) {
            return;
        }
        if (!this.isMiningPipe(aBaseMetaTileEntity, this.tipDepth)) {
            return;
        }
        if (this.isMiningPipe(aBaseMetaTileEntity, this.tipDepth + 1) || this.isLastPipeSegment()) {
            this.owner.pushOutputs(MINING_PIPE_STACK, 1, false, true);
        }
        int xCoord = aBaseMetaTileEntity.getXCoord();
        short yCoord = aBaseMetaTileEntity.getYCoord();
        int zCoord = aBaseMetaTileEntity.getZCoord();
        int actualDrillY = yCoord + this.tipDepth;
        if (actualDrillY < yCoord - 1) {
            this.owner.getBaseMetaTileEntity().getWorld().func_147449_b(xCoord, actualDrillY + 1, zCoord, MINING_PIPE_TIP_BLOCK);
        }
        aBaseMetaTileEntity.getWorld().func_147465_d(xCoord, actualDrillY, zCoord, Blocks.field_150350_a, 0, 2);
        ++this.tipDepth;
    }

    private boolean isLastPipeSegment() {
        return this.tipDepth == -1;
    }

    private boolean isMiningPipe(@NotNull IGregTechTileEntity aBaseMetaTileEntity, int yOffset) {
        Block pipeToRemove = aBaseMetaTileEntity.getBlockOffset(0, yOffset, 0);
        return pipeToRemove == MINING_PIPE_BLOCK || pipeToRemove == MINING_PIPE_TIP_BLOCK;
    }

    public void mineBlock(IGregTechTileEntity te, Block block, int x, int y, int z) {
        if (!GTUtility.eraseBlockByFakePlayer(this.getFakePlayer(te), x, y, z, true)) {
            return;
        }
        List<ItemStack> drops = this.getBlockDrops(block, x, y, z);
        boolean canFitDrops = true;
        for (ItemStack drop : drops) {
            canFitDrops &= this.owner.pushOutputs(drop, drop.field_77994_a, true, false);
        }
        if (!canFitDrops) {
            return;
        }
        for (ItemStack drop : drops) {
            this.owner.pushOutputs(drop, drop.field_77994_a, false, false);
        }
        short metaData = 0;
        TileEntity tTileEntity = this.owner.getBaseMetaTileEntity().getTileEntity(x, y, z);
        if (tTileEntity instanceof TileEntityOres) {
            metaData = ((TileEntityOres)tTileEntity).mMetaData;
        }
        ItemStack cobble = GTUtility.getCobbleForOre(block, metaData);
        te.getWorld().func_147465_d(x, y, z, Block.func_149634_a((Item)cobble.func_77973_b()), cobble.func_77960_j(), 3);
    }

    public int getTipDepth() {
        return this.tipDepth;
    }

    public void findTipDepth() {
        IGregTechTileEntity ownerTe = this.owner.getBaseMetaTileEntity();
        if (!ownerTe.isServerSide()) {
            return;
        }
        Block block;
        while ((block = ownerTe.getBlockOffset(0, this.tipDepth - 1, 0)) == MINING_PIPE_BLOCK || block == MINING_PIPE_TIP_BLOCK) {
            --this.tipDepth;
        }
        return;
    }

    public FakePlayer getFakePlayer(IGregTechTileEntity te) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GTUtility.getFakePlayer(te);
        }
        if (this.mFakePlayer != null) {
            this.mFakePlayer.func_70029_a(te.getWorld());
            this.mFakePlayer.func_70107_b((double)te.getXCoord(), (double)te.getYCoord(), (double)te.getZCoord());
        }
        return this.mFakePlayer;
    }

    public boolean canFakePlayerInteract(IGregTechTileEntity te, int xCoord, int yCoord, int zCoord) {
        return GTUtility.setBlockByFakePlayer(this.getFakePlayer(te), xCoord, yCoord, zCoord, MINING_PIPE_TIP_BLOCK, 0, true);
    }

    private List<ItemStack> getBlockDrops(Block oreBlock, int posX, int posY, int posZ) {
        return oreBlock.getDrops(this.owner.getBaseMetaTileEntity().getWorld(), posX, posY, posZ, this.owner.getBaseMetaTileEntity().getMetaID(posX, posY, posZ), this.owner.getMachineTier());
    }

    public boolean canContinueDrilling(long tick) {
        if (this.isWaitingForPipeItem) {
            if (tick % 5L != 0L) {
                return false;
            }
            boolean hasPipe = this.owner.pullInputs(MINING_PIPE_STACK.func_77973_b(), 1, true);
            if (hasPipe) {
                this.isWaitingForPipeItem = false;
            }
            return hasPipe;
        }
        return true;
    }
}

