/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.render.ISBRInventoryContext;
import gregtech.common.render.SBRContextBase;
import java.util.function.IntPredicate;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public final class SBRInventoryContext
extends SBRContextBase
implements ISBRInventoryContext {
    private static final float[] LIGHTNESS = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    private int meta;

    public ISBRInventoryContext setup(@NotNull Block block, int meta, int modelId, @NotNull RenderBlocks renderer) {
        super.setup(block, modelId, renderer);
        this.meta = meta;
        this.reset();
        return this;
    }

    @Override
    public ISBRInventoryContext reset() {
        this.hasBrightnessOverride = false;
        this.hasColorOverride = false;
        this.setLightnessOverride(1.0f);
        return this;
    }

    @Override
    public ISBRInventoryContext setupColor(ForgeDirection side, int hexColor) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float lightness = this.hasLightnessOverride ? this.lightnessOverride : LIGHTNESS[side.ordinal()];
        int color = this.hasColorOverride ? this.colorOverride : hexColor;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        if (this.hasBrightnessOverride) {
            tessellator.func_78380_c(this.brightnessOverride);
        }
        tessellator.func_78386_a(red * lightness, green * lightness, blue * lightness);
        return this;
    }

    @Override
    public boolean canRenderInPass(@NotNull IntPredicate predicate) {
        return true;
    }

    @Override
    public int getMeta() {
        return this.meta;
    }
}

