/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.jetbrains.annotations.NotNull;

public class MTEIntegratedOreFactory
extends MTEExtendedPowerMultiBlockBase<MTEIntegratedOreFactory>
implements ISurvivalConstructable {
    private static final int CASING_INDEX1 = 183;
    private static final int CASING_INDEX2 = 49;
    private static final int MAX_PARA = 1024;
    private static final long RECIPE_EUT = 30L;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEIntegratedOreFactory> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"           ", "           ", "       WWW ", "       WWW ", "           ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"           ", "       sss ", "      s   s", "      s   s", "       sss ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"           ", "       sss ", "      s   s", "      s   s", "       sss ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"iiiiii     ", "iIIIIiisssi", "iIIIIis   s", "iIIIIis   s", "iIIIIiisssi", "iiiiii     "}, {"iggggi     ", "gt  t isssi", "g xx  sppps", "g xx  sppps", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t isssi", "g xx  s   s", "g xx  s   s", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t is~si", "g xx  spppO", "g xx  spppO", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t isssi", "g xx  s   O", "g xx  s   O", "gt  t isssi", "iggggi     "}, {"EEEEEE     ", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEE     "}})).addElement('i', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)7)).addElement('s', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)).addElement('g', GTStructureUtility.chainAllGlasses()).addElement('x', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)3)).addElement('p', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('t', GTStructureUtility.ofFrame(Materials.TungstenSteel)).addElement('E', GTStructureUtility.buildHatchAdder(MTEIntegratedOreFactory.class).atLeast(HatchElement.Energy, HatchElement.Maintenance).casingIndex(183).dot(1).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('I', GTStructureUtility.buildHatchAdder(MTEIntegratedOreFactory.class).atLeast(HatchElement.InputBus).casingIndex(183).dot(2).buildAndChain(GregTechAPI.sBlockCasings8, 7)).addElement('W', GTStructureUtility.buildHatchAdder(MTEIntegratedOreFactory.class).atLeast(HatchElement.InputHatch, HatchElement.Muffler).casingIndex(49).dot(3).buildAndChain(GregTechAPI.sBlockCasings4, 1)).addElement('O', GTStructureUtility.buildHatchAdder(MTEIntegratedOreFactory.class).atLeast(HatchElement.OutputBus, HatchElement.OutputHatch).casingIndex(49).dot(4).buildAndChain(GregTechAPI.sBlockCasings4, 1)).build();
    private static final IntOpenHashSet isCrushedOre = new IntOpenHashSet();
    private static final IntOpenHashSet isCrushedPureOre = new IntOpenHashSet();
    private static final IntOpenHashSet isPureDust = new IntOpenHashSet();
    private static final IntOpenHashSet isImpureDust = new IntOpenHashSet();
    private static final IntOpenHashSet isThermal = new IntOpenHashSet();
    private static final IntOpenHashSet isOre = new IntOpenHashSet();
    private static boolean isInit = false;
    private ItemStack[] sMidProduct;
    private int sMode = 0;
    private boolean sVoidStone = false;
    private int currentParallelism = 0;

    private static void initHash() {
        for (String name : OreDictionary.getOreNames()) {
            int i;
            int size;
            ArrayList ores;
            if (name == null || name.isEmpty()) continue;
            if (name.startsWith("crushedPurified")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isCrushedPureOre.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (name.startsWith("crushedCentrifuged")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isThermal.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (name.startsWith("crushed")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isCrushedOre.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (name.startsWith("dustImpure")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isImpureDust.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (name.startsWith("dustPure")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isPureDust.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (name.startsWith("ore")) {
                ores = OreDictionary.getOres((String)name);
                size = ores.size();
                for (i = 0; i < size; ++i) {
                    isOre.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
                }
                continue;
            }
            if (!name.startsWith("rawOre")) continue;
            ores = OreDictionary.getOres((String)name);
            size = ores.size();
            for (i = 0; i < size; ++i) {
                isOre.add(GTUtility.stackToInt((ItemStack)ores.get(i)));
            }
        }
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    public MTEIntegratedOreFactory(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIntegratedOreFactory(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEIntegratedOreFactory> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Ore Processor, IOF").addInfo("Does all ore processing in one step").addStaticParallelInfo(1024).addInfo("Every ore costs 30EU/t, 2L lubricant, 200L distilled water").addInfo("Processing time is dependent on mode").addInfo("Use a screwdriver to switch mode").addInfo("Sneak click with screwdriver to void the stone dust").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().addInfo(EnumChatFormatting.GREEN + "OP stands for Ore Processor ;)").beginStructureBlock(6, 12, 11, false).addController("The third layer").addCasingInfoExactly("Advanced Iridium Plated Machine Casing", 128, false).addCasingInfoExactly("Clean Stainless Steel Machine Casing", 105, false).addCasingInfoExactly("Reinforced Glass", 48, false).addCasingInfoExactly("Tungstensteel Pipe Casing", 30, false).addCasingInfoExactly("Tungstensteel Frame Box", 16, false).addCasingInfoExactly("Steel Gear Box Casing", 16, false).addEnergyHatch("Any bottom Casing", 1).addMaintenanceHatch("Any bottom Casing", 1).addInputBus("Input ore/crushed ore", 2).addInputHatch("Input lubricant/distilled water/washing chemicals", 3).addMufflerHatch("Output Pollution", 3).addOutputBus("Output products", 4).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 8, 9, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 8, 9, 1, elementBudget, env, false, true);
    }

    private static int getTime(int mode) {
        int n;
        switch (mode) {
            case 0: {
                n = 600;
                break;
            }
            case 1: {
                n = 300;
                break;
            }
            case 2: {
                n = 200;
                break;
            }
            case 3: {
                n = 400;
                break;
            }
            case 4: {
                n = 340;
                break;
            }
            case 5: {
                n = 640;
                break;
            }
            default: {
                n = 1000000000;
            }
        }
        return n;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        int maxParallel;
        if (!isInit) {
            MTEIntegratedOreFactory.initHash();
            isInit = true;
        }
        ArrayList<ItemStack> tInput = this.getStoredInputs();
        ArrayList<FluidStack> tInputFluid = this.getStoredFluids();
        if (tInput.isEmpty() || tInputFluid.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long availableEUt = GTUtility.roundUpVoltage(this.getMaxInputVoltage());
        if (availableEUt < 30L) {
            return CheckRecipeResultRegistry.insufficientPower(30L);
        }
        int originalMaxParallel = maxParallel = 1024;
        OverclockCalculator calculator = new OverclockCalculator().setEUt(availableEUt).setRecipeEUt(30L).setDuration(MTEIntegratedOreFactory.getTime(this.sMode)).setParallel(originalMaxParallel);
        int maxParallelBeforeBatchMode = maxParallel = GTUtility.safeInt((long)((double)maxParallel * calculator.calculateMultiplierUnderOneTick()), 0);
        if (this.isBatchModeEnabled()) {
            maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
        }
        int currentParallel = (int)Math.min((long)maxParallel, availableEUt / 30L);
        int tLube = 0;
        int tWater = 0;
        int size = tInputFluid.size();
        for (int i = 0; i < size; ++i) {
            FluidStack fluid = tInputFluid.get(i);
            if (fluid != null && fluid.equals((Object)GTModHandler.getDistilledWater(1L))) {
                tWater += fluid.amount;
                continue;
            }
            if (fluid == null || !fluid.equals((Object)Materials.Lubricant.getFluid(1L))) continue;
            tLube += fluid.amount;
        }
        currentParallel = Math.min(currentParallel, tLube / 2);
        if ((currentParallel = Math.min(currentParallel, tWater / 200)) <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int itemParallel = 0;
        int size2 = tInput.size();
        for (int i = 0; i < size2; ++i) {
            ItemStack ore = tInput.get(i);
            int tID = GTUtility.stackToInt(ore);
            if (tID == 0 || !isPureDust.contains(tID) && !isImpureDust.contains(tID) && !isCrushedPureOre.contains(tID) && !isThermal.contains(tID) && !isCrushedOre.contains(tID) && !isOre.contains(tID)) continue;
            if (itemParallel + ore.field_77994_a <= currentParallel) {
                itemParallel += ore.field_77994_a;
                continue;
            }
            itemParallel = currentParallel;
            break;
        }
        if ((currentParallel = itemParallel) <= 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
        calculator.setCurrentParallel(currentParallelBeforeBatchMode).calculate();
        double batchMultiplierMax = 1.0;
        if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
            batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
            batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
        }
        int finalParallel = (int)(batchMultiplierMax * (double)currentParallelBeforeBatchMode);
        this.setCurrentParallelism(finalParallel);
        this.depleteInput(GTModHandler.getDistilledWater((long)finalParallel * 200L));
        this.depleteInput(Materials.Lubricant.getFluid((long)finalParallel * 2L));
        ArrayList<ItemStack> tOres = new ArrayList<ItemStack>();
        int remainingCost = finalParallel;
        int size3 = tInput.size();
        for (int i = 0; i < size3; ++i) {
            ItemStack ore = tInput.get(i);
            int tID = GTUtility.stackToInt(ore);
            if (tID == 0 || !isPureDust.contains(tID) && !isImpureDust.contains(tID) && !isCrushedPureOre.contains(tID) && !isThermal.contains(tID) && !isCrushedOre.contains(tID) && !isOre.contains(tID)) continue;
            if (remainingCost >= ore.field_77994_a) {
                tOres.add(GTUtility.copy(ore));
                remainingCost -= ore.field_77994_a;
                ore.field_77994_a = 0;
                continue;
            }
            tOres.add(GTUtility.copyAmountUnsafe(remainingCost, ore));
            ore.field_77994_a -= remainingCost;
            break;
        }
        this.sMidProduct = tOres.toArray(new ItemStack[0]);
        switch (this.sMode) {
            case 0: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doThermal(isCrushedPureOre, isCrushedOre);
                this.doMac(isThermal, isOre, isCrushedOre, isCrushedPureOre);
                break;
            }
            case 1: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doMac(isOre, isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            case 2: {
                this.doMac(isOre);
                this.doMac(isThermal, isOre, isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            case 3: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doSift(isCrushedPureOre);
                break;
            }
            case 4: {
                this.doMac(isOre);
                this.doChemWash(isCrushedOre, isCrushedPureOre);
                this.doMac(isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            case 5: {
                this.doMac(isOre);
                this.doChemWash(isCrushedOre, isCrushedPureOre);
                this.doThermal(isCrushedPureOre, isCrushedOre);
                this.doMac(isThermal, isOre, isCrushedOre, isCrushedPureOre);
                break;
            }
            default: {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mOutputItems = this.sMidProduct;
        this.mMaxProgresstime = (int)((double)calculator.getDuration() * batchMultiplierMax);
        this.lEUt = calculator.getConsumption();
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private boolean checkTypes(int aID, IntOpenHashSet ... aTables) {
        for (IntOpenHashSet set : aTables) {
            if (!set.contains(aID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            this.sVoidStone = !this.sVoidStone;
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{this.sVoidStone}));
            return;
        }
        this.sMode = (this.sMode + 1) % 6;
        List<String> des = MTEIntegratedOreFactory.getDisplayMode(this.sMode);
        GTUtility.sendChatToPlayer(aPlayer, String.join((CharSequence)"", des));
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.sMode = aNBT.func_74762_e("ssMode");
        this.sVoidStone = aNBT.func_74767_n("ssStone");
        this.currentParallelism = aNBT.func_74762_e("currentParallelism");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("ssMode", this.sMode);
        aNBT.func_74757_a("ssStone", this.sVoidStone);
        aNBT.func_74768_a("currentParallelism", this.currentParallelism);
        super.saveNBTData(aNBT);
    }

    private void doMac(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.maceratorRecipes.findRecipeQuery().caching(false).items(aStack).find();
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private void doWash(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.oreWasherRecipes.findRecipeQuery().caching(false).items(aStack).fluids(GTModHandler.getDistilledWater(Integer.MAX_VALUE)).find();
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private void doThermal(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.thermalCentrifugeRecipes.findRecipeQuery().caching(false).items(aStack).find();
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private void doCentrifuge(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.centrifugeRecipes.findRecipeQuery().items(aStack).find();
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private void doSift(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.sifterRecipes.findRecipeQuery().items(aStack).find();
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private void doChemWash(IntOpenHashSet ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GTUtility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GTRecipe tRecipe = RecipeMaps.chemicalBathRecipes.findRecipeQuery().items(aStack).fluids(this.getStoredFluids().toArray(new FluidStack[0])).find();
                    if (tRecipe != null && tRecipe.getRepresentativeFluidInput(0) != null) {
                        FluidStack tInputFluid = tRecipe.getRepresentativeFluidInput(0).copy();
                        int tStored = this.getFluidAmount(tInputFluid);
                        int tWashed = Math.min(tStored / tInputFluid.amount, aStack.field_77994_a);
                        this.depleteInput(new FluidStack(tInputFluid.getFluid(), tWashed * tInputFluid.amount));
                        tProduct.addAll(this.getOutputStack(tRecipe, tWashed));
                        if (tWashed >= aStack.field_77994_a) continue;
                        tProduct.add(GTUtility.copyAmountUnsafe(aStack.field_77994_a - tWashed, aStack));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private int getFluidAmount(FluidStack aFluid) {
        int tAmt = 0;
        if (aFluid == null) {
            return 0;
        }
        for (FluidStack fluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(fluid)) continue;
            tAmt += fluid.amount;
        }
        return tAmt;
    }

    private List<ItemStack> getOutputStack(GTRecipe aRecipe, int aTime) {
        ArrayList<ItemStack> tOutput = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < aRecipe.mOutputs.length; ++i2) {
            if (aRecipe.getOutput(i2) == null) continue;
            int tChance = aRecipe.getOutputChance(i2);
            if (tChance == 10000) {
                tOutput.add(GTUtility.copyAmountUnsafe(aTime * aRecipe.getOutput((int)i2).field_77994_a, aRecipe.getOutput(i2)));
                continue;
            }
            double u = (double)aTime * ((double)tChance / 10000.0);
            double e = (double)aTime * ((double)tChance / 10000.0) * (1.0 - (double)tChance / 10000.0);
            Random random = new Random();
            int tAmount = (int)Math.ceil(Math.sqrt(e) * random.nextGaussian() + u);
            tOutput.add(GTUtility.copyAmountUnsafe(tAmount * aRecipe.getOutput((int)i2).field_77994_a, aRecipe.getOutput(i2)));
        }
        return tOutput.stream().filter(i -> i != null && i.field_77994_a > 0).collect(Collectors.toList());
    }

    private void doCompress(List<ItemStack> aList) {
        HashMap<Integer, Integer> rProduct = new HashMap<Integer, Integer>();
        for (ItemStack stack : aList) {
            int tID = GTUtility.stackToInt(stack);
            if (this.sVoidStone && GTUtility.areStacksEqual(Materials.Stone.getDust(1), stack) || tID == 0) continue;
            if (rProduct.containsKey(tID)) {
                rProduct.put(tID, (Integer)rProduct.get(tID) + stack.field_77994_a);
                continue;
            }
            rProduct.put(tID, stack.field_77994_a);
        }
        this.sMidProduct = new ItemStack[rProduct.size()];
        int cnt = 0;
        for (Integer id : rProduct.keySet()) {
            ItemStack stack = GTUtility.intToStack(id);
            this.sMidProduct[cnt] = GTUtility.copyAmountUnsafe((Integer)rProduct.get(id), stack);
            ++cnt;
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 8, 9, 1) && this.mMaintenanceHatches.size() <= 1 && !this.mMufflerHatches.isEmpty();
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 200;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIntegratedOreFactory(this.mName);
    }

    private void setCurrentParallelism(int parallelism) {
        this.currentParallelism = parallelism;
    }

    private int getCurrentParallelism() {
        return this.currentParallelism;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> informationData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        String parallelism = StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.BLUE + this.getCurrentParallelism() + EnumChatFormatting.RESET;
        informationData.add(parallelism);
        informationData.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{this.sVoidStone}));
        informationData.addAll(MTEIntegratedOreFactory.getDisplayMode(this.sMode));
        return informationData.toArray(new String[0]);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_FACTORY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_FACTORY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_FACTORY).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_FACTORY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    private static List<String> getDisplayMode(int mode) {
        EnumChatFormatting AQUA = EnumChatFormatting.AQUA;
        String CRUSH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Macerate", (Object[])new Object[0]);
        String WASH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Ore_Washer", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String THERMAL = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Thermal_Centrifuge", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String CENTRIFUGE = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Centrifuge", (Object[])new Object[0]);
        String SIFTER = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Sifter", (Object[])new Object[0]);
        String CHEM_WASH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Chemical_Bathing", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String ARROW = " " + AQUA + "-> ";
        ArrayList<String> des = new ArrayList<String>();
        des.add(StatCollector.func_74837_a((String)"GT5U.multiblock.runningMode", (Object[])new Object[0]) + " ");
        switch (mode) {
            case 0: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + THERMAL + ARROW);
                des.add(AQUA + CRUSH + ' ');
                break;
            }
            case 1: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CENTRIFUGE + ' ');
                break;
            }
            case 2: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CENTRIFUGE + ' ');
                break;
            }
            case 3: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + SIFTER + ' ');
                break;
            }
            case 4: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CHEM_WASH + ARROW);
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CENTRIFUGE + ' ');
                break;
            }
            case 5: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CHEM_WASH + ARROW);
                des.add(AQUA + THERMAL + ARROW);
                des.add(AQUA + CRUSH + ' ');
                break;
            }
            default: {
                des.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.WRONG_MODE", (Object[])new Object[0]));
            }
        }
        des.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor2", (Object[])new Object[]{MTEIntegratedOreFactory.getTime(mode) / 20}));
        return des;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("currentParallelism") + EnumChatFormatting.RESET);
        currenttip.addAll(MTEIntegratedOreFactory.getDisplayMode(tag.func_74762_e("ssMode")));
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{tag.func_74767_n("ssStone")}));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("ssMode", this.sMode);
        tag.func_74757_a("ssStone", this.sVoidStone);
        tag.func_74768_a("currentParallelism", this.currentParallelism);
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }
}

