/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.tooltip.TooltipTier;
import gregtech.common.blocks.BlockCasings10;
import gregtech.common.misc.GTStructureChannels;
import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class MTEMultiAutoclave
extends MTEExtendedPowerMultiBlockBase<MTEMultiAutoclave>
implements ISurvivalConstructable {
    private HeatingCoilLevel heatLevel;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    protected int itemPipeTier = 0;
    protected int fluidPipeTier = 0;
    private static final IStructureDefinition<MTEMultiAutoclave> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"  AAA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AFA  ", "  AAA  "}, {" ABBBA ", " AA AA ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " AA AA ", " ABBBA "}, {"ABBBBBA", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "ABBBBBA"}, {"ABBBBBA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ACDEDCA", "ABBBBBA"}, {"ABBBBBA", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "A C C A", "ABBBBBA"}, {"AABBBAA", " AA AA ", " A   A ", " A   A ", " A   A ", " A   A ", " A   A ", " AA AA ", "AABBBAA"}, {"A A~A A", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "  AAA  ", "A AAA A"}})).addElement('A', GTStructureUtility.buildHatchAdder(MTEMultiAutoclave.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy).casingIndex(((BlockCasings10)GregTechAPI.sBlockCasings10).getTextureIndex(3)).dot(1).buildAndChain(StructureUtility.onElementPass(MTEMultiAutoclave::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings10, (int)3)))).addElement('B', GTStructureUtility.chainAllGlasses()).addElement('C', GTStructureUtility.ofFrame(Materials.Polytetrafluoroethylene)).addElement('D', GTStructureChannels.PIPE_CASING.use(StructureUtility.ofBlocksTiered(MTEMultiAutoclave::getFluidTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)12), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)13), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)14), (Object)Pair.of((Object)GregTechAPI.sBlockCasings2, (Object)15)), (Object)-1, MTEMultiAutoclave::setFluidPipeTier, MTEMultiAutoclave::getFluidPipeTier))).addElement('E', GTStructureChannels.ITEM_PIPE_CASING.use(StructureUtility.ofBlocksTiered(MTEMultiAutoclave::getItemPipeTierFromMeta, (List)ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)1), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)3), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)4), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)5), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)6), (Object)Pair.of((Object)GregTechAPI.sBlockCasings11, (Object)7)), (Object)-1, MTEMultiAutoclave::setItemPipeTier, MTEMultiAutoclave::getItemPipeTier))).addElement('F', GTStructureChannels.HEATING_COIL.use(GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEMultiAutoclave::setCoilLevel, MTEMultiAutoclave::getCoilLevel)))).build();
    private int mCasingAmount;
    private static final DecimalFormat dfTwo = new DecimalFormat("0.00");
    private static final DecimalFormat dfNone = new DecimalFormat("#");

    public MTEMultiAutoclave(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEMultiAutoclave(String aName) {
        super(aName);
    }

    @Nullable
    private static Integer getItemPipeTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings11) {
            return null;
        }
        if (metaID < 0 || metaID > 7) {
            return null;
        }
        return metaID + 1;
    }

    private void setItemPipeTier(int tier) {
        this.itemPipeTier = tier;
    }

    private int getItemPipeTier() {
        return this.itemPipeTier;
    }

    @Nullable
    private static Integer getFluidTierFromMeta(Block block, Integer metaID) {
        if (block != GregTechAPI.sBlockCasings2) {
            return null;
        }
        if (metaID < 12 || metaID > 15) {
            return null;
        }
        return metaID - 11;
    }

    private void setFluidPipeTier(int tier) {
        this.fluidPipeTier = tier;
    }

    private int getFluidPipeTier() {
        return this.fluidPipeTier;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.heatLevel = aCoilLevel;
    }

    public int getCoilTier() {
        return this.heatLevel == null ? 0 : this.heatLevel.getTier() + 1;
    }

    @Override
    public IStructureDefinition<MTEMultiAutoclave> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Autoclave").addDynamicParallelInfo(12, TooltipTier.ITEM_PIPE_CASING).addDynamicSpeedInfo(0.25f, TooltipTier.COIL).addDynamicEuEffInfo(0.0833f, TooltipTier.PIPE_CASING).beginStructureBlock(7, 7, 9, true).addController("Front Center").addCasingInfoMin("Pressure Containment Casings", 128, false).addCasingInfoExactly("Any Tiered Glass", 42, false).addCasingInfoExactly("Item Pipe Casings", 7, true).addCasingInfoExactly("Pipe Casings", 14, true).addCasingInfoExactly("Heating Coils", 7, true).addCasingInfoExactly("PTFE Frame", 42, false).addInputBus("Any Pressure Containment Casing", 1).addOutputBus("Any Pressure Containment Casing", 1).addInputHatch("Any Pressure Containment Casing", 1).addOutputHatch("Any Pressure Containment Casing", 1).addEnergyHatch("Any Pressure Containment Casing", 1).addMaintenanceHatch("Any Pressure Containment Casing", 1).addSubChannelUsage(GTStructureChannels.BOROGLASS).addSubChannelUsage(GTStructureChannels.ITEM_PIPE_CASING).addSubChannelUsage(GTStructureChannels.PIPE_CASING).addSubChannelUsage(GTStructureChannels.HEATING_COIL).toolTipFinisher(GTValues.AuthorVolence);
        return tt;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.fluidPipeTier = -1;
        this.itemPipeTier = -1;
        this.mCasingAmount = 0;
        this.mEnergyHatches.clear();
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 6, 0)) {
            return false;
        }
        return this.mCasingAmount >= 128;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        ITexture[] rTexture = side == aFacing ? (aActive ? new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_ACTIVE_GLOW).extFacing().glow().build()} : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3)), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MULTI_AUTOCLAVE_GLOW).extFacing().glow().build()}) : new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings10, 3))};
        return rTexture;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 6, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 3, 6, 0, elementBudget, env, false, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_MULTI_AUTOCLAVE_LOOP;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMultiAutoclave(this.mName);
    }

    public float euModifier(int fluidPipeTier) {
        return (float)(12 - fluidPipeTier) / 12.0f;
    }

    public float speedBoost(int coilTier) {
        return 1.0f / (1.0f + 0.25f * (float)coilTier);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.itemPipeTier * 12;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            public CheckRecipeResult process() {
                this.euModifier = MTEMultiAutoclave.this.euModifier(MTEMultiAutoclave.this.fluidPipeTier);
                this.speedBoost = MTEMultiAutoclave.this.speedBoost(MTEMultiAutoclave.this.getCoilTier());
                return super.process();
            }
        }.setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("fluidPipeTier", this.getFluidPipeTier());
        tag.func_74768_a("itemPipeTier", this.getItemPipeTier());
        tag.func_74768_a("coilTier", this.getCoilTier());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.fluidPipeTier") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("fluidPipeTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.euModifier") + ": " + EnumChatFormatting.WHITE + dfTwo.format(Math.max(0.0f, this.euModifier(tag.func_74762_e("fluidPipeTier")) * 100.0f)) + "%");
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.itemPipeTier") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("itemPipeTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.coilLevel") + ": " + EnumChatFormatting.WHITE + Math.max(0, tag.func_74762_e("coilTier")));
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.speed") + ": " + EnumChatFormatting.WHITE + dfNone.format(Math.max(0.0f, 100.0f / this.speedBoost(tag.func_74762_e("coilTier")))) + "%");
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.autoclaveRecipes;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

