/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.dusts;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.StringUtils;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class BaseItemDustUnique
extends Item {
    protected final int colour;
    protected final int sRadiation;
    protected final String typeLoc;
    protected final String materialName;
    protected final String chemicalNotation;

    public BaseItemDustUnique(String unlocalizedName, String materialName, int colour, String pileSize) {
        this(unlocalizedName, materialName, "NullFormula", colour, pileSize);
    }

    public BaseItemDustUnique(String unlocalizedName, String materialName, String mChemicalFormula, int colour, String pileSize) {
        this.func_77655_b(unlocalizedName);
        this.func_77625_d(64);
        this.func_111206_d(this.getCorrectTexture(pileSize));
        this.func_77637_a(AddToCreativeTab.tabMisc);
        this.colour = colour == 0 ? Dyes._NULL.toInt() : colour;
        this.materialName = materialName;
        this.chemicalNotation = mChemicalFormula == null || mChemicalFormula.isEmpty() || mChemicalFormula.equals("NullFormula") ? StringUtils.subscript(materialName) : StringUtils.subscript(mChemicalFormula);
        this.sRadiation = ItemUtils.getRadioactivityLevel(materialName);
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
        this.typeLoc = this.func_77658_a().contains("DustTiny") ? "gt.component.dusttiny" : (this.func_77658_a().contains("DustSmall") ? "gt.component.dustsmall" : "gt.component.dust");
        String temp = "";
        Logger.WARNING("Unlocalized name for OreDict nameGen: " + this.func_77658_a());
        if (this.func_77658_a().contains("item.")) {
            temp = this.func_77658_a().replace("item.", "");
            Logger.WARNING("Generating OreDict Name: " + temp);
        } else {
            temp = this.func_77658_a();
        }
        if (temp.contains("DustTiny")) {
            temp = temp.replace("itemD", "d");
            Logger.WARNING("Generating OreDict Name: " + temp);
        } else if (temp.contains("DustSmall")) {
            temp = temp.replace("itemD", "d");
            Logger.WARNING("Generating OreDict Name: " + temp);
        } else {
            temp = temp.replace("itemD", "d");
            Logger.WARNING("Generating OreDict Name: " + temp);
        }
        if (!temp.isEmpty()) {
            GTOreDictUnificator.registerOre(temp, new ItemStack((Item)this));
        }
        this.registerComponent();
    }

    public boolean registerComponent() {
        String aKey;
        ItemStack x;
        if (this.materialName == null) {
            return false;
        }
        String aName = this.materialName;
        Map<String, ItemStack> aMap = Material.mComponentMap.get(aName);
        if (aMap == null) {
            aMap = new HashMap<String, ItemStack>();
        }
        if ((x = aMap.get(aKey = OrePrefixes.dust.name())) == null) {
            aMap.put(aKey, new ItemStack((Item)this));
            Logger.MATERIALS("Registering a material component. Item: [" + aName + "] Map: [" + aKey + "]");
            Material.mComponentMap.put(aName, aMap);
            return true;
        }
        Logger.MATERIALS("Tried to double register a material component. ");
        return false;
    }

    public String func_77653_i(ItemStack iStack) {
        return StatCollector.func_74837_a((String)this.typeLoc, (Object[])new Object[]{StatCollector.func_74838_a((String)("gtpp.material." + this.materialName.replaceAll("[^a-zA-Z0-9]", "")))});
    }

    private String getCorrectTexture(String pileSize) {
        if (!Configuration.visual.useGregtechTextures) {
            if (pileSize.equals("dust") || pileSize.equals("Dust")) {
                this.func_111206_d(Mods.GTPlusPlus.ID + ":dust");
            } else {
                this.func_111206_d(Mods.GTPlusPlus.ID + ":dust" + pileSize);
            }
        }
        if (pileSize.toLowerCase().contains("small")) {
            return Mods.GregTech.ID + ":materialicons/SHINY/dustSmall";
        }
        if (pileSize.toLowerCase().contains("tiny")) {
            return Mods.GregTech.ID + ":materialicons/SHINY/dustTiny";
        }
        return Mods.GregTech.ID + ":materialicons/SHINY/dust";
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        if (this.sRadiation > 0) {
            list.add(GTPPCore.GT_Tooltip_Radioactive.get());
        }
        if (!this.chemicalNotation.isEmpty() && !this.chemicalNotation.equals("NullFormula")) {
            list.add(this.chemicalNotation);
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public final String getMaterialName() {
        return StringUtils.subscript(this.materialName);
    }

    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        return this.colour;
    }
}

