/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NBTUtils {
    public static NBTTagCompound getNBT(ItemStack aStack) {
        NBTTagCompound rNBT = aStack.func_77978_p();
        return rNBT == null ? new NBTTagCompound() : rNBT;
    }

    public static void setBookTitle(ItemStack aStack, String aTitle) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74778_a("title", aTitle);
        GTUtility.ItemNBT.setNBT(aStack, tNBT);
    }

    public static ItemStack[] readItemsFromNBT(ItemStack itemstack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = tNBT.func_150295_c("Items", 10);
        ItemStack[] inventory = new ItemStack[tNBT.func_74762_e("InventorySlots")];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
        return inventory;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            ItemStack stack = stored[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        tNBT.func_74782_a("Items", (NBTBase)list);
        tNBT.func_74768_a("InventorySlots", stored.length);
        itemstack.func_77982_d(tNBT);
        return itemstack;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored, String customkey) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            ItemStack stack = stored[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        tNBT.func_74782_a(customkey, (NBTBase)list);
        itemstack.func_77982_d(tNBT);
        return itemstack;
    }

    public static void setBoolean(ItemStack aStack, String aTag, boolean aBoolean) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74757_a(aTag, aBoolean);
        GTUtility.ItemNBT.setNBT(aStack, tNBT);
    }

    public static boolean getBoolean(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74767_n(aTag);
    }

    public static void setInteger(ItemStack aStack, String aTag, int aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74768_a(aTag, aInt);
        GTUtility.ItemNBT.setNBT(aStack, tNBT);
    }

    public static int getInteger(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74762_e(aTag);
    }

    public static void setLong(ItemStack aStack, String aTag, long aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74772_a(aTag, aInt);
        GTUtility.ItemNBT.setNBT(aStack, tNBT);
    }

    public static long getLong(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74763_f(aTag);
    }

    public static void setString(ItemStack aStack, String aTag, String aString) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.func_74778_a(aTag, aString);
        GTUtility.ItemNBT.setNBT(aStack, tNBT);
    }

    public static String getString(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.func_74779_i(aTag);
    }

    public static boolean hasKey(ItemStack stack, String key) {
        NBTTagCompound itemData = NBTUtils.getNBT(stack);
        return itemData.func_74764_b(key);
    }

    public static boolean createIntegerTagCompound(ItemStack rStack, String tagName, String keyName, int keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74768_a(keyName, keyValue);
        tagMain.func_74782_a(tagName, (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static NBTTagCompound getTagCompound(ItemStack aStack, String tagName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && NBTUtils.hasKey(aStack, tagName)) {
            aNBT = aNBT.func_74775_l(tagName);
            return aNBT;
        }
        return null;
    }

    public static boolean hasTagCompound(ItemStack aStack) {
        return aStack.func_77942_o();
    }

    public static void createEmptyTagCompound(ItemStack aStack) {
        if (!NBTUtils.hasTagCompound(aStack)) {
            NBTTagCompound aTag = new NBTTagCompound();
            aStack.func_77982_d(aTag);
        }
    }
}

