/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.MetaTileEntityIDs;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.StructureError;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.MTEHatchCustomFluidBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.thermalfoundation.fluid.TFFluids;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class MTEIndustrialVacuumFreezer
extends GTPPMultiBlockBase<MTEIndustrialVacuumFreezer>
implements ISurvivalConstructable {
    public static int CASING_TEXTURE_ID;
    public static String CASING_NAME;
    public static String HATCH_NAME;
    public static FluidStack CRYO_STACK;
    private static IStructureDefinition<MTEIndustrialVacuumFreezer> STRUCTURE_DEFINITION;
    private int mCasing;
    private final ArrayList<MTEHatchCustomFluidBase> mCryotheumHatches = new ArrayList();

    public MTEIndustrialVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 10);
        GregTechAPI.sAfterGTLoad.add(() -> {
            CRYO_STACK = new FluidStack(TFFluids.fluidCryotheum, 1);
            CASING_NAME = GregtechItemList.Casing_AdvancedVacuum.get(1L, new Object[0]).func_82833_r();
            HATCH_NAME = GregtechItemList.Hatch_Input_Cryotheum.get(1L, new Object[0]).func_82833_r();
        });
    }

    protected MTEIndustrialVacuumFreezer(MTEIndustrialVacuumFreezer prototype) {
        super(prototype.mName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialVacuumFreezer(this);
    }

    @Override
    public String getMachineType() {
        return "Vacuum Freezer";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Advanced Vacuum Freezer").addStaticParallelInfo(4).addStaticSpeedInfo(2.0f).addStaticEuEffInfo(1.0f).addInfo("Consumes 10L of " + CRYO_STACK.getLocalizedName() + "/s during operation").addInfo("Constructed exactly the same as a normal Vacuum Freezer").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfoMin(CASING_NAME, 10, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addOutputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addOtherStructurePart(HATCH_NAME, "Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialVacuumFreezer> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEIndustrialVacuumFreezer.class).adder(MTEIndustrialVacuumFreezer::addCryotheumHatch).hatchId(MetaTileEntityIDs.Hatch_Input_Cryotheum.ID).casingIndex(CASING_TEXTURE_ID).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEIndustrialVacuumFreezer.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(CASING_TEXTURE_ID).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)10))})).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        this.mCasing = 0;
        this.mCryotheumHatches.clear();
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(this.mName, 1, 1, 0);
    }

    @Override
    public void validateStructure(Collection<StructureError> errors, NBTTagCompound context) {
        super.validateStructure(errors, context);
        if (this.mCasing < 10) {
            errors.add(StructureError.TOO_FEW_CASINGS);
            context.func_74768_a("casings", this.mCasing);
        }
        if (this.mCryotheumHatches.isEmpty()) {
            errors.add(StructureError.MISSING_CRYO_HATCH);
        }
        if (this.mCryotheumHatches.size() > 1) {
            errors.add(StructureError.TOO_MANY_CRYO_HATCHES);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void localizeStructureErrors(Collection<StructureError> errors, NBTTagCompound context, List<String> lines) {
        super.localizeStructureErrors(errors, context, lines);
        if (errors.contains((Object)StructureError.TOO_FEW_CASINGS)) {
            lines.add(StatCollector.func_74837_a((String)"GT5U.gui.missing_casings", (Object[])new Object[]{10, context.func_74762_e("casings")}));
        }
        if (errors.contains((Object)StructureError.MISSING_CRYO_HATCH)) {
            lines.add(StatCollector.func_74837_a((String)"GT5U.gui.missing_hatch", (Object[])new Object[]{HATCH_NAME}));
        }
        if (errors.contains((Object)StructureError.TOO_MANY_CRYO_HATCHES)) {
            lines.add(StatCollector.func_74837_a((String)"GT5U.gui.too_many_hatches", (Object[])new Object[]{HATCH_NAME, 1}));
        }
    }

    private boolean addCryotheumHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchCustomFluidBase && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileID() == MetaTileEntityIDs.Hatch_Input_Cryotheum.ID) {
            return this.addToMachineListInternal(this.mCryotheumHatches, aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public void updateSlots() {
        for (MTEHatchCustomFluidBase tHatch : GTUtility.validMTEList(this.mCryotheumHatches)) {
            tHatch.updateSlots();
        }
        super.updateSlots();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezerActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezerActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezer;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialVacuumFreezerGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return CASING_TEXTURE_ID;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.advancedFreezerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic().noRecipeCaching().setSpeedBonus(0.5).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialVacuumFreezer;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mStartUpCheck < 0 && (this.mMaxProgresstime > 0 && this.mProgresstime != 0 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && (aTick % 20L == 0L || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && !this.depleteInputFromRestrictedHatches(this.mCryotheumHatches, 10)) {
            this.causeMaintenanceIssue();
            this.stopMachine(ShutDownReasonRegistry.outOfFluid(new FluidStack(TFFluids.fluidCryotheum, 10)));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_ADV_FREEZER_LOOP;
    }

    static {
        STRUCTURE_DEFINITION = null;
    }
}

