/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.chemistry.general.ItemGenericChemBase;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers.MTEHatchMillingBalls;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEIsaMill
extends GTPPMultiBlockBase<MTEIsaMill>
implements ISurvivalConstructable {
    protected boolean boostEu = false;
    private int mCasing;
    private static IStructureDefinition<MTEIsaMill> STRUCTURE_DEFINITION = null;
    private static final IIconContainer frontFaceActive = new TexturesGtBlock.CustomIcon("iconsets/Grinder/GRINDER_ACTIVE5");
    private static final IIconContainer frontFace = new TexturesGtBlock.CustomIcon("iconsets/Grinder/GRINDER5");
    private final ArrayList<MTEHatchMillingBalls> mMillingBallBuses = new ArrayList();
    private static final DamageSource mIsaMillDamageSource = new DamageSource("gtpp.grinder").func_76348_h();
    private final ArrayList<BlockPos> mFrontBlockPosCache = new ArrayList();

    public MTEIsaMill(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIsaMill(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo(EnumChatFormatting.GREEN + "G.O.G, Grinds Ores Good").addPerfectOCInfo().addPollutionAmount(this.getPollutionPerSecond(null)).addInfo(EnumChatFormatting.GREEN + "It'sa mill!").beginStructureBlock(3, 3, 7, false).addController("Front Center").addCasingInfoMin("IsaMill Exterior Casing", 40, false).addOtherStructurePart("IsaMill Gearbox", "5x, Inner Blocks").addOtherStructurePart("IsaMill Piping", "8x, ring around controller").addStructureInfo("IsaMill Pipings must not be obstructed in front (only air blocks)").addOtherStructurePart("Ball Housing", "Any Casing").addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIsaMill> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"DDD", "CCC", "CCC", "CCC", "CCC", "CCC", "CCC"}, {"D~D", "CGC", "CGC", "CGC", "CGC", "CGC", "CCC"}, {"DDD", "CCC", "CCC", "CCC", "CCC", "CCC", "CCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEIsaMill.class).adder(MTEIsaMill::addMillingBallsHatch).hatchClass(MTEHatchMillingBalls.class).shouldReject(t -> !t.mMillingBallBuses.isEmpty()).casingIndex(this.getCasingTextureIndex()).dot(1).build(), GTStructureUtility.buildHatchAdder(MTEIsaMill.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.InputHatch, HatchElement.OutputHatch, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(this.getCasingTextureIndex()).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta()))})).addElement('D', StructureUtility.ofBlock((Block)this.getIntakeBlock(), (int)this.getIntakeMeta())).addElement('G', StructureUtility.ofBlock((Block)this.getGearboxBlock(), (int)this.getGearboxMeta())).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mMillingBallBuses.clear();
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 40 && this.checkHatch();
    }

    @Override
    public boolean checkHatch() {
        return super.checkHatch() && this.mMillingBallBuses.size() == 1;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return frontFaceActive;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return frontFace;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.GTPP_INDEX(2);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    private boolean addMillingBallsHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchMillingBalls) {
            return this.addToMachineListInternal(this.mMillingBallBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchMillingBalls) {
            this.log("Found MTEHatchMillingBalls");
            return this.addToMachineListInternal(this.mMillingBallBuses, aMetaTileEntity, aBaseCasingIndex);
        }
        return super.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.millingRecipes;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mMillingBallBuses.clear();
        }
        if (aTick % 20L == 0L && this.isMachineRunning()) {
            this.checkForEntities(aBaseMetaTileEntity, aTick);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void checkForEntities(IGregTechTileEntity aBaseMetaTileEntity, long aTime) {
        ArrayList<EntityLivingBase> aEntities;
        if (aTime % 100L == 0L) {
            this.mFrontBlockPosCache.clear();
        }
        if (this.mFrontBlockPosCache.isEmpty()) {
            ForgeDirection tSide = aBaseMetaTileEntity.getBackFacing();
            int aTileX = aBaseMetaTileEntity.getXCoord();
            short aTileY = aBaseMetaTileEntity.getYCoord();
            int aTileZ = aBaseMetaTileEntity.getZCoord();
            boolean xFacing = tSide.offsetX != 0;
            boolean zFacing = tSide.offsetZ != 0;
            int aDepthOffset = tSide == ForgeDirection.NORTH || tSide == ForgeDirection.WEST ? 1 : -1;
            for (int aHorizontalOffset = -1; aHorizontalOffset < 2; ++aHorizontalOffset) {
                for (int aVerticalOffset = -1; aVerticalOffset < 2; ++aVerticalOffset) {
                    int aX = !xFacing ? aTileX + aHorizontalOffset : aTileX + aDepthOffset;
                    int aY = aTileY + aVerticalOffset;
                    int aZ = !zFacing ? aTileZ + aHorizontalOffset : aTileZ + aDepthOffset;
                    this.mFrontBlockPosCache.add(new BlockPos(aX, aY, aZ, aBaseMetaTileEntity.getWorld()));
                }
            }
        }
        if (!(aEntities = MTEIsaMill.getEntities(this.mFrontBlockPosCache, aBaseMetaTileEntity.getWorld())).isEmpty()) {
            for (EntityLivingBase aFoundEntity : aEntities) {
                if (aFoundEntity instanceof EntityPlayer) {
                    EntityPlayer aPlayer = (EntityPlayer)aFoundEntity;
                    if (aPlayer.field_71075_bZ.field_75098_d || aPlayer.field_71075_bZ.field_75102_a || !(aFoundEntity.func_110143_aJ() > 0.0f)) continue;
                    aFoundEntity.func_70097_a(mIsaMillDamageSource, (float)this.getPlayerDamageValue(aPlayer, 10));
                    if (!aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isActive()) continue;
                    MTEIsaMill.generateParticles(aFoundEntity);
                    continue;
                }
                if (!(aFoundEntity.func_110143_aJ() > 0.0f)) continue;
                aFoundEntity.func_70097_a(mIsaMillDamageSource, (float)Math.max(1, (int)(aFoundEntity.func_110138_aP() / 3.0f)));
                if (!aBaseMetaTileEntity.isClientSide() || !aBaseMetaTileEntity.isActive()) continue;
                MTEIsaMill.generateParticles(aFoundEntity);
            }
        }
    }

    private int getPlayerDamageValue(EntityPlayer player, int damage) {
        int armorValue = player.func_70658_aO();
        int reducedDamage = (int)((double)damage - (double)damage * ((double)armorValue * 0.04));
        return Math.max(reducedDamage, 0);
    }

    private static ArrayList<EntityLivingBase> getEntities(ArrayList<BlockPos> aPositionsToCheck, World aWorld) {
        ArrayList<EntityLivingBase> aEntities = new ArrayList<EntityLivingBase>();
        HashSet<Chunk> aChunksToCheck = new HashSet<Chunk>();
        if (!aPositionsToCheck.isEmpty()) {
            for (BlockPos aPos : aPositionsToCheck) {
                Chunk aLocalChunk = aWorld.func_72938_d(aPos.xPos, aPos.zPos);
                aChunksToCheck.add(aLocalChunk);
            }
        }
        if (!aChunksToCheck.isEmpty()) {
            ArrayList<EntityLivingBase> aEntitiesFound = new ArrayList<EntityLivingBase>();
            for (Chunk aChunk : aChunksToCheck) {
                if (!aChunk.field_76636_d) continue;
                List[] aEntityLists = aChunk.field_76645_j;
                for (List aEntitySubList : aEntityLists) {
                    Iterator iterator = aEntitySubList.iterator();
                    while (iterator.hasNext()) {
                        Object aEntity = iterator.next();
                        if (!(aEntity instanceof EntityLivingBase)) continue;
                        EntityLivingBase aPlayer = (EntityLivingBase)aEntity;
                        aEntitiesFound.add(aPlayer);
                    }
                }
            }
            if (!aEntitiesFound.isEmpty()) {
                for (EntityLivingBase aEntity : aEntitiesFound) {
                    BlockPos aPlayerPos = EntityUtils.findBlockPosOfEntity((Entity)aEntity);
                    for (BlockPos aBlockSpaceToCheck : aPositionsToCheck) {
                        if (!aBlockSpaceToCheck.equals(aPlayerPos)) continue;
                        aEntities.add(aEntity);
                    }
                }
            }
        }
        return aEntities;
    }

    private static void generateParticles(EntityLivingBase aEntity) {
        BlockPos aPlayerPosBottom = EntityUtils.findBlockPosOfEntity((Entity)aEntity);
        BlockPos aPlayerPosTop = aPlayerPosBottom.getUp();
        ArrayList<BlockPos> aEntityPositions = new ArrayList<BlockPos>();
        aEntityPositions.add(aPlayerPosBottom);
        aEntityPositions.add(aPlayerPosTop);
        for (int i = 0; i < 64; ++i) {
            BlockPos aEffectPos = (BlockPos)aEntityPositions.get(aEntity.field_70131_O > 1.0f ? MathUtils.randInt(0, 1) : 0);
            float aOffsetX = MathUtils.randFloat(-0.35f, 0.35f);
            float aOffsetY = MathUtils.randFloat(-0.25f, 0.35f);
            float aOffsetZ = MathUtils.randFloat(-0.35f, 0.35f);
            aEntity.field_70170_p.func_72869_a("reddust", (double)((float)aEffectPos.xPos + aOffsetX), (double)((float)aEffectPos.yPos + 0.3f + aOffsetY), (double)((float)aEffectPos.zPos + aOffsetZ), 0.0, 0.0, 0.0);
        }
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public Block getIntakeBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getIntakeMeta() {
        return 1;
    }

    public Block getGearboxBlock() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getGearboxMeta() {
        return 2;
    }

    public byte getCasingTextureIndex() {
        return 66;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIsaMill(this.mName);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIsaMill;
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"IsaMill Grinding Machine", "Current Efficiency: " + this.mEfficiency / 100 + "%", this.getIdealStatus() == this.getRepairStatus() ? "No Maintainance issues" : "Needs Maintainance"};
    }

    @Override
    public String getMachineType() {
        return "Grinding Machine";
    }

    @Override
    public ArrayList<ItemStack> getStoredInputsForColor(Optional<Byte> color) {
        ArrayList<ItemStack> tItems = super.getStoredInputsForColor(color);
        for (MTEHatchMillingBalls tHatch : GTUtility.validMTEList(this.mMillingBallBuses)) {
            ArrayList<ItemStack> aHatchContent;
            byte busColor = tHatch.getBaseMetaTileEntity().getColorization();
            if (color.isPresent() && busColor != -1 && busColor != color.get() || (aHatchContent = tHatch.getContentUsageSlots()).isEmpty()) continue;
            tItems.addAll(aHatchContent);
        }
        return tItems;
    }

    public int getMaxBallDurability(ItemStack aStack) {
        return ItemGenericChemBase.getMaxBallDurability(aStack);
    }

    public static boolean isMillingBall(ItemStack aStack) {
        if (GTUtility.areStacksEqual(aStack, GregtechItemList.Milling_Ball_Alumina.get(1L, new Object[0]), true)) {
            return true;
        }
        return GTUtility.areStacksEqual(aStack, GregtechItemList.Milling_Ball_Soapstone.get(1L, new Object[0]), true);
    }

    private ItemStack findMillingBall(ItemStack[] aItemInputs) {
        if (this.mMillingBallBuses.size() != 1) {
            return null;
        }
        MTEHatchMillingBalls aBus = this.mMillingBallBuses.get(0);
        if (aBus == null) {
            return null;
        }
        ArrayList<ItemStack> aAvailableItems = aBus.getContentUsageSlots();
        if (aAvailableItems.isEmpty()) {
            return null;
        }
        for (ItemStack aInput : aItemInputs) {
            if (!MTEIsaMill.isMillingBall(aInput)) continue;
            for (ItemStack aBall : aAvailableItems) {
                if (!GTUtility.areStacksEqual(aBall, aInput, true)) continue;
                Logger.INFO("Found a valid milling ball to use.");
                return aBall;
            }
        }
        return null;
    }

    private void damageMillingBall(ItemStack aStack) {
        if ((double)(MathUtils.randFloat(0.0f, 1.0E7f) / 1.0E7f) < 1.0000000476837159) {
            int damage = this.getMillingBallDamage(aStack) + 1;
            this.log("damage milling ball " + damage);
            if (damage >= this.getMaxBallDurability(aStack)) {
                this.log("consuming milling ball");
                --aStack.field_77994_a;
            } else {
                this.setDamage(aStack, damage);
            }
        } else {
            this.log("not damaging milling ball");
        }
    }

    private int getMillingBallDamage(ItemStack aStack) {
        return ItemGenericChemBase.getMillingBallDamage(aStack);
    }

    private void setDamage(ItemStack aStack, int aAmount) {
        ItemGenericChemBase.setMillingBallDamage(aStack, aAmount);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            ItemStack millingBall;

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                this.millingBall = MTEIsaMill.this.findMillingBall(this.inputItems);
                if (this.millingBall == null) {
                    return SimpleCheckRecipeResult.ofFailure("no_milling_ball");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            public CheckRecipeResult process() {
                CheckRecipeResult result = super.process();
                if (result.wasSuccessful()) {
                    MTEIsaMill.this.damageMillingBall(this.millingBall);
                }
                return result;
            }
        }.enablePerfectOverclock();
    }
}

