/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.redstone;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.redstone.MTERedstoneStrengthDisplay;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class MTERedstoneStrengthScale
extends MTERedstoneStrengthDisplay {
    public static TexturesGtBlock.CustomIcon[] sIconList = new TexturesGtBlock.CustomIcon[32];

    public MTERedstoneStrengthScale(int aID) {
        super(aID, "redstone.display.scale", "Redstone Scale", "Redstone Strength on a Scale");
    }

    public MTERedstoneStrengthScale(String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTERedstoneStrengthScale(this.mName, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
            this.mType = (byte)((this.mType + 1) % 2);
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(sIconList[this.mType * 16 + this.mRedstoneStrength])};
        }
        return this.mTextures[(aActive || this.hasRedstoneSignal() ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    static {
        for (int i = 0; i < 32; ++i) {
            MTERedstoneStrengthScale.sIconList[i] = new TexturesGtBlock.CustomIcon("TileEntities/gt4/redstone/Scale/" + i);
        }
    }
}

