/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import cpw.mods.fml.common.ModContainer;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.recipe.GTRecipeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGenMultisUsingFluidInsteadOfCells {
    private static final ArrayList<ItemStack> mEmptyItems = new ArrayList();
    private static final ArrayList<ItemStack> mItemsToIgnore = new ArrayList();
    private static boolean mInit = false;

    private static void init() {
        if (!mInit) {
            mInit = true;
            mEmptyItems.add(ItemList.Cell_Empty.get(1L, new Object[0]));
            mEmptyItems.add(new ItemStack(Items.field_151054_z));
            mEmptyItems.add(new ItemStack(Items.field_151133_ar));
            mEmptyItems.add(new ItemStack(Items.field_151069_bo));
            mItemsToIgnore.add(new ItemStack(ItemList.Cell_Empty.get(1L, new Object[0]).func_77973_b(), 1, 8));
        }
    }

    private static boolean doesItemMatchIgnoringStackSize(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b()) {
            return a.func_77960_j() == b.func_77960_j();
        }
        return false;
    }

    private static boolean isEmptyCell(ItemStack aCell) {
        if (aCell == null) {
            return false;
        }
        for (ItemStack emptyItem : mEmptyItems) {
            emptyItem.field_77994_a = aCell.field_77994_a;
            if (!GTUtility.areStacksEqual(emptyItem, aCell)) continue;
            return true;
        }
        return false;
    }

    private static synchronized FluidStack getFluidFromItemStack(ItemStack ingot) {
        if (ingot == null) {
            return null;
        }
        return GTUtility.getFluidForFilledItem(ingot, true);
    }

    public static synchronized int generateRecipesNotUsingCells(RecipeMap<?> aInputs, RecipeMap<?> aOutputs) {
        RecipeGenMultisUsingFluidInsteadOfCells.init();
        int aRecipesHandled = 0;
        int aInvalidRecipesToConvert = 0;
        int aOriginalCount = aInputs.getAllRecipes().size();
        ArrayList<GTRecipe> deDuplicationInputArray = new ArrayList<GTRecipe>();
        block0: for (GTRecipe x : aInputs.getAllRecipes()) {
            if (x != null) {
                int i;
                FluidStack aFoundFluid;
                ItemStack[] aInputItems = (ItemStack[])x.mInputs.clone();
                ItemStack[] aOutputItems = (ItemStack[])x.mOutputs.clone();
                FluidStack[] aInputFluids = (FluidStack[])x.mFluidInputs.clone();
                FluidStack[] aOutputFluids = (FluidStack[])x.mFluidOutputs.clone();
                ArrayList<ItemStack> aInputItemsMap = new ArrayList<ItemStack>();
                ArrayList<ItemStack> aOutputItemsMap = new ArrayList<ItemStack>();
                ArrayList<FluidStack> aInputFluidsMap = new ArrayList<FluidStack>();
                ArrayList<FluidStack> aOutputFluidsMap = new ArrayList<FluidStack>();
                for (ItemStack aInputStack : aInputItems) {
                    aFoundFluid = RecipeGenMultisUsingFluidInsteadOfCells.getFluidFromItemStack(aInputStack);
                    if (aFoundFluid == null) {
                        for (ItemStack aBadStack : mItemsToIgnore) {
                            if (!RecipeGenMultisUsingFluidInsteadOfCells.doesItemMatchIgnoringStackSize(aInputStack, aBadStack)) continue;
                            continue block0;
                        }
                        if (RecipeGenMultisUsingFluidInsteadOfCells.isEmptyCell(aInputStack)) continue;
                        aInputItemsMap.add(aInputStack);
                        continue;
                    }
                    aFoundFluid.amount *= aInputStack.field_77994_a;
                    aInputFluidsMap.add(aFoundFluid);
                }
                for (ItemStack aOutputStack : aOutputItems) {
                    aFoundFluid = RecipeGenMultisUsingFluidInsteadOfCells.getFluidFromItemStack(aOutputStack);
                    if (aFoundFluid == null) {
                        for (ItemStack aBadStack : mItemsToIgnore) {
                            if (!RecipeGenMultisUsingFluidInsteadOfCells.doesItemMatchIgnoringStackSize(aOutputStack, aBadStack)) continue;
                            continue block0;
                        }
                        if (RecipeGenMultisUsingFluidInsteadOfCells.isEmptyCell(aOutputStack)) continue;
                        aOutputItemsMap.add(aOutputStack);
                        continue;
                    }
                    aFoundFluid.amount *= aOutputStack.field_77994_a;
                    aOutputFluidsMap.add(aFoundFluid);
                }
                aInputFluidsMap.addAll(Arrays.asList(aInputFluids));
                aOutputFluidsMap.addAll(Arrays.asList(aOutputFluids));
                ItemStack[] aNewItemInputs = new ItemStack[aInputItemsMap.size()];
                ItemStack[] aNewItemOutputs = new ItemStack[aOutputItemsMap.size()];
                FluidStack[] aNewFluidInputs = new FluidStack[aInputFluidsMap.size()];
                FluidStack[] aNewFluidOutputs = new FluidStack[aOutputFluidsMap.size()];
                for (i = 0; i < aInputItemsMap.size(); ++i) {
                    aNewItemInputs[i] = (ItemStack)aInputItemsMap.get(i);
                }
                for (i = 0; i < aOutputItemsMap.size(); ++i) {
                    aNewItemOutputs[i] = (ItemStack)aOutputItemsMap.get(i);
                }
                for (i = 0; i < aInputFluidsMap.size(); ++i) {
                    aNewFluidInputs[i] = (FluidStack)aInputFluidsMap.get(i);
                }
                for (i = 0; i < aOutputFluidsMap.size(); ++i) {
                    aNewFluidOutputs[i] = (FluidStack)aOutputFluidsMap.get(i);
                }
                if (!ItemUtils.checkForInvalidItems(aNewItemInputs) || !ItemUtils.checkForInvalidItems(aNewItemOutputs)) {
                    ++aInvalidRecipesToConvert;
                    continue;
                }
                GTRecipe aNewRecipe = new GTRecipe(false, aNewItemInputs, aNewItemOutputs, x.mSpecialItems, x.mChances, aNewFluidInputs, aNewFluidOutputs, x.mDuration, x.mEUt, x.mSpecialValue);
                aNewRecipe.owners = x.owners == null ? null : new ArrayList<ModContainer>(x.owners);
                deDuplicationInputArray.add(aNewRecipe);
                ++aRecipesHandled;
                continue;
            }
            ++aInvalidRecipesToConvert;
        }
        List<GTRecipe> deDuplicationOutputArray = GTRecipeUtils.removeDuplicates(deDuplicationInputArray, aOutputs.unlocalizedName);
        for (GTRecipe recipe : deDuplicationOutputArray) {
            aOutputs.add(recipe);
        }
        Logger.INFO("Generated Recipes for " + aOutputs.unlocalizedName);
        Logger.INFO("Original Map contains " + aOriginalCount + " recipes.");
        Logger.INFO("Output Map contains " + aRecipesHandled + " recipes.");
        Logger.INFO("There were " + aInvalidRecipesToConvert + " invalid recipes.");
        return aRecipesHandled;
    }
}

