/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeGenOre
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();
    private static Material mStone;

    public RecipeGenOre(Material M) {
        this(M, false);
    }

    public RecipeGenOre(Material M, boolean O) {
        this.toGenerate = M;
        this.disableOptional = O;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate, this.disableOptional);
    }

    private void generateRecipes(Material material, boolean disableOptional) {
        if (mStone == null) {
            mStone = MaterialUtils.generateMaterialFromGtENUM(Materials.Stone);
        }
        Logger.MATERIALS("[Recipe Generator Debug] [" + material.getLocalizedName() + "]");
        int tVoltageMultiplier = MaterialUtils.getVoltageForTier(material.vTier);
        ItemStack dustStone = ItemUtils.getItemStackOfAmountFromOreDict("dustStone", 1);
        Material bonusA = null;
        Material bonusB = null;
        bonusA = !material.getComposites().isEmpty() && material.getComposites().get(0) != null ? material.getComposites().get(0).getStackMaterial() : material;
        boolean allFailed = false;
        ArrayList<Material> aMatComp = new ArrayList<Material>(MaterialUtils.getCompoundMaterialsRecursively(material));
        if (aMatComp.size() < 3) {
            while (aMatComp.size() < 3) {
                aMatComp.add(material);
            }
        }
        ArrayList<Material> amJ = new ArrayList<Material>();
        boolean aIndexCounter = false;
        for (Material material2 : aMatComp) {
            if (!material2.hasSolidForm() || RecipeGenOre.getDust(material2) == null || RecipeGenOre.getTinyDust(material2) == null) continue;
            amJ.add(material2);
        }
        if (amJ.size() < 2) {
            if (material.getComposites().size() >= 2 && material.getComposites().get(1) != null) {
                bonusB = material.getComposites().get(1).getStackMaterial();
                if (!(bonusB.hasSolidForm() || material.getComposites().size() < 3 || material.getComposites().get(2) == null || (bonusB = material.getComposites().get(2).getStackMaterial()).hasSolidForm() || material.getComposites().size() < 4 || material.getComposites().get(3) == null || (bonusB = material.getComposites().get(3).getStackMaterial()).hasSolidForm() || material.getComposites().size() < 5 || material.getComposites().get(4) == null || (bonusB = material.getComposites().get(4).getStackMaterial()).hasSolidForm())) {
                    allFailed = true;
                    bonusB = mStone;
                }
            } else {
                allFailed = true;
            }
        } else {
            bonusA = (Material)amJ.get(0);
            bonusB = (Material)amJ.get(1);
        }
        if (bonusA == null) {
            Material material3 = bonusA = tVoltageMultiplier > 100 ? material : mStone;
        }
        if (allFailed || bonusB == null) {
            bonusB = tVoltageMultiplier > 100 ? material : mStone;
        }
        ArrayList<Pair> componentMap = new ArrayList<Pair>();
        for (MaterialStack r : material.getComposites()) {
            if (r == null) continue;
            componentMap.add(Pair.of((Object)r.getPartsPerOneHundred(), (Object)r.getStackMaterial()));
        }
        if (bonusA == null || bonusB == null || !bonusA.hasSolidForm() || !bonusB.hasSolidForm()) {
            if (bonusA == null) {
                bonusA = mStone;
            }
            if (bonusB == null) {
                bonusB = mStone;
            }
            if (!bonusA.hasSolidForm()) {
                bonusA = mStone;
            }
            if (!bonusB.hasSolidForm()) {
                bonusB = mStone;
            }
        }
        ItemStack itemStack = RecipeGenOre.getDust(material);
        ItemStack matDustA = RecipeGenOre.getDust(bonusA);
        ItemStack matDustB = RecipeGenOre.getDust(bonusB);
        GTValues.RA.stdBuilder().itemInputs(material.getOre(1)).itemOutputs(material.getCrushed(2)).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate ore to Crushed ore'");
        GTValues.RA.stdBuilder().itemInputs(material.getRawOre(1)).itemOutputs(material.getCrushed(2)).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate raw ore to Crushed ore'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushed(1)).itemOutputs(material.getDustImpure(1), matDustA).outputChances(10000, 1000).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Crushed ore to Impure Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedPurified(1)).itemOutputs(material.getDustPurified(1), matDustA).outputChances(10000, 1000).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Washed ore to Purified Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedCentrifuged(1)).itemOutputs(itemStack, matDustA).outputChances(10000, 1000).duration(400).eut(tVoltageMultiplier / 2).addTo(RecipeMaps.maceratorRecipes);
        Logger.MATERIALS("[Macerator] Added Recipe: 'Macerate Centrifuged ore to Pure Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushed(1)).itemOutputs(material.getCrushedPurified(1), matDustA, dustStone).outputChances(10000, 1111, 10000).fluidInputs(Materials.Water.getFluid(1000L)).duration(500).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.getCrushed(1)).itemOutputs(material.getCrushedPurified(1), matDustA, dustStone).outputChances(10000, 1111, 10000).fluidInputs(GTModHandler.getDistilledWater(200L)).duration(300).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        Logger.MATERIALS("[OreWasher] Added Recipe: 'Wash Crushed ore into Purified Crushed ore'");
        Logger.MATERIALS("material.getCrushed(1): " + (material.getCrushed(1) != null));
        Logger.MATERIALS("material.getCrushedPurified(1): " + (material.getCrushedPurified(1) != null));
        Logger.MATERIALS("material.getTinyDust(1): " + ItemUtils.getItemName(bonusA.getCrushed(1)));
        Logger.MATERIALS("material.getTinyDust(1): " + ItemUtils.getItemName(bonusB.getCrushed(1)));
        GTValues.RA.stdBuilder().itemInputs(material.getCrushed(1)).itemOutputs(material.getCrushedCentrifuged(1), matDustB, dustStone).outputChances(10000, 1111, 10000).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        Logger.MATERIALS("[ThermalCentrifuge] Added Recipe: 'Crushed ore to Centrifuged Ore' | Input: " + material.getCrushed(1).func_82833_r() + " | Outputs: " + material.getCrushedCentrifuged(1).func_82833_r() + ", " + matDustB.func_82833_r() + ", " + dustStone.func_82833_r() + ".");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedPurified(1)).itemOutputs(material.getCrushedCentrifuged(1), matDustA, dustStone).outputChances(10000, 1111, 10000).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        Logger.MATERIALS("[ThermalCentrifuge] Added Recipe: 'Washed ore to Centrifuged Ore' | Input: " + material.getCrushedPurified(1).func_82833_r() + " | Outputs: " + material.getCrushedCentrifuged(1).func_82833_r() + ", " + matDustA.func_82833_r() + ", " + dustStone.func_82833_r() + ".");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedCentrifuged(1)).itemOutputs(itemStack).duration(10).eut(tVoltageMultiplier / 4).addTo(RecipeMaps.hammerRecipes);
        Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Crushed Centrifuged to Pure Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getCrushedPurified(1)).itemOutputs(material.getDustPurified(1)).duration(10).eut(tVoltageMultiplier / 4).addTo(RecipeMaps.hammerRecipes);
        Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Crushed Purified to Purified Dust'");
        GTValues.RA.stdBuilder().itemInputs(material.getOre(1)).itemOutputs(material.getCrushed(1)).duration(10).eut(tVoltageMultiplier / 4).addTo(RecipeMaps.hammerRecipes);
        Logger.MATERIALS("[ForgeHammer] Added Recipe: 'Ore to Crushed'");
        GTValues.RA.stdBuilder().itemInputs(material.getDustPurified(1)).itemOutputs(itemStack, matDustA).outputChances(10000, 1111).eut(tVoltageMultiplier / 2).duration((int)Math.max(1L, material.getMass() * 8L)).addTo(RecipeMaps.centrifugeRecipes);
        Logger.MATERIALS("[Centrifuge] Added Recipe: Purified Dust to Clean Dust");
        GTValues.RA.stdBuilder().itemInputs(material.getDustImpure(1)).itemOutputs(itemStack, matDustB).outputChances(10000, 1111).eut(tVoltageMultiplier / 2).duration((int)Math.max(1L, material.getMass() * 8L)).addTo(RecipeMaps.centrifugeRecipes);
        Logger.MATERIALS("[Centrifuge] Added Recipe: Inpure Dust to Clean Dust");
        if (!disableOptional) {
            int[] mChances;
            ItemStack[] mInternalOutputs;
            if (!componentMap.isEmpty() && componentMap.size() <= 6) {
                ItemStack mainDust;
                mInternalOutputs = new ItemStack[6];
                mChances = new int[6];
                int mCellCount = 0;
                int mTotalCount = 0;
                int mCounter = 0;
                for (Pair f : componentMap) {
                    if (((Material)f.getValue()).getState() != MaterialState.SOLID) {
                        Logger.MATERIALS("[Electrolyzer] Found Fluid Component, adding " + f.getKey() + " cells of " + ((Material)f.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)f.getValue()).getCell((Integer)f.getKey());
                        mTotalCount += ((Integer)f.getKey()).intValue();
                        Logger.MATERIALS("[Electrolyzer] In total, adding " + (mCellCount += ((Integer)f.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                        continue;
                    }
                    Logger.MATERIALS("[Electrolyzer] Found Solid Component, adding " + f.getKey() + " dusts of " + ((Material)f.getValue()).getLocalizedName() + ".");
                    mInternalOutputs[mCounter++] = ((Material)f.getValue()).getDust((Integer)f.getKey());
                    mTotalCount += ((Integer)f.getKey()).intValue();
                }
                for (int g = 0; g < mInternalOutputs.length; ++g) {
                    Logger.MATERIALS("[Electrolyzer] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                    mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                }
                ItemStack emptyCell = null;
                if (mCellCount > 0) {
                    emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                    Logger.MATERIALS("[Electrolyzer] Recipe now requires " + mCellCount + " empty cells as input.");
                }
                if ((mainDust = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                    Logger.MATERIALS("[Electrolyzer] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + mainDust.func_82833_r() + " as input.");
                } else {
                    mainDust = material.getDust(mTotalCount);
                    Logger.MATERIALS("[Electrolyzer] Could not find valid input dust, trying alternative.");
                    if (mainDust != null) {
                        Logger.MATERIALS("[Electrolyzer] Recipe now requires " + mTotalCount + "x " + mainDust.func_82833_r() + " as input.");
                    } else {
                        Logger.MATERIALS("[Electrolyzer] Could not find valid input dust, exiting.");
                        return;
                    }
                }
                for (int j = 0; j < mInternalOutputs.length; ++j) {
                    if (mInternalOutputs[j] == null) {
                        mInternalOutputs[j] = GTValues.NI;
                        Logger.MATERIALS("[Electrolyzer] Set slot " + j + "  to null.");
                        continue;
                    }
                    Logger.MATERIALS("[Electrolyzer] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                }
                ArrayList<ItemStack> internalOutputs = new ArrayList<ItemStack>(Arrays.asList(mInternalOutputs));
                internalOutputs.removeIf(Objects::isNull);
                int[] chances = new int[internalOutputs.size()];
                System.arraycopy(mChances, 0, chances, 0, internalOutputs.size());
                ItemStack[] inputs = emptyCell == null ? new ItemStack[]{mainDust} : new ItemStack[]{mainDust, emptyCell};
                GTValues.RA.stdBuilder().itemInputs(inputs).itemOutputs(internalOutputs.toArray(new ItemStack[0])).outputChances(chances).duration(Math.max(material.getMass() * 3L * 1L, 1L)).eut(tVoltageMultiplier).addTo(RecipeMaps.electrolyzerRecipes);
                Logger.MATERIALS("[Electrolyzer] Generated Electrolyzer recipe for " + itemStack.func_82833_r());
            } else if (componentMap.size() > 6 && componentMap.size() <= 9) {
                ItemStack mainDust;
                Logger.MATERIALS("[Issue][Electrolyzer] " + material.getLocalizedName() + " is composed of over 6 materials, so an electrolyzer recipe for processing cannot be generated. Trying to create one for the Dehydrator instead.");
                mInternalOutputs = new ItemStack[9];
                mChances = new int[9];
                int mCellCount = 0;
                int mTotalCount = 0;
                int mCounter = 0;
                for (Pair f : componentMap) {
                    if (((Material)f.getValue()).getState() != MaterialState.SOLID && ((Material)f.getValue()).getState() != MaterialState.ORE) {
                        Logger.MATERIALS("[Dehydrator] Found Fluid Component, adding " + f.getKey() + " cells of " + ((Material)f.getValue()).getLocalizedName() + ".");
                        mInternalOutputs[mCounter++] = ((Material)f.getValue()).getCell((Integer)f.getKey());
                        mTotalCount += ((Integer)f.getKey()).intValue();
                        Logger.MATERIALS("[Dehydrator] In total, adding " + (mCellCount += ((Integer)f.getKey()).intValue()) + " cells for " + material.getLocalizedName() + " processing.");
                        continue;
                    }
                    Logger.MATERIALS("[Dehydrator] Found Solid Component, adding " + f.getKey() + " dusts of " + ((Material)f.getValue()).getLocalizedName() + ".");
                    mInternalOutputs[mCounter++] = ((Material)f.getValue()).getDust((Integer)f.getKey());
                    mTotalCount += ((Integer)f.getKey()).intValue();
                }
                for (int g = 0; g < mInternalOutputs.length; ++g) {
                    Logger.MATERIALS("[Dehydrator] Is output[" + g + "] valid with a chance? " + (mInternalOutputs[g] != null ? 10000 : 0));
                    mChances[g] = mInternalOutputs[g] != null ? 10000 : 0;
                }
                ItemStack emptyCell = null;
                if (mCellCount > 0) {
                    emptyCell = ItemUtils.getItemStackOfAmountFromOreDict("cellEmpty", mCellCount);
                    Logger.MATERIALS("[Dehydrator] Recipe now requires " + mCellCount + " empty cells as input.");
                }
                if ((mainDust = material.getDust(material.smallestStackSizeWhenProcessing)) != null) {
                    Logger.MATERIALS("[Dehydrator] Recipe now requires " + material.smallestStackSizeWhenProcessing + "x " + mainDust.func_82833_r() + " as input.");
                } else {
                    mainDust = material.getDust(mTotalCount);
                    Logger.MATERIALS("[Dehydrator] Could not find valid input dust, trying alternative.");
                    if (mainDust != null) {
                        Logger.MATERIALS("[Dehydrator] Recipe now requires " + mTotalCount + "x " + mainDust.func_82833_r() + " as input.");
                    } else {
                        Logger.MATERIALS("[Dehydrator] Could not find valid input dust, exiting.");
                        return;
                    }
                }
                for (int j = 0; j < mInternalOutputs.length; ++j) {
                    if (mInternalOutputs[j] == null) {
                        mInternalOutputs[j] = GTValues.NI;
                        Logger.MATERIALS("[Dehydrator] Set slot " + j + "  to null.");
                        continue;
                    }
                    Logger.MATERIALS("[Dehydrator] Set slot " + j + " to " + mInternalOutputs[j].func_82833_r() + ".");
                }
                ArrayList<ItemStack> internalOutputs = new ArrayList<ItemStack>(Arrays.asList(mInternalOutputs));
                internalOutputs.removeIf(Objects::isNull);
                int[] chances = new int[internalOutputs.size()];
                System.arraycopy(mChances, 0, chances, 0, internalOutputs.size());
                ItemStack[] inputs = emptyCell == null ? new ItemStack[]{mainDust} : new ItemStack[]{mainDust, emptyCell};
                GTValues.RA.stdBuilder().itemInputs(inputs).itemOutputs(internalOutputs.toArray(new ItemStack[0])).outputChances(chances).eut(tVoltageMultiplier).duration((int)Math.max(material.getMass() * 4L * 1L, 1L)).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
                Logger.MATERIALS("[Dehydrator] Generated Dehydrator recipe for " + itemStack.func_82833_r());
                Logger.MATERIALS("Inputs: " + mainDust.func_82833_r() + " x" + mainDust.field_77994_a + ", " + (emptyCell == null ? "No Cells" : emptyCell.func_82833_r() + " x" + emptyCell.field_77994_a));
                Logger.MATERIALS("Outputs " + ItemUtils.getArrayStackNames(mInternalOutputs));
                Logger.MATERIALS("Time: " + (int)Math.max(material.getMass() * 4L * 1L, 1L));
                Logger.MATERIALS("EU: " + tVoltageMultiplier);
            }
        }
        RecipeUtils.addShapedRecipe(ToolDictNames.craftingToolHardHammer.name(), null, null, material.getCrushedPurified(1), null, null, null, null, null, material.getDustPurified(1));
        RecipeUtils.addShapedRecipe(ToolDictNames.craftingToolHardHammer.name(), null, null, material.getCrushed(1), null, null, null, null, null, material.getDustImpure(1));
        RecipeUtils.addShapedRecipe(ToolDictNames.craftingToolHardHammer.name(), null, null, material.getCrushedCentrifuged(1), null, null, null, null, null, itemStack);
        ItemStack smallDust = material.getSmallDust(1);
        ItemStack tinyDust = material.getTinyDust(1);
        if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, itemStack)) {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(itemStack, null, null, null, null, null, null, null, null, material.getTinyDust(9))) {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("9 Tiny dust from 1 Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, itemStack)) {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust to 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
        if (RecipeUtils.addShapedRecipe(null, itemStack, null, null, null, null, null, null, null, material.getSmallDust(4))) {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Success");
        } else {
            Logger.WARNING("4 Small dust from 1 Dust Recipe: " + material.getLocalizedName() + " - Failed");
        }
    }

    public static ItemStack getTinyDust(Material m) {
        ItemStack x = m.getTinyDust(1);
        if (x == null) {
            x = mStone.getDust(1);
        }
        return x;
    }

    public static ItemStack getDust(Material m) {
        ItemStack x = m.getDust(1);
        if (x == null) {
            x = mStone.getDust(1);
        }
        return x;
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

