/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGenBase;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class RecipeGenPlates
extends RecipeGenBase {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGenPlates(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateRecipes(this.toGenerate);
    }

    private void generateRecipes(Material material) {
        ItemStack ingotStackOne = material.getIngot(1);
        ItemStack ingotStackTwo = material.getIngot(2);
        ItemStack ingotStackThree = material.getIngot(3);
        ItemStack ingotStackNine = material.getIngot(9);
        ItemStack shape_Mold = ItemList.Shape_Mold_Plate.get(0L, new Object[0]);
        ItemStack plate_Single = material.getPlate(1);
        ItemStack plate_SingleTwo = material.getPlate(2);
        ItemStack plate_SingleNine = material.getPlate(9);
        ItemStack plate_Double = material.getPlateDouble(1);
        ItemStack plate_Dense = material.getPlateDense(1);
        ItemStack foil_SingleFour = material.getFoil(4);
        ItemStack block = material.getBlock(1);
        Logger.WARNING("Generating Plate recipes for " + material.getLocalizedName());
        if (ingotStackTwo != null && plate_Single != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackThree).itemOutputs(plate_SingleTwo).duration(Math.max(material.getMass(), 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.hammerRecipes);
            Logger.WARNING("Forge Hammer Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ingotStackOne != null && plate_Single != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackOne, GTUtility.getIntegratedCircuit(1)).itemOutputs(plate_Single).duration(Math.max(material.getMass() * 1L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ingotStackOne != null && foil_SingleFour != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackOne, GTUtility.getIntegratedCircuit(10)).itemOutputs(foil_SingleFour).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ingotStackTwo != null && plate_Single != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackTwo, shape_Mold).itemOutputs(plate_Single).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.alloySmelterRecipes);
            Logger.WARNING("Alloy Smelter Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (block != null && plate_Single != null) {
            GTValues.RA.stdBuilder().itemInputs(block).itemOutputs(plate_SingleNine).duration(Math.max(material.getMass() * 10L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.cutterRecipes);
            Logger.WARNING("Cutting Machine Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ingotStackTwo != null && plate_Double != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackTwo, GTUtility.getIntegratedCircuit(2)).itemOutputs(plate_Double).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (plate_SingleTwo != null && plate_Double != null) {
            GTValues.RA.stdBuilder().itemInputs(plate_SingleTwo, GTUtility.getIntegratedCircuit(2)).itemOutputs(plate_Double).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (material.getPlate(1) != null && material.getFoil(1) != null) {
            GTValues.RA.stdBuilder().itemInputs(material.getPlate(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(material.getFoil(4)).duration(Math.max(material.getMass(), 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            CoverRegistry.registerDecorativeCover(material.getFoil(1), TextureFactory.of(material.getTextureSet().mTextures[70], material.getRGBA(), false));
            Logger.WARNING("Bender Foil Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (ingotStackNine != null && plate_Dense != null) {
            GTValues.RA.stdBuilder().itemInputs(ingotStackNine, GTUtility.getIntegratedCircuit(9)).itemOutputs(plate_Dense).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
        if (plate_SingleNine != null && plate_Dense != null) {
            GTValues.RA.stdBuilder().itemInputs(plate_SingleNine, GTUtility.getIntegratedCircuit(9)).itemOutputs(plate_Dense).duration(Math.max(material.getMass() * 2L, 1L)).eut(material.vVoltageMultiplier).addTo(RecipeMaps.benderRecipes);
            Logger.WARNING("Bender Recipe: " + material.getLocalizedName() + " - Success");
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.add(mRecipeGenMap);
    }
}

