/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.CircuitGeneration;

import bartworks.API.recipe.BWNBTDependantCraftingRecipe;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.system.material.CircuitGeneration.BWMetaItems;
import bartworks.system.material.CircuitGeneration.CircuitData;
import bartworks.system.material.WerkstoffLoader;
import bartworks.util.BWUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialsAlloy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.tuple.Pair;

public class CircuitImprintLoader {
    public static short reverseIDs = (short)32766;
    public static final ArrayListMultimap<NBTTagCompound, GTRecipe> recipeTagMap = ArrayListMultimap.create();
    public static final HashBiMap<Short, ItemList> circuitIIconRefs = HashBiMap.create((int)20);
    public static final HashSet<ItemStack> blacklistSet = new HashSet();
    static final HashBiMap<CircuitData, ItemStack> bwCircuitTagMap = HashBiMap.create((int)20);
    private static final HashSet<IRecipe> recipeWorldCache = new HashSet();
    private static final HashSet<GTRecipe> gtrecipeWorldCache = new HashSet();
    private static final HashSet<GTRecipe> ORIGINAL_CAL_RECIPES = new HashSet();
    private static final HashSet<GTRecipe> MODIFIED_CAL_RECIPES = new HashSet();
    private static final List<Pair<ItemStack, ItemStack>> circuitPartsToReplace = Collections.unmodifiableList(Arrays.asList(Pair.of((Object)ItemList.Circuit_Parts_Resistor.get(1L, new Object[0]), (Object)ItemList.Circuit_Parts_ResistorSMD.get(1L, new Object[0])), Pair.of((Object)ItemList.Circuit_Parts_Diode.get(1L, new Object[0]), (Object)ItemList.Circuit_Parts_DiodeSMD.get(1L, new Object[0])), Pair.of((Object)ItemList.Circuit_Parts_Transistor.get(1L, new Object[0]), (Object)ItemList.Circuit_Parts_TransistorSMD.get(1L, new Object[0])), Pair.of((Object)ItemList.Circuit_Parts_Capacitor.get(1L, new Object[0]), (Object)ItemList.Circuit_Parts_CapacitorSMD.get(1L, new Object[0])), Pair.of((Object)ItemList.Circuit_Parts_Coil.get(1L, new Object[0]), (Object)ItemList.Circuit_Parts_InductorSMD.get(1L, new Object[0]))));

    public static void run() {
        HashSet<GTRecipe> toRem = new HashSet<GTRecipe>();
        HashSet<GTRecipe> toAdd = new HashSet<GTRecipe>();
        CircuitImprintLoader.deleteCALRecipesAndTags();
        CircuitImprintLoader.rebuildCircuitAssemblerMap(toRem, toAdd);
        CircuitImprintLoader.exchangeRecipesInList(toRem, toAdd);
        CircuitImprintLoader.makeCircuitImprintRecipes();
    }

    private static void reAddOriginalRecipes() {
        RecipeMaps.circuitAssemblerRecipes.getBackend().removeRecipes(MODIFIED_CAL_RECIPES);
        ORIGINAL_CAL_RECIPES.forEach(RecipeMaps.circuitAssemblerRecipes::add);
        ORIGINAL_CAL_RECIPES.clear();
        MODIFIED_CAL_RECIPES.clear();
    }

    private static void rebuildCircuitAssemblerMap(HashSet<GTRecipe> toRem, HashSet<GTRecipe> toAdd) {
        CircuitImprintLoader.reAddOriginalRecipes();
        RecipeMaps.circuitAssemblerRecipes.getAllRecipes().forEach(e -> CircuitImprintLoader.handleCircuitRecipeRebuilding(e, toRem, toAdd));
    }

    private static void handleCircuitRecipeRebuilding(GTRecipe circuitRecipe, HashSet<GTRecipe> toRem, HashSet<GTRecipe> toAdd) {
        ItemStack[] outputs = circuitRecipe.mOutputs;
        boolean isOrePass = CircuitImprintLoader.isCircuitOreDict(outputs[0]);
        String unlocalizedName = outputs[0].func_77977_a();
        if (isOrePass || unlocalizedName.contains("Circuit") || unlocalizedName.contains("circuit")) {
            recipeTagMap.put((Object)CircuitImprintLoader.getTagFromStack(outputs[0]), (Object)circuitRecipe.copy());
            if (circuitRecipe.mFluidInputs[0].isFluidEqual(Materials.SolderingAlloy.getMolten(0L)) || circuitRecipe.mFluidInputs[0].isFluidEqual(MaterialsAlloy.INDALLOY_140.getFluidStack(0)) || circuitRecipe.mFluidInputs[0].isFluidEqual(MaterialMisc.MUTATED_LIVING_SOLDER.getFluidStack(0))) {
                GTRecipe newRecipe = CircuitImprintLoader.reBuildRecipe(circuitRecipe);
                if (newRecipe != null) {
                    BartWorksRecipeMaps.circuitAssemblyLineRecipes.addRecipe(newRecipe);
                }
                CircuitImprintLoader.addCutoffRecipeToSets(toRem, toAdd, circuitRecipe);
            } else if ((long)circuitRecipe.mEUt > TierEU.IV) {
                toRem.add(circuitRecipe);
            }
        }
    }

    private static boolean isCircuitOreDict(ItemStack item) {
        return BWUtil.isTieredCircuit(item) || BWUtil.getOreNames(item).stream().anyMatch(s -> "circuitPrimitiveArray".equals(s));
    }

    private static void exchangeRecipesInList(HashSet<GTRecipe> toRem, HashSet<GTRecipe> toAdd) {
        toAdd.forEach(RecipeMaps.circuitAssemblerRecipes::add);
        RecipeMaps.circuitAssemblerRecipes.getBackend().removeRecipes(toRem);
        ORIGINAL_CAL_RECIPES.addAll(toRem);
        MODIFIED_CAL_RECIPES.addAll(toAdd);
    }

    private static void addCutoffRecipeToSets(HashSet<GTRecipe> toRem, HashSet<GTRecipe> toAdd, GTRecipe circuitRecipe) {
        if ((long)circuitRecipe.mEUt > TierEU.IV) {
            toRem.add(circuitRecipe);
            toAdd.add(CircuitImprintLoader.makeMoreExpensive(circuitRecipe));
        }
    }

    public static GTRecipe makeMoreExpensive(GTRecipe original) {
        GTRecipe newRecipe = original.copy();
        for (ItemStack is : newRecipe.mInputs) {
            if (BWUtil.isTieredCircuit(is)) continue;
            is.field_77994_a = Math.min(is.field_77994_a * 6, 64);
            if (is.field_77994_a <= is.func_77973_b().func_77639_j() && is.field_77994_a <= is.func_77976_d()) continue;
            is.field_77994_a = is.func_77976_d();
        }
        newRecipe.mFluidInputs[0].amount *= 4;
        newRecipe.mDuration *= 4;
        return newRecipe;
    }

    public static GTRecipe reBuildRecipe(GTRecipe original) {
        ItemStack[] in = new ItemStack[6];
        BiMap inversed = circuitIIconRefs.inverse();
        for (int i = 0; i < 6; ++i) {
            try {
                CircuitImprintLoader.replaceCircuits((BiMap<ItemList, Short>)inversed, original, in, i);
                CircuitImprintLoader.replaceComponents(in, original, i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        if (CircuitImprintLoader.checkForBlacklistedComponents(in)) {
            return null;
        }
        return new GTRecipe(false, in, new ItemStack[]{CircuitImprintLoader.getOutputMultiplied(original)}, BWMetaItems.getCircuitParts().getStackWithNBT(CircuitImprintLoader.getTagFromStack(original.mOutputs[0]), 0, 0), null, original.mFluidInputs, null, original.mDuration * 12, original.mEUt, 0);
    }

    private static ItemStack getOutputMultiplied(GTRecipe original) {
        ItemStack out = original.copy().getOutput(0);
        out.field_77994_a *= 16;
        return out;
    }

    private static void replaceCircuits(BiMap<ItemList, Short> inversed, GTRecipe original, ItemStack[] in, int index) {
        for (ItemList il : inversed.keySet()) {
            if (!GTUtility.areStacksEqual(il.get(1L, new Object[0]), CircuitImprintLoader.replaceCircuitParts(original.mInputs[index]))) continue;
            in[index] = BWMetaItems.getCircuitParts().getStack(((Short)inversed.get((Object)il)).shortValue(), original.mInputs[index].field_77994_a);
        }
    }

    private static ItemStack replaceCircuitParts(ItemStack stack) {
        for (Pair<ItemStack, ItemStack> pair : circuitPartsToReplace) {
            if (!GTUtility.areStacksEqual((ItemStack)pair.getKey(), stack)) continue;
            ItemStack newStack = (ItemStack)pair.getValue();
            newStack.field_77994_a = stack.field_77994_a;
            return newStack;
        }
        return stack;
    }

    private static void replaceComponents(ItemStack[] in, GTRecipe original, int index) throws ArrayIndexOutOfBoundsException {
        if (original.mInputs[index] != null && in[index] == null) {
            if (BWUtil.checkStackAndPrefix(original.mInputs[index]) && GTOreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireGt01) {
                in[index] = GTOreDictUnificator.get(OrePrefixes.wireGt16, GTOreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].field_77994_a);
            } else if (BWUtil.checkStackAndPrefix(original.mInputs[index]) && GTOreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireFine) {
                in[index] = GTOreDictUnificator.get(OrePrefixes.wireGt04, GTOreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].field_77994_a);
                if (in[index] == null) {
                    in[index] = GTOreDictUnificator.get(OrePrefixes.wireFine, GTOreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].field_77994_a * 16L);
                }
            } else {
                in[index] = original.mInputs[index].func_77946_l();
                in[index].field_77994_a *= 16;
                if (in[index].field_77994_a > in[index].func_77973_b().func_77639_j() || in[index].field_77994_a > in[index].func_77976_d()) {
                    in[index].field_77994_a = in[index].func_77976_d();
                }
            }
        }
    }

    private static void makeCircuitImprintRecipes() {
        CircuitImprintLoader.removeOldRecipesFromRegistries();
        recipeTagMap.keySet().forEach(e -> {
            CircuitImprintLoader.makeAndAddSlicingRecipe(e);
            CircuitImprintLoader.makeAndAddCraftingRecipes(e);
        });
    }

    private static boolean checkForBlacklistedComponents(ItemStack[] itemStacks) {
        for (ItemStack is : itemStacks) {
            for (ItemStack is2 : blacklistSet) {
                if (!GTUtility.areStacksEqual(is, is2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void removeOldRecipesFromRegistries() {
        recipeWorldCache.forEach(CraftingManager.func_77594_a().func_77592_b()::remove);
        RecipeMaps.slicerRecipes.getBackend().removeRecipes(gtrecipeWorldCache);
        GTModHandler.sBufferRecipeList.removeAll(recipeWorldCache);
        recipeWorldCache.clear();
        gtrecipeWorldCache.clear();
    }

    private static void makeAndAddSlicingRecipe(NBTTagCompound tag) {
        ItemStack stack = CircuitImprintLoader.getStackFromTag(tag);
        int eut = Integer.MAX_VALUE;
        for (GTRecipe recipe : recipeTagMap.get((Object)tag)) {
            eut = Math.min(eut, recipe.mEUt);
        }
        eut = Math.min(eut, BWUtil.getMachineVoltageFromTier(BWUtil.getCircuitTierFromOreDictName(OreDictionary.getOreName((int)(OreDictionary.getOreIDs((ItemStack)stack) != null && OreDictionary.getOreIDs((ItemStack)stack).length > 0 ? OreDictionary.getOreIDs((ItemStack)stack)[0] : -1)))));
        GTRecipe slicingRecipe = new GTRecipe(true, new ItemStack[]{stack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])}, new ItemStack[]{BWMetaItems.getCircuitParts().getStackWithNBT(tag, 1, 1)}, null, null, null, null, 300, eut, -200);
        gtrecipeWorldCache.add(slicingRecipe);
        RecipeMaps.slicerRecipes.add(slicingRecipe);
    }

    private static void makeAndAddCraftingRecipes(NBTTagCompound tag) {
        ItemStack circuit = BWMetaItems.getCircuitParts().getStackWithNBT(tag, 0, 1);
        Object[] imprintRecipe = new Object[]{" X ", "GPG", " X ", Character.valueOf('P'), BWMetaItems.getCircuitParts().getStackWithNBT(tag, 1, 1), Character.valueOf('G'), WerkstoffLoader.Prasiolite.get(OrePrefixes.gemExquisite, 1), Character.valueOf('X'), BWMetaItems.getCircuitParts().getStack(3)};
        BWNBTDependantCraftingRecipe bwrecipe = new BWNBTDependantCraftingRecipe(circuit, imprintRecipe);
        ShapedOreRecipe gtrecipe = BWUtil.createGTCraftingRecipe(circuit, GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GTModHandler.RecipeBits.KEEPNBT | GTModHandler.RecipeBits.BUFFERED, imprintRecipe);
        recipeWorldCache.add(bwrecipe);
        GameRegistry.addRecipe((IRecipe)bwrecipe);
        recipeWorldCache.add((IRecipe)gtrecipe);
        GameRegistry.addRecipe((IRecipe)gtrecipe);
    }

    public static NBTTagCompound getTagFromStack(ItemStack stack) {
        if (GTUtility.isStackValid(stack)) {
            return BWUtil.setStackSize(stack.func_77946_l(), 1).func_77955_b(new NBTTagCompound());
        }
        return new NBTTagCompound();
    }

    public static ItemStack getStackFromTag(NBTTagCompound tagCompound) {
        return ItemStack.func_77949_a((NBTTagCompound)tagCompound);
    }

    private static void deleteCALRecipesAndTags() {
        BartWorksRecipeMaps.circuitAssemblyLineRecipes.getBackend().clearRecipes();
        recipeTagMap.clear();
    }
}

