/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory.standard;

import gregtech.api.factory.IFactoryElement;
import gregtech.api.factory.IFactoryGrid;
import gregtech.api.factory.IFactoryNetwork;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class StandardFactoryNetwork<TSelf extends IFactoryNetwork<TSelf, TElement, TGrid>, TElement extends IFactoryElement<TElement, TSelf, TGrid>, TGrid extends IFactoryGrid<TGrid, TElement, TSelf>>
implements IFactoryNetwork<TSelf, TElement, TGrid> {
    public final HashSet<TElement> elements = new HashSet();
    public final HashMap<Class<?>, Collection<Object>> components = new HashMap();

    @Override
    public void addElement(TElement element) {
        this.elements.add(element);
        for (Pair<Class<?>, Object> component : element.getComponents()) {
            this.addComponentImpl((Class)component.left(), component.right());
        }
    }

    @Override
    public void removeElement(TElement element) {
        this.elements.remove(element);
        if (element != null && element.getNetwork() == this) {
            for (Pair<Class<?>, Object> component : element.getComponents()) {
                this.removeComponentImpl((Class)component.left(), component.right());
            }
        }
    }

    private void addComponentImpl(Class<?> iface, Object impl) {
        this.components.computeIfAbsent(iface, x -> new HashSet()).add(impl);
    }

    public <TIface, TImpl extends TIface> void addComponent(Class<TIface> iface, TImpl impl) {
        this.addComponentImpl(iface, impl);
    }

    private void removeComponentImpl(Class<?> iface, Object impl) {
        Collection<Object> s = this.components.get(iface);
        if (s != null) {
            s.remove(impl);
            if (s.isEmpty()) {
                this.components.remove(iface);
            }
        }
    }

    public <TIface, TImpl extends TIface> void removeComponent(Class<TIface> iface, TImpl impl) {
        this.removeComponentImpl(iface, impl);
    }

    public <TIface> Collection<TIface> getComponents(Class<TIface> iface) {
        return this.components.getOrDefault(iface, Collections.emptyList());
    }

    @Override
    public Collection<TElement> getElements() {
        return this.elements;
    }
}

